package com.aitime.android.payment;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;

import androidx.annotation.NonNull;

/**
 * LinkUrl handler based on {@code Browser}
 */
public class BrowserLinkUrlHandler implements ILinkUrlHandler {

    @Override
    public void openLinkUrl(@NonNull Activity activity, @NonNull String linkUrl) {
        Uri uri = Uri.parse(linkUrl);
        Intent intent = new Intent(Intent.ACTION_VIEW, uri);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        activity.startActivity(intent);
    }

}
