/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.nbu.paisa.inapp.client.api;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.RawRes;
import android.support.v4.app.Fragment;
import android.util.Base64;
import android.util.Log;
import com.google.android.apps.nbu.paisa.inapp.aidl.IIsReadyToPayService;
import com.google.android.apps.nbu.paisa.inapp.aidl.IIsReadyToPayServiceCallback;
import com.google.android.apps.nbu.paisa.inapp.aidl.IsReadyToPayRequest;
import com.google.android.apps.nbu.paisa.inapp.client.api.GooglePayPackageInfo;
import com.google.android.apps.nbu.paisa.inapp.client.api.R;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

@SuppressLint(value={"PackageManagerGetSignatures"})
public final class PaymentsClient {
    private static final String GOOGLE_PAY_IN_APP_LOG_TAG = "GooglePayInApp";
    private static final String GOOGLE_PAY_LOAD_PAYMENT_ACTION = "com.google.android.apps.nbu.paisa.user.LOAD_PAYMENT_DATA";
    private static final String GOOGLE_PAY_SDK_SERVICE = "com.google.android.apps.nbu.paisa.user.inapp.sdk.service.IS_READY_TO_PAY";
    private GooglePayPackageInfo googlePayPackageInfo;

    public Task<Boolean> isReadyToPay(Context context, String paymentDataRequest) throws NoSuchAlgorithmException {
        TaskCompletionSource isReadyToPayCompletionSource = new TaskCompletionSource();
        if (!this.isGooglePayInstalled(context, 2)) {
            isReadyToPayCompletionSource.setResult((Object)false);
            return isReadyToPayCompletionSource.getTask();
        }
        Context applicationContext = context.getApplicationContext();
        Intent serviceIntent = new Intent(GOOGLE_PAY_SDK_SERVICE);
        serviceIntent.setPackage(this.googlePayPackageInfo.getPackageName());
        IsReadyToPayServiceConnection serviceConnection = new IsReadyToPayServiceConnection((TaskCompletionSource<Boolean>)isReadyToPayCompletionSource, paymentDataRequest, applicationContext);
        try {
            boolean isBound = applicationContext.bindService(serviceIntent, (ServiceConnection)serviceConnection, 1);
            if (!isBound) {
                Log.w((String)GOOGLE_PAY_IN_APP_LOG_TAG, (String)"Unable to bind isReadyToPay");
                isReadyToPayCompletionSource.setResult((Object)false);
            }
        }
        catch (SecurityException e2) {
            Log.e((String)GOOGLE_PAY_IN_APP_LOG_TAG, (String)"SecurityException in bindService", (Throwable)e2);
            throw e2;
        }
        return isReadyToPayCompletionSource.getTask();
    }

    public void loadPaymentData(Activity activity, String paymentDataRequest, int requestCode) throws NoSuchAlgorithmException {
        Context context = activity.getApplicationContext();
        if (!this.isGooglePayInstalled(context, 2)) {
            activity.startActivity(this.getPlayStoreIntent(context));
        } else {
            Intent paisaIntent = this.getGooglePayIntent(context, paymentDataRequest);
            try {
                activity.startActivityForResult(paisaIntent, requestCode);
            }
            catch (ActivityNotFoundException e2) {
                activity.startActivity(this.getPlayStoreIntent(context));
            }
        }
    }

    public void loadPaymentData(Fragment fragment, String paymentDataRequest, int requestCode) throws NoSuchAlgorithmException {
        Context context = fragment.getContext();
        if (!this.isGooglePayInstalled(context, 2)) {
            fragment.startActivity(this.getPlayStoreIntent(context));
        } else {
            Intent paisaIntent = this.getGooglePayIntent(context, paymentDataRequest);
            try {
                fragment.startActivityForResult(paisaIntent, requestCode);
            }
            catch (ActivityNotFoundException e2) {
                String string2 = String.valueOf((Object)e2);
                Log.w((String)GOOGLE_PAY_IN_APP_LOG_TAG, (String)new StringBuilder(28 + String.valueOf(string2).length()).append("Unable to start Google Pay: ").append(string2).toString());
                fragment.startActivity(this.getPlayStoreIntent(context));
            }
        }
    }

    public boolean isGooglePayInstalled(Context context, @GooglePayApiFlags int flags) throws NoSuchAlgorithmException {
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(this.getGooglePayPackageInfo(context).getPackageName(), 64);
            if ((flags & 2) == 2) {
                long minimumGooglePayVersion = this.getGooglePayPackageInfo(context).getMinimumGooglePaySdkVersion();
                if (Log.isLoggable((String)GOOGLE_PAY_IN_APP_LOG_TAG, (int)4)) {
                    Log.i((String)GOOGLE_PAY_IN_APP_LOG_TAG, (String)String.format("Google Pay package version: %d [minimum: %d]", packageInfo.versionCode, minimumGooglePayVersion));
                }
                if ((long)packageInfo.versionCode < minimumGooglePayVersion) {
                    return false;
                }
            }
            if (packageInfo.signatures.length != 1) {
                return false;
            }
            byte[] packageSignatureHash = MessageDigest.getInstance("SHA-256").digest(packageInfo.signatures[0].toByteArray());
            byte[] expectedSignatureHash = this.getGooglePayPackageInfo(context).getSignatureHash();
            if (Log.isLoggable((String)GOOGLE_PAY_IN_APP_LOG_TAG, (int)4)) {
                Log.i((String)GOOGLE_PAY_IN_APP_LOG_TAG, (String)String.format("Google Pay signature: %s [expected: %s]", Base64.encodeToString((byte[])packageSignatureHash, (int)2), Base64.encodeToString((byte[])expectedSignatureHash, (int)2)));
            }
            return Arrays.equals(packageSignatureHash, expectedSignatureHash);
        }
        catch (PackageManager.NameNotFoundException e2) {
            return false;
        }
    }

    public void setConfig(Context context, @RawRes int configPropertiesRes) {
        this.googlePayPackageInfo = new GooglePayPackageInfo(context, configPropertiesRes);
    }

    private GooglePayPackageInfo getGooglePayPackageInfo(Context context) {
        if (this.googlePayPackageInfo == null) {
            this.googlePayPackageInfo = new GooglePayPackageInfo(context, R.raw.google_pay_inapp_api_config);
        }
        return this.googlePayPackageInfo;
    }

    private Intent getGooglePayIntent(Context context, String paymentDataRequest) {
        Bundle bundle = new Bundle();
        bundle.putString("paymentDataRequestJson", paymentDataRequest);
        Intent paisaIntent = new Intent(GOOGLE_PAY_LOAD_PAYMENT_ACTION);
        paisaIntent.setPackage(this.getGooglePayPackageInfo(context).getPackageName());
        paisaIntent.putExtras(bundle);
        return paisaIntent;
    }

    private Intent getPlayStoreIntent(Context context) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)String.format("market://details?id=%s", this.getGooglePayPackageInfo(context).getPackageName())));
        return intent;
    }

    private static final class IsReadyToPayServiceConnection
    implements ServiceConnection {
        IIsReadyToPayService isReadyToPayService;
        private final TaskCompletionSource<Boolean> isReadyToPayCompletionSource;
        private final Context applicationContext;
        private final String request;
        private Boolean serviceBound = true;

        IsReadyToPayServiceConnection(TaskCompletionSource<Boolean> isReadyToPayCompletionSource, String paymentDataRequest, Context context) {
            this.isReadyToPayCompletionSource = isReadyToPayCompletionSource;
            this.request = paymentDataRequest;
            this.applicationContext = context.getApplicationContext();
        }

        public void onServiceConnected(ComponentName className, IBinder service) {
            IIsReadyToPayServiceCallback.Stub callback = new IIsReadyToPayServiceCallback.Stub(){

                @Override
                public void handleIsReadyToPay(boolean isReadyToPay) throws RemoteException {
                    IsReadyToPayServiceConnection.this.isReadyToPayCompletionSource.setResult((Object)isReadyToPay);
                    IsReadyToPayServiceConnection.this.disconnect();
                }
            };
            this.isReadyToPayService = IIsReadyToPayService.Stub.asInterface(service);
            try {
                this.isReadyToPayService.isReadyToPay(new IsReadyToPayRequest(this.request), callback);
            }
            catch (RemoteException e2) {
                Log.e((String)PaymentsClient.GOOGLE_PAY_IN_APP_LOG_TAG, (String)"Exception in isReadyToPay", (Throwable)e2);
                throw new RuntimeException("isReadyToPay error: ", e2);
            }
        }

        public void onServiceDisconnected(ComponentName className) {
            this.disconnect();
        }

        private synchronized void disconnect() {
            if (this.serviceBound.booleanValue()) {
                this.serviceBound = false;
                this.applicationContext.unbindService((ServiceConnection)this);
            }
        }
    }

    public static @interface GooglePayApiFlags {
        public static final int UPI_INTENT = 1;
        public static final int IN_APP_SDK = 2;
    }
}

