/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.nbu.paisa.inapp.client.api;

import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.RawRes;
import android.util.Base64;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class GooglePayPackageInfo {
    private final long configVersion;
    private final String packageName;
    private final byte[] signatureHash;
    private final long minimumGooglePaySdkVersion;

    public long getConfigVersion() {
        return this.configVersion;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public byte[] getSignatureHash() {
        return this.signatureHash;
    }

    public long getMinimumGooglePaySdkVersion() {
        return this.minimumGooglePaySdkVersion;
    }

    public GooglePayPackageInfo(Context context, @RawRes int configResource) {
        Resources resources = context.getResources();
        InputStream rawResource = resources.openRawResource(configResource);
        Properties properties = new Properties();
        try {
            properties.load(rawResource);
            this.configVersion = Long.parseLong(properties.getProperty("config_version", "1"));
            this.packageName = properties.getProperty("package_name", "");
            this.signatureHash = Base64.decode((String)properties.getProperty("signature_hash", ""), (int)0);
            this.minimumGooglePaySdkVersion = Long.parseLong(properties.getProperty("minimum_google_pay_sdk_version", String.valueOf(Long.MAX_VALUE)));
        }
        catch (IOException | IllegalArgumentException e2) {
            throw new IllegalArgumentException("Invalid GooglePay InApp API configuration", e2);
        }
        if (this.packageName.isEmpty() || this.signatureHash.length < 1) {
            throw new IllegalArgumentException("Invalid GooglePay InApp API configuration");
        }
    }
}

