/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.aidl;

import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public abstract class BaseProxy
implements IInterface {
    private final IBinder mRemote;
    private final String mDescriptor;

    protected BaseProxy(IBinder remote, String descriptor) {
        this.mRemote = remote;
        this.mDescriptor = descriptor;
    }

    public IBinder asBinder() {
        return this.mRemote;
    }

    protected Parcel obtainAndWriteInterfaceToken() {
        Parcel parcel = Parcel.obtain();
        parcel.writeInterfaceToken(this.mDescriptor);
        return parcel;
    }

    protected Parcel transactAndReadException(int code, Parcel in) throws RemoteException {
        Parcel out = Parcel.obtain();
        try {
            this.mRemote.transact(code, in, out, 0);
            out.readException();
        }
        catch (RuntimeException e2) {
            out.recycle();
            throw e2;
        }
        finally {
            in.recycle();
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transactAndReadExceptionReturnVoid(int code, Parcel in) throws RemoteException {
        Parcel out = Parcel.obtain();
        try {
            this.mRemote.transact(code, in, out, 0);
            out.readException();
        }
        finally {
            in.recycle();
            out.recycle();
        }
    }

    protected void transactOneway(int code, Parcel in) throws RemoteException {
        try {
            this.mRemote.transact(code, in, null, 1);
        }
        finally {
            in.recycle();
        }
    }
}

