/*
 * Decompiled with CFR 0.152.
 */
package com.gocashfree.cashfreesdk;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.util.Log;
import androidx.annotation.NonNull;
import com.gocashfree.cashfreesdk.AmazonPayActivity;
import com.gocashfree.cashfreesdk.CFPaymentActivity;
import com.gocashfree.cashfreesdk.CFPhonePayActivity;
import com.gocashfree.cashfreesdk.CFUPIPaymentActivity;
import com.gocashfree.cashfreesdk.GooglePayActivity;
import com.google.android.apps.nbu.paisa.inapp.client.api.Wallet;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CFPaymentService {
    private static final String TAG = "CFPaymentService";
    static final String PAYMENT_IN_PROGRESS = "PAYMENT_IN_PROGRESS";
    public static final String PARAM_APP_ID = "appId";
    public static final String PARAM_ORDER_ID = "orderId";
    public static final String PARAM_ORDER_AMOUNT = "orderAmount";
    public static final String PARAM_ORDER_NOTE = "orderNote";
    public static final String PARAM_CUSTOMER_NAME = "customerName";
    public static final String PARAM_CUSTOMER_PHONE = "customerPhone";
    public static final String PARAM_CUSTOMER_EMAIL = "customerEmail";
    public static final String PARAM_NOTIFY_URL = "notifyUrl";
    public static final String PARAM_PAYMENT_MODES = "paymentModes";
    public static final String PARAM_ORDER_CURRENCY = "orderCurrency";
    public static final String PARAM_VENDOR_SPLIT = "vendorSplit";
    public static final String PARAM_PAYMENT_OPTION = "paymentOption";
    public static final String PARAM_CARD_NUMBER = "card_number";
    public static final String PARAM_CARD_HOLDER = "card_holder";
    public static final String PARAM_CARD_MM = "card_expiryMonth";
    public static final String PARAM_CARD_YYYY = "card_expiryYear";
    public static final String PARAM_CARD_CVV = "card_cvv";
    public static final String PARAM_BANK_CODE = "paymentCode";
    public static final String PARAM_WALLET_CODE = "paymentCode";
    public static final String PARAM_EMI_CODE = "paymentCode";
    public static final String PARAM_UPI_VPA = "upi_vpa";
    public static final String PAYMENT_CHANNEL = "AMAZON";
    public static final String STAGE_PROD_SERVICE = "PROD";
    public static final String STAGE_TEST_SERVICE = "TEST";
    public static final String STAGE_LOCAL_SERVICE = "LOCAL";
    private static final String TYPE = "type";
    public static final String CASH_FREE_RESPONSE = "CashFreeResponse";
    private static final String KEY_ORIENTATION = "orientation";
    private static final String CONFIRM_ON_EXIT = "confirmOnExit";
    public static final String PHONEPE_VERSION = "phonePeVersionCode";
    public static final String PHONEPE_RESULT = "phonePeResponse";
    public static final String OFFER_TAGS = "tags";
    static final String COLOR1 = "color1";
    static final String COLOR2 = "color2";
    private static CFPaymentService instance;
    public static int REQ_CODE = 9919;
    public static final String PHONEPE_PACKAGE_NAME = "com.phonepe.app";
    public static final String TEST_PHONEPE_PACKAGE_NAME = "com.phonepe.app.preprod";
    private String upiClientPackage = "";
    private String amazonClientPackage = "";

    private CFPaymentService() {
    }

    static String getPhonePePackage() {
        if (CFPaymentService.getStage().equals(STAGE_TEST_SERVICE)) {
            return TEST_PHONEPE_PACKAGE_NAME;
        }
        return PHONEPE_PACKAGE_NAME;
    }

    public static CFPaymentService getCFPaymentServiceInstance() {
        if (instance == null) {
            instance = new CFPaymentService();
        }
        return instance;
    }

    static String getStage() {
        return com.gocashfree.cashfreesdk.e.b.d("stage");
    }

    private void triggerPayment(Activity activity, Map<String, String> map, String string2, String string3, c object) {
        com.gocashfree.cashfreesdk.e.b.a("stage", string3);
        com.gocashfree.cashfreesdk.e.b.a("API_CALL_IN_PROGRESS");
        if (object == c.c) {
            Intent intent;
            string3 = intent;
            intent = new Intent((Context)activity, CFUPIPaymentActivity.class);
            if (!this.upiClientPackage.equals("")) {
                string3.putExtra("upiClientPackage", this.upiClientPackage);
            }
        } else if (object == c.b) {
            Intent intent;
            string3 = intent;
            new Intent((Context)activity, AmazonPayActivity.class).putExtra("paymentCode", "amazonpay");
        } else if (object == c.a) {
            Intent intent;
            string3 = intent;
            new Intent((Context)activity, GooglePayActivity.class).putExtra("paymentMode", "gpay");
        } else if (object == c.d) {
            Intent intent;
            string3 = intent;
            intent = new Intent((Context)activity, CFPhonePayActivity.class);
        } else {
            Intent intent;
            string3 = intent;
            intent = new Intent((Context)activity, CFPaymentActivity.class);
        }
        String[] stringArray = new String[5];
        object = stringArray;
        stringArray[0] = PARAM_APP_ID;
        stringArray[1] = PARAM_ORDER_ID;
        stringArray[2] = PARAM_ORDER_AMOUNT;
        stringArray[3] = PARAM_CUSTOMER_EMAIL;
        stringArray[4] = PARAM_CUSTOMER_PHONE;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string4 = object[i];
            if (map.containsKey(string4)) continue;
            this.failureResponse(activity, string4 + " not provided");
            return;
        }
        for (String string5 : map.keySet()) {
            string3.putExtra(string5, map.get(string5));
        }
        String string6 = string3;
        string6.putExtra("tokenData", string2);
        string6.putExtra("source", "app-sdk");
        if ("".equals(string2)) {
            this.failureResponse(activity, "Please provide a valid token");
            return;
        }
        activity.startActivityForResult((Intent)string3, REQ_CODE);
    }

    private void failureResponse(Activity activity, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("txStatus", "FAILED");
        hashMap.put("txMsg", string2);
        this.onCFResponseReceived(activity, hashMap);
    }

    public void doPayment(Activity activity, Map<String, String> map, String string2, String string3) {
        this.triggerPayment(activity, map, string2, string3, c.e);
        com.gocashfree.cashfreesdk.e.b.a(COLOR1, "");
        com.gocashfree.cashfreesdk.e.b.a(COLOR2, "");
    }

    public void doPayment(Activity activity, Map<String, String> map, String string2, String string3, String string4, String string5) {
        this.triggerPayment(activity, map, string2, string3, c.e);
        com.gocashfree.cashfreesdk.e.b.a(COLOR1, string4);
        com.gocashfree.cashfreesdk.e.b.a(COLOR2, string5);
    }

    public void doAmazonPayment(Activity activity, Map<String, String> map, String string2, String string3) {
        this.triggerPayment(activity, map, string2, string3, c.b);
    }

    public String[] getUpiClients(Context context) {
        Intent intent;
        String[] stringArray = intent;
        new Intent().setAction("android.intent.action.VIEW");
        stringArray.setData(Uri.parse((String)"upi://pay"));
        List list = context.getPackageManager().queryIntentActivities((Intent)stringArray, 0);
        stringArray = new String[list.size()];
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringArray[n] = ((ResolveInfo)iterator.next()).activityInfo.packageName;
            ++n;
        }
        return stringArray;
    }

    public void selectUpiClient(String string2) {
        this.upiClientPackage = string2;
    }

    public void upiPayment(Activity activity, Map<String, String> map, String string2, String string3) {
        this.triggerPayment(activity, map, string2, string3, c.c);
    }

    public void gPayPayment(Activity activity, Map<String, String> map, String string2, String string3) {
        this.triggerPayment(activity, map, string2, string3, c.a);
    }

    public void phonePePayment(Activity activity, Map<String, String> map, String string2, String string3) {
        this.triggerPayment(activity, map, string2, string3, c.d);
    }

    public void setOrientation(int n) {
        if (n == 0) {
            com.gocashfree.cashfreesdk.e.b.a(KEY_ORIENTATION, 0);
        } else {
            com.gocashfree.cashfreesdk.e.b.a(KEY_ORIENTATION, 1);
        }
    }

    int getOrientation() {
        return com.gocashfree.cashfreesdk.e.b.c(KEY_ORIENTATION);
    }

    public void setConfirmOnExit(boolean bl) {
        com.gocashfree.cashfreesdk.e.b.a(CONFIRM_ON_EXIT, bl);
    }

    boolean getConfirmOnExit() {
        return com.gocashfree.cashfreesdk.e.b.b(CONFIRM_ON_EXIT);
    }

    void onCFResponseReceived(Activity activity, Map<String, String> object) {
        Intent intent;
        CFPaymentService cFPaymentService = intent;
        new Intent().putExtra(TYPE, CASH_FREE_RESPONSE);
        for (Map.Entry entry : object.entrySet()) {
            cFPaymentService.putExtra((String)entry.getKey(), (String)entry.getValue());
        }
        Activity activity2 = activity;
        activity2.setResult(-1, (Intent)cFPaymentService);
        activity2.finish();
    }

    void onBackPressed(Activity activity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("txStatus", "Cancelled");
        this.onCFResponseReceived(activity, hashMap);
    }

    public boolean doesPhonePeExist(Context context) {
        CFPaymentService cFPaymentService = null;
        long l = -1L;
        cFPaymentService = context.getPackageManager().getPackageInfo(PHONEPE_PACKAGE_NAME, 1);
        l = ((PackageInfo)cFPaymentService).versionCode;
        try {
            com.gocashfree.cashfreesdk.e.b.a(PHONEPE_VERSION, String.valueOf(l));
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = PHONEPE_PACKAGE_NAME;
            objectArray[1] = nameNotFoundException.getMessage();
            Log.e((String)TAG, (String)String.format("failed to get package info for package name = {%s}, exception message = {%s}", objectArray2));
        }
        if (cFPaymentService == null) {
            return false;
        }
        return l > 94033L;
    }

    public void isGPayReadyForPayment(Context context, final b b2) {
        JSONArray jSONArray;
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        new JSONObject().put("apiVersion", 2);
        jSONObject2.put("apiVersionMinor", 0);
        JSONArray jSONArray2 = jSONArray;
        jSONArray = new JSONArray();
        JSONObject jSONObject3 = new JSONObject();
        JSONObject jSONObject4 = jSONObject3;
        jSONObject3.put(TYPE, (Object)"UPI");
        jSONArray.put((Object)jSONObject4);
        jSONObject2.put("allowedPaymentMethods", (Object)jSONArray2);
        try {
            Wallet.getPaymentsClient().isReadyToPay(context, jSONObject2.toString()).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Boolean>(this){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void onComplete(@NonNull Task<Boolean> task) {
                    try {
                        if (((Boolean)task.getResult(RuntimeException.class)).booleanValue()) {
                            b2.b();
                            return;
                        }
                        b2.a();
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        b2.a();
                    }
                }
            });
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            b2.a();
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            b2.a();
        }
    }

    public static interface b {
        public void b();

        public void a();
    }

    public static enum c {
        a,
        b,
        c,
        d,
        e;

    }
}

