/*
 * Decompiled with CFR 0.152.
 */
package com.aitime.android.payment;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.aitime.android.payment.Payment;
import com.aitime.android.payment.cashfree.R;
import com.aitime.android.payment.core.IPayment;
import com.aitime.android.payment.core.IPaymentCallback;
import com.aitime.android.payment.entity.PaymentInfo;
import com.gocashfree.cashfreesdk.CFPaymentService;
import java.util.HashMap;
import java.util.Map;

@Payment(channel="cashfree")
public class Cashfree
implements IPayment {
    private static final String TAG = "Cashfree";
    private CFPaymentService paymentService;
    private Activity mActivity;

    public Cashfree(Activity activity) {
        this.mActivity = activity;
    }

    public void callback(IPaymentCallback callback) {
    }

    public void preload(@NonNull Application application) {
        this.paymentService = CFPaymentService.getCFPaymentServiceInstance();
        this.paymentService.setOrientation(0);
        this.paymentService.setConfirmOnExit(true);
    }

    public void payment(@NonNull PaymentInfo info, @NonNull Map<String, String> params) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appId", params.get("appId"));
        map.put("orderId", params.get("orderId"));
        map.put("orderAmount", info.getPayMoney());
        map.put("orderNote", info.getPayName());
        map.put("customerName", info.getName());
        map.put("customerPhone", info.getContact());
        map.put("customerEmail", info.getEmail());
        String toolbarBg = this.mActivity.getString(R.string.payment_cashfree_toolbar_background);
        String toolbarText = this.mActivity.getString(R.string.payment_cashfree_toolbar_text);
        this.paymentService.doPayment(this.mActivity, map, params.get("token"), params.get("stage"), toolbarBg, toolbarText);
    }

    public boolean isAvailable(@Nullable String status, @NonNull Bundle bundle) {
        if ("Failed".equalsIgnoreCase(status)) {
            this.showToast(R.string.payment_status_failed);
            return false;
        }
        if ("Cancelled".equalsIgnoreCase(status)) {
            this.showToast(R.string.payment_status_cancelled);
            return false;
        }
        return true;
    }

    public void release() {
        this.paymentService = null;
    }

    private void showToast(@StringRes int resId) {
        Toast.makeText((Context)this.mActivity, (int)resId, (int)0).show();
    }
}

