package com.aitime.android.payment;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.widget.Toast;

import com.aitime.android.payment.cashfree.R;
import com.aitime.android.payment.core.IPayment;
import com.aitime.android.payment.core.IPaymentCallback;
import com.aitime.android.payment.core.PayChannel;
import com.aitime.android.payment.entity.PaymentInfo;
import com.gocashfree.cashfreesdk.CFPaymentService;

import java.util.HashMap;
import java.util.Map;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;

/**
 * Cashfree payment
 */
@Payment(channel = PayChannel.CASHFREE)
public class Cashfree implements IPayment {

    private static final String TAG = "Cashfree";

    private CFPaymentService paymentService;

    private Activity mActivity;

    public Cashfree(Activity activity) {
        this.mActivity = activity;
    }

    @Override
    public void callback(IPaymentCallback callback) {

    }

    @Override
    public void preload(@NonNull Application application) {
        paymentService = CFPaymentService.getCFPaymentServiceInstance();
        paymentService.setOrientation(0);       // 设置付款页面的方向(纵向或横向)
        paymentService.setConfirmOnExit(true);  // 设置是否显示退出确认弹窗
    }

    /**
     * Initiate Payment
     *
     * @param info   payment information
     * @param params payment params(contains {@code appId}、{@code orderId}、{@code token} and {@code stage})
     */
    @Override
    public void payment(@NonNull PaymentInfo info, @NonNull Map<String, String> params) {
        Map<String, String> map = new HashMap<>();
        map.put(CFPaymentService.PARAM_APP_ID, params.get("appId"));
        map.put(CFPaymentService.PARAM_ORDER_ID, params.get("orderId"));
        map.put(CFPaymentService.PARAM_ORDER_AMOUNT, info.getPayMoney());
        map.put(CFPaymentService.PARAM_ORDER_NOTE, info.getPayName());
        map.put(CFPaymentService.PARAM_CUSTOMER_NAME, info.getName());
        map.put(CFPaymentService.PARAM_CUSTOMER_PHONE, info.getContact());
        map.put(CFPaymentService.PARAM_CUSTOMER_EMAIL, info.getEmail());
        // Use the following method for initiating Payments
        // First color - Toolbar background
        // Second color - Toolbar text and back arrow color
        String toolbarBg = mActivity.getString(R.string.payment_cashfree_toolbar_background);
        String toolbarText = mActivity.getString(R.string.payment_cashfree_toolbar_text);
        paymentService.doPayment(mActivity, map, params.get("token"), params.get("stage"), toolbarBg, toolbarText);
    }

    @Override
    public boolean isAvailable(@Nullable String status, @NonNull Bundle bundle) {
        if ("Failed".equalsIgnoreCase(status)) {
            showToast(R.string.payment_status_failed);
            return false;
        }
        if ("Cancelled".equalsIgnoreCase(status)) {
            showToast(R.string.payment_status_cancelled);
            return false;
        }
        return true;
    }

    @Override
    public void release() {
        paymentService = null;
    }

    private void showToast(@StringRes int resId) {
        Toast.makeText(mActivity, resId, Toast.LENGTH_SHORT).show();
    }

}
