/*
 * Decompiled with CFR 0.152.
 */
package com.aitime.android.payment;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.aitime.android.payment.Payment;
import com.aitime.android.payment.braintree.R;
import com.aitime.android.payment.core.IPayment;
import com.aitime.android.payment.core.IPaymentCallback;
import com.aitime.android.payment.entity.PaymentInfo;
import com.braintreepayments.api.dropin.DropInRequest;
import com.braintreepayments.api.models.GooglePaymentRequest;
import com.braintreepayments.api.models.PayPalRequest;
import com.google.android.gms.wallet.TransactionInfo;
import java.lang.ref.WeakReference;
import java.util.Map;

@Payment(channel="braintree")
public class Braintree
implements IPayment {
    private final WeakReference<Activity> mActivity;

    public Braintree(Activity activity) {
        this.mActivity = new WeakReference<Activity>(activity);
    }

    public void callback(@NonNull IPaymentCallback callback) {
    }

    public void preload(@NonNull Application application) {
    }

    public void payment(@NonNull PaymentInfo info, @NonNull Map<String, String> params) {
        Activity activity = (Activity)this.mActivity.get();
        if (activity == null || activity.isDestroyed() || activity.isFinishing()) {
            return;
        }
        String token = this.getParameter(params, "token");
        DropInRequest dropInRequest = new DropInRequest().clientToken(token).collectDeviceData(true).requestThreeDSecureVerification(true).paypalRequest(this.getPayPalRequest(info)).googlePaymentRequest(this.getGooglePaymentRequest(info)).maskCardNumber(true).maskSecurityCode(true);
        activity.startActivityForResult(dropInRequest.getIntent((Context)activity), 10006);
    }

    private PayPalRequest getPayPalRequest(@NonNull PaymentInfo info) {
        return new PayPalRequest(info.getPayMoney()).currencyCode(info.getCurrency()).displayName(info.getPayName());
    }

    private GooglePaymentRequest getGooglePaymentRequest(@NonNull PaymentInfo info) {
        return new GooglePaymentRequest().emailRequired(true).transactionInfo(TransactionInfo.newBuilder().setTotalPrice(info.getPayMoney()).setCurrencyCode(info.getCurrency()).setTotalPriceStatus(3).build());
    }

    public boolean isAvailable(@Nullable String status, @NonNull Bundle bundle) {
        Activity activity = (Activity)this.mActivity.get();
        if (activity == null || activity.isDestroyed() || activity.isFinishing()) {
            return false;
        }
        if (String.valueOf(0).equals(status)) {
            String message = bundle.getString("message");
            if (TextUtils.isEmpty((CharSequence)message)) {
                message = activity.getString(R.string.payment_status_failed);
            }
            this.showToast(activity, message);
            return false;
        }
        return true;
    }

    public void release() {
        this.mActivity.clear();
    }

    private void showToast(Activity activity, String message) {
        Toast.makeText((Context)activity, (CharSequence)message, (int)0).show();
    }
}

