package com.aitime.android.payment;

import android.content.Intent;

import com.braintreepayments.api.dropin.DropInActivity;
import com.braintreepayments.api.dropin.DropInResult;
import com.braintreepayments.api.dropin.utils.PaymentMethodType;
import com.braintreepayments.api.models.PaymentMethodNonce;

/**
 * Braintree result
 */
public class BraintreeResult {

    public static BraintreeResult create(Intent data) {
        DropInResult result = data.getParcelableExtra(DropInResult.EXTRA_DROP_IN_RESULT);
        Exception exception = (Exception) data.getSerializableExtra(DropInActivity.EXTRA_ERROR);
        return new BraintreeResult(result, exception);
    }

    private DropInResult result;
    private Exception exception;

    private BraintreeResult(DropInResult result, Exception exception) {
        this.result = result;
        this.exception = exception;
    }

    public DropInResult getResult() {
        return result;
    }

    public void setResult(DropInResult result) {
        this.result = result;
    }

    public Exception getException() {
        return exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public String getMessage() {
        return exception == null ? null : exception.getMessage();
    }

    public String getDeviceData() {
        return result == null ? null : result.getDeviceData();
    }

    public PaymentMethodType getPaymentMethodType() {
        return result == null ? null : result.getPaymentMethodType();
    }

    public PaymentMethodNonce getPaymentMethodNonce() {
        return result == null ? null : result.getPaymentMethodNonce();
    }

    public String getNonce() {
        PaymentMethodNonce methodNonce = getPaymentMethodNonce();
        return methodNonce == null ? null : methodNonce.getNonce();
    }

    public String getDescription() {
        PaymentMethodNonce methodNonce = getPaymentMethodNonce();
        return methodNonce == null ? null : methodNonce.getDescription();
    }

    public String getTypeLabel() {
        PaymentMethodNonce methodNonce = getPaymentMethodNonce();
        return methodNonce == null ? null : methodNonce.getTypeLabel();
    }

}
