package com.aitime.android.payment;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.Toast;

import com.aitime.android.payment.braintree.R;
import com.aitime.android.payment.core.IPayment;
import com.aitime.android.payment.core.IPaymentCallback;
import com.aitime.android.payment.core.PayChannel;
import com.aitime.android.payment.entity.PaymentInfo;
import com.braintreepayments.api.dropin.DropInRequest;
import com.braintreepayments.api.models.GooglePaymentRequest;
import com.braintreepayments.api.models.PayPalRequest;
import com.google.android.gms.wallet.TransactionInfo;
import com.google.android.gms.wallet.WalletConstants;

import java.util.Map;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

/**
 * Braintree payment
 */
@Payment(channel = PayChannel.BRAINTREE)
public class Braintree implements IPayment {

    private Activity mActivity;

    public Braintree(Activity activity) {
        this.mActivity = activity;
    }

    @Override
    public void callback(@NonNull IPaymentCallback callback) {

    }

    @Override
    public void preload(@NonNull Application application) {

    }

    /**
     * Initiate Payment
     *
     * @param info   payment information
     * @param params payment params(contains {@code token})
     */
    @Override
    public void payment(@NonNull PaymentInfo info, @NonNull Map<String, String> params) {
        String token = getParameter(params, "token");
        DropInRequest dropInRequest = new DropInRequest()
                .clientToken(token)
                .collectDeviceData(true)
                .requestThreeDSecureVerification(true)
                .paypalRequest(getPayPalRequest(info))
                .googlePaymentRequest(getGooglePaymentRequest(info))
                .maskCardNumber(true)
                .maskSecurityCode(true);
        mActivity.startActivityForResult(dropInRequest.getIntent(mActivity), Math.abs(PayChannel.BRAINTREE.hashCode()));
    }

    private PayPalRequest getPayPalRequest(@NonNull PaymentInfo info) {
        return new PayPalRequest(info.getPayMoney())
                .currencyCode(info.getCurrency())
                .displayName(info.getPayName());
    }

    private GooglePaymentRequest getGooglePaymentRequest(@NonNull PaymentInfo info) {
        return new GooglePaymentRequest()
                .emailRequired(true)
                .transactionInfo(TransactionInfo.newBuilder()
                        .setTotalPrice(info.getPayMoney())
                        .setCurrencyCode(info.getCurrency())
                        .setTotalPriceStatus(WalletConstants.TOTAL_PRICE_STATUS_FINAL)
                        .build()
                );
    }

    @Override
    public boolean isAvailable(@Nullable String status, @NonNull Bundle bundle) {
        if (String.valueOf(Activity.RESULT_CANCELED).equals(status)) {
            String message = bundle.getString("message");
            if (TextUtils.isEmpty(message)) {
                message = mActivity.getString(R.string.payment_status_failed);
            }
            showToast(message);
            return false;
        }
        return true;
    }

    @Override
    public void release() {

    }

    private void showToast(String message) {
        Toast.makeText(mActivity, message, Toast.LENGTH_SHORT).show();
    }

}
