/*
 * Decompiled with CFR 0.152.
 */
package com.aitime.android.payment;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.aitime.android.payment.Payment;
import com.aitime.android.payment.braintree.R;
import com.aitime.android.payment.core.IPayment;
import com.aitime.android.payment.core.IPaymentCallback;
import com.aitime.android.payment.entity.PaymentInfo;
import com.braintreepayments.api.dropin.DropInRequest;
import com.braintreepayments.api.models.GooglePaymentRequest;
import com.braintreepayments.api.models.PayPalRequest;
import com.google.android.gms.wallet.TransactionInfo;
import java.util.Map;

@Payment(channel="braintree")
public class Braintree
implements IPayment {
    public static final String EXTRA_ERROR = "com.braintreepayments.api.dropin.EXTRA_ERROR";
    public static final String EXTRA_DROP_IN_RESULT = "com.braintreepayments.api.dropin.EXTRA_DROP_IN_RESULT";
    public Activity mActivity;

    public Braintree(Activity activity) {
        this.mActivity = activity;
    }

    private PayPalRequest getPayPalRequest(@NonNull PaymentInfo paymentInfo) {
        return new PayPalRequest(paymentInfo.getPayMoney()).currencyCode(paymentInfo.getCurrency()).displayName(paymentInfo.getPayName());
    }

    private GooglePaymentRequest getGooglePaymentRequest(@NonNull PaymentInfo paymentInfo) {
        return new GooglePaymentRequest().emailRequired(true).transactionInfo(TransactionInfo.newBuilder().setTotalPrice(paymentInfo.getPayMoney()).setCurrencyCode(paymentInfo.getCurrency()).setTotalPriceStatus(3).build());
    }

    private void showToast(String string2) {
        Toast.makeText((Context)this.mActivity, (CharSequence)string2, (int)0).show();
    }

    public void callback(IPaymentCallback iPaymentCallback) {
    }

    public void preload(@NonNull Application application) {
    }

    public void payment(@NonNull PaymentInfo paymentInfo, @NonNull Map<String, String> map) {
        Braintree braintree = braintree2;
        Braintree braintree2 = new DropInRequest().clientToken(map.get("token")).collectDeviceData(true).requestThreeDSecureVerification(true).paypalRequest(braintree2.getPayPalRequest(paymentInfo)).googlePaymentRequest(braintree2.getGooglePaymentRequest(paymentInfo)).maskCardNumber(true).maskSecurityCode(true);
        Activity activity = braintree.mActivity;
        activity.startActivityForResult(braintree2.getIntent((Context)activity), 100);
    }

    public boolean isAvailable(@Nullable String string2, @NonNull Bundle bundle) {
        if (String.valueOf(0).equals(string2)) {
            string2 = bundle.getString("message");
            if (TextUtils.isEmpty((CharSequence)string2)) {
                string2 = this.mActivity.getString(R.string.payment_status_failed);
            }
            this.showToast(string2);
            return false;
        }
        return true;
    }

    public void release() {
    }
}

