package com.aitime.android.ocr.camera;

import android.content.Context;

import java.io.Closeable;
import java.io.IOException;

/**
 * Tools
 */
final class Utility {

    /**
     * dp to px
     */
    static int dp2px(Context context, float dp) {
        if (context == null) {
            return -1;
        }
        float scale = context.getResources().getDisplayMetrics().density;
        return (int) ((dp * scale) + 0.5f);
    }

    /**
     * Quietly close IO
     */
    static void closeIOQuietly(Closeable... closeables) {
        if (closeables == null || closeables.length <= 0) {
            return;
        }
        for (Closeable closeable : closeables) {
            if (closeable != null) {
                try {
                    closeable.close();
                } catch (IOException ignored) {
                    // ignore
                }
            }
        }
    }


}
