package com.aitime.android.ocr.camera;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import androidx.annotation.IntDef;

/**
 * 闪光灯模式
 *
 * @see ICameraControl#setFlashMode(int)
 */
@IntDef({
        FlashMode.FLASH_MODE_TORCH,
        FlashMode.FLASH_MODE_OFF,
        FlashMode.FLASH_MODE_AUTO
})
@Retention(RetentionPolicy.SOURCE)
public @interface FlashMode {

    /**
     * 闪光灯关
     */
    int FLASH_MODE_OFF = 0;
    /**
     * 闪光灯开
     */
    int FLASH_MODE_TORCH = 1;
    /**
     * 闪光灯自动
     */
    int FLASH_MODE_AUTO = 2;

}
