package com.aitime.android.ocr.camera;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import androidx.annotation.IntDef;

/**
 * OCR类型
 */
@IntDef({
        OCRType.NONE,
        OCRType.BANK_CARD,
        OCRType.ID_CARD_FRONT,
        OCRType.ID_CARD_BACK,
        OCRType.PAN_FRONT,
        OCRType.PAN_BACK,
        OCRType.AADHAAR_FRONT,
        OCRType.AADHAAR_BACK,
        OCRType.PASSPORT_FRONT,
        OCRType.PASSPORT_BACK,
})
@Retention(RetentionPolicy.SOURCE)
public @interface OCRType {

    int NONE = 0;
    int BANK_CARD = 1;
    int ID_CARD_FRONT = 11;
    int ID_CARD_BACK = 12;
    int PAN_FRONT = 21;
    int PAN_BACK = 22;
    int AADHAAR_FRONT = 31;
    int AADHAAR_BACK = 32;
    int PASSPORT_FRONT = 41;
    int PASSPORT_BACK = 42;

}
