/*
 * Decompiled with CFR 0.152.
 */
package com.aitime.android.ocr.camera;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.aitime.android.ocr.camera.R;

public class OCRCameraLayout
extends FrameLayout {
    public static int ORIENTATION_PORTRAIT = 0;
    public static int ORIENTATION_HORIZONTAL = 1;
    public int orientation;
    public View contentView;
    public View centerView;
    public View leftDownView;
    public View rightUpView;
    public int contentViewId;
    public int centerViewId;
    public int leftDownViewId;
    public int rightUpViewId;
    public Paint paint;
    public Rect backgroundRect;

    public OCRCameraLayout(Context context) {
        this(context, null);
    }

    public OCRCameraLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public OCRCameraLayout(Context context, AttributeSet attributeSet, int n) {
        OCRCameraLayout oCRCameraLayout = this;
        super(context, attributeSet, n);
        this.orientation = ORIENTATION_PORTRAIT;
        this.paint = new Paint();
        this.backgroundRect = new Rect();
        oCRCameraLayout.parseAttrs(attributeSet);
        oCRCameraLayout.paint.setStyle(Paint.Style.FILL);
        oCRCameraLayout.paint.setColor(Color.argb((int)83, (int)0, (int)0, (int)0));
        oCRCameraLayout.setWillNotDraw(false);
    }

    private void parseAttrs(AttributeSet attributeSet) {
        attributeSet = this.getContext().getTheme().obtainStyledAttributes(attributeSet, R.styleable.OCRCameraLayout, 0, 0);
        try {
            this.contentViewId = attributeSet.getResourceId(R.styleable.OCRCameraLayout_contentView, -1);
            this.centerViewId = attributeSet.getResourceId(R.styleable.OCRCameraLayout_centerView, -1);
            this.leftDownViewId = attributeSet.getResourceId(R.styleable.OCRCameraLayout_leftDownView, -1);
            this.rightUpViewId = attributeSet.getResourceId(R.styleable.OCRCameraLayout_rightUpView, -1);
        }
        catch (Throwable throwable) {
            attributeSet.recycle();
            throw throwable;
        }
        attributeSet.recycle();
    }

    public void onAttachedToWindow() {
        OCRCameraLayout oCRCameraLayout = this;
        super.onAttachedToWindow();
        oCRCameraLayout.contentView = oCRCameraLayout.findViewById(oCRCameraLayout.contentViewId);
        int n = oCRCameraLayout.centerViewId;
        if (n != -1) {
            this.centerView = this.findViewById(n);
        }
        OCRCameraLayout oCRCameraLayout2 = this;
        oCRCameraLayout2.leftDownView = oCRCameraLayout2.findViewById(oCRCameraLayout2.leftDownViewId);
        oCRCameraLayout2.rightUpView = oCRCameraLayout2.findViewById(oCRCameraLayout2.rightUpViewId);
    }

    public void setOrientation(int n) {
        if (this.orientation == n) {
            return;
        }
        this.orientation = n;
        this.requestLayout();
    }

    /*
     * WARNING - void declaration
     */
    public void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5;
        void var2_16;
        int n6;
        int n7;
        void v0 = n7;
        OCRCameraLayout oCRCameraLayout = this;
        int view = oCRCameraLayout.getWidth();
        n7 = oCRCameraLayout.getHeight();
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)oCRCameraLayout.leftDownView.getLayoutParams();
        ViewGroup.MarginLayoutParams marginLayoutParams2 = (ViewGroup.MarginLayoutParams)oCRCameraLayout.rightUpView.getLayoutParams();
        if (n6 < v0) {
            OCRCameraLayout oCRCameraLayout2 = this;
            int n8 = view * 4 / 3;
            int n9 = n7 - n8;
            oCRCameraLayout2.contentView.layout((int)var2_16, n5, n6, n8);
            Rect rect = oCRCameraLayout2.backgroundRect;
            rect.left = 0;
            rect.top = n8;
            rect.right = view;
            oCRCameraLayout2.backgroundRect.bottom = n7;
            rect = oCRCameraLayout2.centerView;
            if (rect != null) {
                int n10 = (view - rect.getMeasuredWidth()) / 2;
                n5 = n8 + (n9 - this.centerView.getMeasuredHeight()) / 2;
                View view2 = this.centerView;
                int n11 = n5 + this.centerView.getMeasuredHeight();
                view2.layout(n10, n5, n10 += view2.getMeasuredWidth(), n11);
            }
            OCRCameraLayout oCRCameraLayout3 = this;
            int n16 = marginLayoutParams.leftMargin;
            int n12 = n8 + (n9 - this.leftDownView.getMeasuredHeight()) / 2;
            View view3 = oCRCameraLayout3.leftDownView;
            int n18 = n16 + view3.getMeasuredWidth();
            int n13 = n12 + this.leftDownView.getMeasuredHeight();
            view3.layout(n16, n12, n18, n13);
            int n14 = view - oCRCameraLayout3.rightUpView.getMeasuredWidth() - marginLayoutParams2.rightMargin;
            n12 = n8 + (n9 - this.rightUpView.getMeasuredHeight()) / 2;
            View view4 = this.rightUpView;
            int n142 = n14 + view4.getMeasuredWidth();
            int n15 = n12 + this.rightUpView.getMeasuredHeight();
            view4.layout(n14, n12, n142, n15);
        } else {
            Rect rect;
            OCRCameraLayout oCRCameraLayout4 = this;
            n6 = n7 * 4 / 3;
            int n16 = view - n6;
            oCRCameraLayout4.contentView.layout((int)var2_16, n5, n6, n7);
            Rect rect2 = rect = oCRCameraLayout4.backgroundRect;
            rect2.left = n6;
            rect2.top = 0;
            rect.right = view;
            oCRCameraLayout4.backgroundRect.bottom = n7;
            View view5 = oCRCameraLayout4.centerView;
            if (view5 != null) {
                int n17 = n6 + (n16 - view5.getMeasuredWidth()) / 2;
                int n18 = (n7 - this.centerView.getMeasuredHeight()) / 2;
                View view6 = this.centerView;
                int n19 = n17 + view6.getMeasuredWidth();
                n5 = n18 + this.centerView.getMeasuredHeight();
                view6.layout(n17, n18, n19, n5);
            }
            OCRCameraLayout oCRCameraLayout5 = this;
            int n20 = n6 + (n16 - this.leftDownView.getMeasuredWidth()) / 2;
            int n21 = n7 - this.leftDownView.getMeasuredHeight() - marginLayoutParams.bottomMargin;
            View view7 = oCRCameraLayout5.leftDownView;
            int n22 = n20 + view7.getMeasuredWidth();
            int n23 = n21 + this.leftDownView.getMeasuredHeight();
            view7.layout(n20, n21, n22, n23);
            int n24 = n6 + (n16 - oCRCameraLayout5.rightUpView.getMeasuredWidth()) / 2;
            n21 = marginLayoutParams2.topMargin;
            View view8 = this.rightUpView;
            int n222 = n24 + view8.getMeasuredWidth();
            int n25 = n21 + this.rightUpView.getMeasuredHeight();
            view8.layout(n24, n21, n222, n25);
        }
    }

    public void onDraw(Canvas canvas) {
        OCRCameraLayout oCRCameraLayout = oCRCameraLayout2;
        super.onDraw(canvas);
        OCRCameraLayout oCRCameraLayout2 = oCRCameraLayout.backgroundRect;
        canvas.drawRect((Rect)oCRCameraLayout2, oCRCameraLayout.paint);
    }
}

