/*
 * Decompiled with CFR 0.152.
 */
package com.aitime.android.ocr.camera;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import com.aitime.android.ocr.camera.CameraView;
import com.aitime.android.ocr.camera.R;
import java.io.File;

public class MaskView
extends View {
    public int ocrType;
    public int maskColor;
    public Rect frame;
    public Rect framePassport;
    public Paint eraser;
    public Paint pen;
    public Drawable locatorDrawable;
    public Path path;

    public MaskView(Context context) {
        this(context, null);
    }

    public MaskView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public MaskView(Context context, AttributeSet attributeSet, int n) {
        MaskView maskView = this;
        super(context, attributeSet, n);
        maskView.ocrType = 0;
        maskView.maskColor = Color.argb((int)100, (int)0, (int)0, (int)0);
        maskView.frame = new Rect();
        maskView.framePassport = new Rect();
        maskView.eraser = new Paint(1);
        maskView.pen = new Paint(1);
        maskView.path = new Path();
        maskView.init();
    }

    private void init() {
        MaskView maskView = this;
        maskView.setLayerType(1, null);
        maskView.pen.setColor(-1);
        maskView.pen.setStyle(Paint.Style.STROKE);
        maskView.pen.setStrokeWidth(6.0f);
        maskView.eraser.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
    }

    private Path fillRectRound(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        float f7;
        float f8;
        this.path.reset();
        if (f5 < 0.0f) {
            f5 = 0.0f;
        }
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        f = f3 - f;
        f4 -= f2;
        float f9 = f / 2.0f;
        if (!(f5 > f8)) {
            f9 = f5;
        }
        f5 = f4 / 2.0f;
        if (!(f6 > f7)) {
            f5 = f6;
        }
        MaskView maskView = this;
        float f10 = f4;
        f4 = f - f9 * 2.0f;
        f6 = f10 - f5 * 2.0f;
        maskView.path.moveTo(f3, f2 + f5);
        f2 = -f5;
        f3 = -f9;
        maskView.path.rQuadTo(0.0f, f2, f3, f2);
        maskView.path.rLineTo(-f4, 0.0f);
        maskView.path.rQuadTo(f3, 0.0f, f3, f5);
        maskView.path.rLineTo(0.0f, f6);
        if (bl) {
            MaskView maskView2 = this;
            maskView2.path.rLineTo(0.0f, f5);
            maskView2.path.rLineTo(f, 0.0f);
            maskView2.path.rLineTo(0.0f, f2);
        } else {
            MaskView maskView3 = this;
            maskView3.path.rQuadTo(0.0f, f5, f9, f5);
            maskView3.path.rLineTo(f4, 0.0f);
            maskView3.path.rQuadTo(f9, 0.0f, f9, f2);
        }
        MaskView maskView4 = this;
        maskView4.path.rLineTo(0.0f, -f6);
        maskView4.path.close();
        return maskView4.path;
    }

    private void capture(File file) {
    }

    public void setMaskColor(int n) {
        this.maskColor = n;
    }

    public Rect getFrameRect() {
        int n = this.ocrType;
        if (n == 0) {
            MaskView maskView = this;
            int n2 = maskView.getWidth();
            n = maskView.getHeight();
            return new Rect(0, 0, n2, n);
        }
        if (n != 41 && n != 42) {
            return new Rect(this.frame);
        }
        return new Rect(this.framePassport);
    }

    public Rect getFrameRectExtend() {
        Rect rect = new Rect(maskView.frame);
        MaskView maskView = maskView.frame;
        int n = (int)((float)(((Rect)maskView).right - ((Rect)maskView).left) * 0.02f);
        int n2 = (int)((float)(((Rect)maskView).bottom - ((Rect)maskView).top) * 0.02f);
        rect.left -= n;
        rect.right += n;
        rect.top -= n2;
        rect.bottom += n2;
        return rect;
    }

    public void setOCRType(int n) {
        this.ocrType = n;
        if (n == 11) {
            this.locatorDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_ocr_id_card_locator_front);
        } else if (n == 12) {
            this.locatorDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_ocr_id_card_locator_back);
        }
        this.invalidate();
    }

    public int getOcrType() {
        return this.ocrType;
    }

    public void setOrientation(@CameraView.Orientation int n) {
    }

    public void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        if (n > 0 && n2 > 0) {
            n3 = this.ocrType;
            if (n3 != 41 && n3 != 42) {
                float f = n2 > n ? 0.9f : 0.72f;
                int n5 = (int)((float)n * f);
                int n6 = n5 * 400 / 620;
                int n7 = n5;
                n5 = (n - n5) / 2;
                n = (n2 - n6) / 2;
                n2 = n7 + n5;
                Rect rect = this.frame;
                rect.left = n5;
                rect.top = n;
                rect.right = n2;
                this.frame.bottom = n6 += n;
            } else {
                int n8 = (int)((float)n * 0.9f);
                n3 = n8 * 330 / 470;
                int n9 = n8;
                n8 = (n - n8) / 2;
                n = (n2 - n3) / 2;
                n2 = n9 + n8;
                Rect rect = this.framePassport;
                rect.left = n8;
                rect.top = n;
                rect.right = n2;
                this.framePassport.bottom = n3 += n;
            }
        }
    }

    @RequiresApi(api=21)
    public void onDraw(Canvas canvas) {
        MaskView maskView = maskView4;
        super.onDraw(canvas);
        Rect rect = maskView.frame;
        int n = maskView.ocrType;
        if (n == 41 || n == 42) {
            rect = maskView4.framePassport;
        }
        MaskView maskView2 = maskView4;
        MaskView maskView3 = maskView4;
        Rect rect2 = rect;
        int n2 = rect2.width();
        n = rect2.height();
        int n3 = rect2.left;
        int n4 = rect2.top;
        int n5 = rect2.right;
        int n6 = rect2.bottom;
        canvas.drawColor(maskView4.maskColor);
        float f = n3;
        float f2 = n4;
        float f3 = n5;
        float f4 = n6;
        maskView3.fillRectRound(f, f2, f3, f4, 30.0f, 30.0f, false);
        Path path = maskView3.path;
        canvas.drawPath(path, maskView3.pen);
        path = maskView2.path;
        canvas.drawPath(path, maskView2.eraser);
        int n7 = maskView4.ocrType;
        if (n7 == 11) {
            int n8 = n;
            float f5 = n2;
            n = (int)(f + f5 * 0.5974155f);
            float f6 = n8;
            int n9 = (int)(f2 + f6 * 0.17405063f);
            int n10 = (int)(f + f5 * 0.95725644f);
            int n11 = (int)(f2 + f6 * 0.7531645f);
            maskView4.locatorDrawable.setBounds(n, n9, n10, n11);
        } else if (n7 == 12) {
            int n12 = n;
            float f7 = n2;
            n = (int)(f + f7 * 0.050695825f);
            float f8 = n12;
            int n13 = (int)(f2 + f8 * 0.07594936f);
            int n14 = (int)(f + f7 * 0.24850895f);
            int n15 = (int)(f2 + f8 * 0.41455695f);
            maskView4.locatorDrawable.setBounds(n, n13, n14, n15);
        }
        MaskView maskView4 = maskView4.locatorDrawable;
        if (maskView4 != null) {
            maskView4.draw(canvas);
        }
    }
}

