/*
 * Decompiled with CFR 0.152.
 */
package com.aitime.android.ocr.camera;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.aitime.android.ocr.camera.Utility;

public class FrameOverlayView
extends View {
    public static final int CORNER_LEFT_TOP = 1;
    public static final int CORNER_RIGHT_TOP = 2;
    public static final int CORNER_RIGHT_BOTTOM = 3;
    public static final int CORNER_LEFT_BOTTOM = 4;
    public GestureDetector.SimpleOnGestureListener onGestureListener;
    public int currentCorner;
    public int margin;
    public int cornerLength;
    public int cornerLineWidth;
    public int maskColor;
    public Paint paint;
    public Paint eraser;
    public GestureDetector gestureDetector;
    public RectF touchRect;
    public RectF frameRect;
    public OnFrameChangeListener onFrameChangeListener;
    public int shapeType;

    public FrameOverlayView(Context context) {
        FrameOverlayView frameOverlayView = this;
        super(context);
        frameOverlayView.onGestureListener = new GestureDetector.SimpleOnGestureListener(){

            public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
                FrameOverlayView.this.translate(f, f2);
                return true;
            }
        };
        frameOverlayView.currentCorner = -1;
        frameOverlayView.margin = 20;
        frameOverlayView.cornerLength = 100;
        frameOverlayView.cornerLineWidth = 6;
        frameOverlayView.maskColor = Color.argb((int)180, (int)0, (int)0, (int)0);
        frameOverlayView.paint = new Paint(1);
        frameOverlayView.eraser = new Paint(1);
        frameOverlayView.touchRect = new RectF();
        frameOverlayView.frameRect = new RectF();
        frameOverlayView.setLayerType(1, null);
        frameOverlayView.paint.setColor(-1);
        frameOverlayView.paint.setStyle(Paint.Style.STROKE);
        frameOverlayView.paint.setStrokeWidth(6.0f);
        frameOverlayView.eraser.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        frameOverlayView.shapeType = 0;
        frameOverlayView.init();
    }

    public FrameOverlayView(Context context, AttributeSet attributeSet) {
        FrameOverlayView frameOverlayView = this;
        super(context, attributeSet);
        frameOverlayView.onGestureListener = new /* invalid duplicate definition of identical inner class */;
        frameOverlayView.currentCorner = -1;
        frameOverlayView.margin = 20;
        frameOverlayView.cornerLength = 100;
        frameOverlayView.cornerLineWidth = 6;
        frameOverlayView.maskColor = Color.argb((int)180, (int)0, (int)0, (int)0);
        frameOverlayView.paint = new Paint(1);
        frameOverlayView.eraser = new Paint(1);
        frameOverlayView.touchRect = new RectF();
        frameOverlayView.frameRect = new RectF();
        frameOverlayView.setLayerType(1, null);
        frameOverlayView.paint.setColor(-1);
        frameOverlayView.paint.setStyle(Paint.Style.STROKE);
        frameOverlayView.paint.setStrokeWidth(6.0f);
        frameOverlayView.eraser.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        frameOverlayView.shapeType = 0;
        frameOverlayView.init();
    }

    public FrameOverlayView(Context context, AttributeSet attributeSet, int n) {
        FrameOverlayView frameOverlayView = this;
        super(context, attributeSet, n);
        frameOverlayView.onGestureListener = new /* invalid duplicate definition of identical inner class */;
        frameOverlayView.currentCorner = -1;
        frameOverlayView.margin = 20;
        frameOverlayView.cornerLength = 100;
        frameOverlayView.cornerLineWidth = 6;
        frameOverlayView.maskColor = Color.argb((int)180, (int)0, (int)0, (int)0);
        frameOverlayView.paint = new Paint(1);
        frameOverlayView.eraser = new Paint(1);
        frameOverlayView.touchRect = new RectF();
        frameOverlayView.frameRect = new RectF();
        frameOverlayView.setLayerType(1, null);
        frameOverlayView.paint.setColor(-1);
        frameOverlayView.paint.setStyle(Paint.Style.STROKE);
        frameOverlayView.paint.setStrokeWidth(6.0f);
        frameOverlayView.eraser.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        frameOverlayView.shapeType = 0;
        frameOverlayView.init();
    }

    private void init() {
        FrameOverlayView frameOverlayView = frameOverlayView3;
        FrameOverlayView frameOverlayView2 = frameOverlayView3;
        FrameOverlayView frameOverlayView3 = frameOverlayView2.getContext();
        frameOverlayView.gestureDetector = new GestureDetector((Context)frameOverlayView3, (GestureDetector.OnGestureListener)frameOverlayView2.onGestureListener);
        frameOverlayView.cornerLength = Utility.dp2px(frameOverlayView.getContext(), 18.0f);
        frameOverlayView.cornerLineWidth = Utility.dp2px(frameOverlayView.getContext(), 3.0f);
    }

    private void resetFrameRect(int n, int n2) {
        if (frameOverlayView.shapeType == 1) {
            RectF rectF = frameOverlayView.frameRect;
            rectF.left = (int)((double)n * 0.05);
            rectF.top = (int)((double)n2 * 0.25);
        } else {
            RectF rectF = frameOverlayView.frameRect;
            rectF.left = (int)((double)n * 0.2);
            rectF.top = (int)((double)n2 * 0.2);
        }
        FrameOverlayView frameOverlayView = frameOverlayView.frameRect;
        ((RectF)frameOverlayView).right = (float)n - ((RectF)frameOverlayView).left;
        frameOverlayView.frameRect.bottom = (float)n2 - ((RectF)frameOverlayView).top;
    }

    private void translate(float f, float f2) {
        int n;
        float f3;
        if (f > 0.0f) {
            int n2;
            float f4;
            f3 = this.frameRect.left;
            n = this.margin;
            if (f4 - f < (float)n2) {
                f = f3 - (float)n;
            }
        } else if (this.frameRect.right - f > (float)(this.getWidth() - this.margin)) {
            f = this.frameRect.right - (float)this.getWidth() + (float)this.margin;
        }
        if (f2 > 0.0f) {
            int n3;
            float f5;
            f3 = this.frameRect.top;
            n = this.margin;
            if (f5 - f2 < (float)n3) {
                f2 = f3 - (float)n;
            }
        } else if (this.frameRect.bottom - f2 > (float)(this.getHeight() - this.margin)) {
            f2 = this.frameRect.bottom - (float)this.getHeight() + (float)this.margin;
        }
        FrameOverlayView frameOverlayView = this;
        float f6 = -f;
        frameOverlayView.frameRect.offset(f6, -f2);
        frameOverlayView.invalidate();
    }

    private void drawCorners(Canvas canvas) {
        FrameOverlayView frameOverlayView = this;
        FrameOverlayView frameOverlayView2 = this;
        FrameOverlayView frameOverlayView3 = this;
        FrameOverlayView frameOverlayView4 = this;
        FrameOverlayView frameOverlayView5 = this;
        FrameOverlayView frameOverlayView6 = this;
        FrameOverlayView frameOverlayView7 = this;
        FrameOverlayView frameOverlayView8 = this;
        frameOverlayView8.paint.setStrokeWidth((float)this.cornerLineWidth);
        RectF rectF = frameOverlayView8.frameRect;
        float f = rectF.left - (float)this.cornerLineWidth / 2.0f;
        float f2 = rectF.top;
        int n = frameOverlayView8.cornerLength;
        frameOverlayView7.drawLine(canvas, f, f2, n, 0);
        RectF rectF2 = frameOverlayView7.frameRect;
        f = rectF2.left;
        f2 = rectF2.top;
        n = frameOverlayView7.cornerLength;
        frameOverlayView6.drawLine(canvas, f, f2, 0, n);
        RectF rectF3 = frameOverlayView6.frameRect;
        f = rectF3.right + (float)this.cornerLineWidth / 2.0f;
        f2 = rectF3.top;
        n = -frameOverlayView6.cornerLength;
        frameOverlayView5.drawLine(canvas, f, f2, n, 0);
        RectF rectF4 = frameOverlayView5.frameRect;
        f = rectF4.right;
        f2 = rectF4.top;
        n = frameOverlayView5.cornerLength;
        frameOverlayView4.drawLine(canvas, f, f2, 0, n);
        RectF rectF5 = frameOverlayView4.frameRect;
        f = rectF5.right;
        f2 = rectF5.bottom;
        n = -frameOverlayView4.cornerLength;
        frameOverlayView3.drawLine(canvas, f, f2, 0, n);
        RectF rectF6 = frameOverlayView3.frameRect;
        f = rectF6.right + (float)this.cornerLineWidth / 2.0f;
        f2 = rectF6.bottom;
        n = -frameOverlayView3.cornerLength;
        frameOverlayView2.drawLine(canvas, f, f2, n, 0);
        RectF rectF7 = frameOverlayView2.frameRect;
        float f3 = rectF7.left - (float)this.cornerLineWidth / 2.0f;
        f = rectF7.bottom;
        int n2 = frameOverlayView2.cornerLength;
        frameOverlayView.drawLine(canvas, f3, f, n2, 0);
        RectF rectF8 = frameOverlayView.frameRect;
        f3 = rectF8.left;
        f = rectF8.bottom;
        n2 = -frameOverlayView.cornerLength;
        this.drawLine(canvas, f3, f, 0, n2);
    }

    private void drawLine(Canvas canvas, float f, float f2, int n, int n2) {
        float f3 = f + (float)n;
        float f4 = f2 + (float)n2;
        Paint paint = this.paint;
        canvas.drawLine(f, f2, f3, f4, paint);
    }

    private boolean handleDown(MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            default: {
                break;
            }
            case 2: {
                return this.handleScale(motionEvent);
            }
            case 1: 
            case 3: {
                this.currentCorner = -1;
                break;
            }
            case 0: {
                FrameOverlayView frameOverlayView = this;
                float f = frameOverlayView.cornerLength;
                float f2 = motionEvent.getX() - f;
                MotionEvent motionEvent2 = motionEvent;
                float f3 = motionEvent2.getY() - f;
                float f4 = motionEvent2.getX() + f;
                f = motionEvent2.getY() + f;
                frameOverlayView.touchRect.set(f2, f3, f4, f);
                RectF rectF = this.frameRect;
                f3 = rectF.left;
                if (frameOverlayView.touchRect.contains(f3, rectF.top)) {
                    this.currentCorner = 1;
                    return true;
                }
                RectF rectF2 = this.frameRect;
                f3 = rectF2.right;
                if (this.touchRect.contains(f3, rectF2.top)) {
                    this.currentCorner = 2;
                    return true;
                }
                RectF rectF3 = this.frameRect;
                f3 = rectF3.right;
                if (this.touchRect.contains(f3, rectF3.bottom)) {
                    this.currentCorner = 3;
                    return true;
                }
                RectF rectF4 = this.frameRect;
                f3 = rectF4.left;
                if (this.touchRect.contains(f3, rectF4.bottom)) {
                    this.currentCorner = 4;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private boolean handleScale(MotionEvent motionEvent) {
        switch (this.currentCorner) {
            default: {
                return false;
            }
            case 4: {
                float f = motionEvent.getX();
                RectF rectF = this.frameRect;
                float f2 = rectF.top;
                float f3 = rectF.right;
                float f4 = motionEvent.getY();
                this.scaleTo(f, f2, f3, f4);
                return true;
            }
            case 3: {
                MotionEvent motionEvent2 = motionEvent;
                RectF rectF = this.frameRect;
                float f = rectF.left;
                float f5 = rectF.top;
                float f6 = motionEvent2.getX();
                float f7 = motionEvent2.getY();
                this.scaleTo(f, f5, f6, f7);
                return true;
            }
            case 2: {
                MotionEvent motionEvent3 = motionEvent;
                float f = this.frameRect.left;
                float f8 = motionEvent3.getY();
                float f9 = motionEvent3.getX();
                float f10 = this.frameRect.bottom;
                this.scaleTo(f, f8, f9, f10);
                return true;
            }
            case 1: 
        }
        FrameOverlayView frameOverlayView = this;
        MotionEvent motionEvent4 = motionEvent;
        float f = motionEvent4.getX();
        float f11 = motionEvent4.getY();
        RectF rectF = frameOverlayView.frameRect;
        float f12 = rectF.right;
        float f13 = rectF.bottom;
        frameOverlayView.scaleTo(f, f11, f12, f13);
        return true;
    }

    private void scaleTo(float f, float f2, float f3, float f4) {
        if (f4 - f2 < this.getMinimumFrameHeight()) {
            RectF rectF = this.frameRect;
            f2 = rectF.top;
            f4 = rectF.bottom;
        }
        if (f3 - f < this.getMinimumFrameWidth()) {
            RectF rectF = this.frameRect;
            f = rectF.left;
            f3 = rectF.right;
        }
        FrameOverlayView frameOverlayView = this;
        f = Math.max((float)frameOverlayView.margin, f);
        f2 = Math.max((float)frameOverlayView.margin, f2);
        f3 = Math.min((float)(frameOverlayView.getWidth() - this.margin), f3);
        float f5 = Math.min((float)(frameOverlayView.getHeight() - this.margin), f4);
        frameOverlayView.frameRect.set(f, f2, f3, f5);
        frameOverlayView.invalidate();
    }

    private void notifyFrameChange() {
        OnFrameChangeListener onFrameChangeListener = this.onFrameChangeListener;
        if (onFrameChangeListener != null) {
            onFrameChangeListener.onFrameChange(this.frameRect);
        }
    }

    private float getMinimumFrameWidth() {
        return (float)this.cornerLength * 2.4f;
    }

    private float getMinimumFrameHeight() {
        return (float)this.cornerLength * 2.4f;
    }

    public Rect getFrameRect() {
        FrameOverlayView frameOverlayView = frameOverlayView.frameRect;
        new Rect().left = (int)((RectF)frameOverlayView).left;
        new Rect().top = (int)((RectF)frameOverlayView).top;
        new Rect().right = (int)((RectF)frameOverlayView).right;
        new Rect().bottom = (int)((RectF)frameOverlayView).bottom;
        return new Rect();
    }

    public void setOnFrameChangeListener(OnFrameChangeListener onFrameChangeListener) {
        this.onFrameChangeListener = onFrameChangeListener;
    }

    public void onSizeChanged(int n, int n2, int n3, int n4) {
        FrameOverlayView frameOverlayView = this;
        super.onSizeChanged(n, n2, n3, n4);
        frameOverlayView.resetFrameRect(n, n2);
    }

    public void setTypeWide() {
        this.shapeType = 1;
    }

    public void onDraw(Canvas canvas) {
        FrameOverlayView frameOverlayView = frameOverlayView5;
        Canvas canvas2 = canvas;
        FrameOverlayView frameOverlayView2 = frameOverlayView5;
        FrameOverlayView frameOverlayView3 = frameOverlayView5;
        FrameOverlayView frameOverlayView4 = frameOverlayView5;
        super.onDraw(canvas);
        canvas.drawColor(frameOverlayView4.maskColor);
        frameOverlayView3.paint.setStrokeWidth((float)Utility.dp2px(frameOverlayView5.getContext(), 1.0f));
        FrameOverlayView frameOverlayView5 = frameOverlayView3.frameRect;
        canvas.drawRect((RectF)frameOverlayView5, frameOverlayView3.paint);
        frameOverlayView5 = frameOverlayView2.frameRect;
        canvas2.drawRect((RectF)frameOverlayView5, frameOverlayView2.eraser);
        frameOverlayView.drawCorners(canvas2);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent motionEvent) {
        RectF rectF;
        RectF rectF2;
        boolean bl = this.handleDown(motionEvent);
        RectF rectF3 = rectF2;
        RectF rectF4 = rectF = this.frameRect;
        float f = rectF4.top - 60.0f;
        float f2 = rectF4.right + 60.0f;
        float f3 = rectF4.bottom + 60.0f;
        rectF2 = new RectF(rectF.left - 60.0f, f, f2, f3);
        if (!bl) {
            MotionEvent motionEvent2 = motionEvent;
            float f4 = motionEvent2.getX();
            if (rectF3.contains(f4, motionEvent2.getY())) {
                this.gestureDetector.onTouchEvent(motionEvent);
                return true;
            }
        }
        return bl;
    }

    public static interface OnFrameChangeListener {
        public void onFrameChange(RectF var1);
    }
}

