/*
 * Decompiled with CFR 0.152.
 */
package com.aitime.android.ocr.camera;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.WindowManager;
import androidx.exifinterface.media.ExifInterface;
import com.aitime.android.ocr.camera.ImageUtil;
import java.io.IOException;

public class CropView
extends View {
    public int rotation;
    public float setMinimumScale;
    public float maximumScale;
    public Bitmap bitmap;
    public Matrix matrix;
    public float[] matrixArray;
    public Rect restrictBound;
    public GestureDetector gestureDetector;
    public ScaleGestureDetector scaleGestureDetector;

    public CropView(Context context) {
        this(context, null);
    }

    public CropView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public CropView(Context context, AttributeSet attributeSet, int n) {
        CropView cropView = this;
        super(context, attributeSet, n);
        cropView.rotation = 0;
        cropView.setMinimumScale = 0.2f;
        cropView.maximumScale = 4.0f;
        cropView.matrix = new Matrix();
        cropView.matrixArray = new float[9];
        cropView.init();
    }

    private void init() {
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener;
        GestureDetector gestureDetector;
        ScaleGestureDetector.SimpleOnScaleGestureListener simpleOnScaleGestureListener;
        ScaleGestureDetector scaleGestureDetector;
        CropView cropView = this;
        ScaleGestureDetector scaleGestureDetector2 = scaleGestureDetector;
        Context context = this.getContext();
        Object object = simpleOnScaleGestureListener;
        simpleOnScaleGestureListener = new ScaleGestureDetector.SimpleOnScaleGestureListener(){

            public boolean onScale(ScaleGestureDetector scaleGestureDetector) {
                CropView.this.scale(scaleGestureDetector);
                return true;
            }

            public void onScaleEnd(ScaleGestureDetector scaleGestureDetector) {
                float f;
                1 v0 = this;
                float f2 = f = scaleGestureDetector.getScaleFactor();
                v0.CropView.this.matrix.postScale(f2, f2);
                v0.CropView.this.invalidate();
            }
        };
        scaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)object);
        cropView.scaleGestureDetector = scaleGestureDetector2;
        scaleGestureDetector2 = gestureDetector;
        context = this.getContext();
        object = simpleOnGestureListener;
        simpleOnGestureListener = new GestureDetector.SimpleOnGestureListener(){

            public boolean onDown(MotionEvent motionEvent) {
                return true;
            }

            public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
                CropView.this.translate(f, f2);
                return true;
            }
        };
        gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)object);
        cropView.gestureDetector = scaleGestureDetector2;
    }

    private void setBitmap(Bitmap bitmap) {
        CropView cropView = this;
        cropView.bitmap = bitmap;
        cropView.matrix.reset();
        int n = cropView.getWidth();
        cropView.centerImage(n, cropView.getHeight());
        cropView.rotation = 0;
        cropView.invalidate();
    }

    private void translate(float f, float f2) {
        CropView cropView = this;
        cropView.matrix.getValues(this.matrixArray);
        float f3 = cropView.matrixArray[2];
        float f4 = cropView.matrixArray[5];
        Rect rect = cropView.getRestrictedBound();
        if (rect != null) {
            int n;
            int n2;
            CropView cropView2 = this;
            float f5 = cropView2.getScale();
            float f6 = f3 + (float)((int)((float)cropView2.bitmap.getWidth() / f5));
            f5 = f4 + (float)((int)((float)this.bitmap.getHeight() / f5));
            int n3 = rect.left;
            if (f3 - f > (float)n2) {
                f = f3 - (float)n3;
            }
            int n4 = rect.top;
            if (f4 - f2 > (float)n) {
                f2 = f4 - (float)n4;
            }
            if (f > 0.0f) {
                int n5;
                n4 = rect.right;
                if (f6 - f < (float)n5) {
                    f = f6 - (float)n4;
                }
            }
            if (f2 > 0.0f) {
                int n6;
                n4 = rect.bottom;
                if (f5 - f2 < (float)n6) {
                    f2 = f5 - (float)n4;
                }
            }
        }
        CropView cropView3 = this;
        float f7 = -f;
        cropView3.matrix.postTranslate(f7, -f2);
        cropView3.invalidate();
    }

    private void scale(ScaleGestureDetector scaleGestureDetector) {
        float f;
        float f2;
        float f3;
        float f4 = scaleGestureDetector.getScaleFactor();
        float f5 = this.getScale();
        float f6 = this.setMinimumScale;
        if (f3 * f4 < f2) {
            f4 = f6 / f5;
        }
        f6 = this.maximumScale;
        if (f5 * f4 > f) {
            f4 = f6 / f5;
        }
        CropView cropView = this;
        ScaleGestureDetector scaleGestureDetector2 = scaleGestureDetector;
        float f7 = scaleGestureDetector2.getFocusX();
        float f8 = scaleGestureDetector2.getFocusY();
        cropView.matrix.postScale(f4, f4, f7, f8);
        cropView.invalidate();
    }

    private void centerImage(int n, int n2) {
        Bitmap bitmap;
        if (n > 0 && n2 > 0 && (bitmap = this.bitmap) != null) {
            CropView cropView = this;
            float f = Math.min((float)n2 * 1.0f / (float)bitmap.getHeight(), (float)n * 1.0f / (float)this.bitmap.getWidth());
            float f2 = (float)(n - this.bitmap.getWidth()) / 2.0f;
            float f3 = (float)(n2 - this.bitmap.getHeight()) / 2.0f;
            cropView.matrix.setTranslate(0.0f, 0.0f);
            CropView cropView2 = this;
            float f4 = (float)cropView2.bitmap.getWidth() / 2.0f;
            float f5 = (float)cropView2.bitmap.getHeight() / 2.0f;
            cropView.matrix.setScale(f, f, f4, f5);
            cropView.matrix.postTranslate(f2, f3);
            cropView.invalidate();
            return;
        }
    }

    private float getScale() {
        float f;
        CropView cropView = this;
        cropView.matrix.getValues(this.matrixArray);
        float f2 = cropView.matrixArray[0];
        if ((double)Math.abs(f) <= 0.1) {
            f2 = this.matrixArray[1];
        }
        return Math.abs(f2);
    }

    private Rect getRestrictedBound() {
        return this.restrictBound;
    }

    /*
     * Unable to fully structure code
     */
    public void setFilePath(String var1_1) {
        block16: {
            var2_3 = this.bitmap;
            if (var2_3 != null && !var2_3.isRecycled()) {
                this.bitmap.recycle();
            }
            if (var1_1 == null) {
                return;
            }
            v0 = this;
            var2_3 = v1;
            new BitmapFactory.Options().inJustDecodeBounds = true;
            var3_4 = BitmapFactory.decodeFile((String)var1_1, (BitmapFactory.Options)var2_3);
            v0.rotation = new ExifInterface(var1_1).getAttributeInt("Orientation", 1);
            var4_5 = v2;
            v2 = new Matrix();
            var5_7 = ImageUtil.exifToDegrees(v0.rotation);
            if ((float)v0.rotation == 0.0f) break block16;
            var4_5.preRotate((float)var5_7);
        }
        var4_6 = 2048;
        var4_6 = Math.min(Math.min(var2_3.outWidth, var2_3.outHeight), var4_6);
        var5_8 = v3;
        v3 = new Point();
        var6_9 = (WindowManager)this.getContext().getSystemService("window");
        if (var6_9 == null) ** GOTO lbl32
        var6_9.getDefaultDisplay().getSize(var5_8);
lbl32:
        // 2 sources

        v4 = this;
        v5 = var1_1;
        v6 = var2_3;
        v7 = v6;
        v8 = v6;
        v9 = v6;
        v10 = v6;
        v11 = var4_6;
        v12 = var5_8.x;
        v13 = Math.min(v11, v12 * 2 / 3);
        var1_2 = v13;
        v14 = var2_3;
        v15 = v14;
        v16 = v14;
        v17 = v14;
        v18 = v14;
        v19 = var1_2;
        var1_2 = ImageUtil.calculateInSampleSize((BitmapFactory.Options)v14, v19, v19);
        v16.inSampleSize = var1_2;
        v17.inScaled = true;
        v15.inDensity = v18.outWidth;
        try {
            v7.inTargetDensity = v13 * var1_2;
            v8.inPreferredConfig = Bitmap.Config.ARGB_8888;
            v9.inJustDecodeBounds = false;
            v4.bitmap = BitmapFactory.decodeFile((String)v5, (BitmapFactory.Options)v10);
        }
        catch (NullPointerException v20) {
            v20.printStackTrace();
        }
        catch (IOException v21) {
            v21.printStackTrace();
            this.bitmap = var3_4;
        }
        v22 = this;
        v22.setBitmap(v22.bitmap);
    }

    public void onSizeChanged(int n, int n2, int n3, int n4) {
        CropView cropView = this;
        super.onSizeChanged(n, n2, n3, n4);
        cropView.centerImage(n, n2);
        cropView.invalidate();
    }

    public Bitmap crop(Rect rect) {
        Canvas canvas;
        Matrix matrix;
        Matrix matrix2;
        CropView cropView = cropView2;
        float f = cropView2.getScale();
        float[] fArray = new float[2];
        Object object = fArray;
        object[0] = rect.left;
        fArray[1] = rect.top;
        float[] fArray2 = new float[2];
        float[] fArray3 = fArray2;
        fArray2[0] = 0.0f;
        fArray2[1] = 0.0f;
        Matrix matrix3 = matrix2;
        matrix3();
        cropView2.matrix.invert(matrix3);
        matrix2.mapPoints(fArray3, object);
        CropView cropView2 = matrix;
        matrix = new Matrix();
        rect = Bitmap.createBitmap((int)((int)((float)rect.width() / f)), (int)((int)((float)rect.height() / f)), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas2 = canvas;
        canvas = new Canvas((Bitmap)rect);
        Bitmap bitmap = cropView.bitmap;
        object = bitmap;
        if (bitmap != null) {
            float f2 = -fArray3[0];
            cropView2.postTranslate(f2, -fArray3[1]);
            canvas2.drawBitmap((Bitmap)object, (Matrix)cropView2, null);
        }
        return rect;
    }

    public void setMinimumScale(float f) {
        this.setMinimumScale = f;
    }

    public void setMaximumScale(float f) {
        this.maximumScale = f;
    }

    public void rotate(int n) {
        Matrix matrix;
        if (this.bitmap == null) {
            return;
        }
        CropView cropView = this;
        Matrix matrix2 = matrix;
        matrix2();
        int n2 = this.bitmap.getWidth() / 2;
        int n3 = this.bitmap.getHeight() / 2;
        matrix2.postTranslate((float)(-n2), (float)(-n3));
        matrix2.postRotate((float)n);
        float f = n3;
        matrix.postTranslate(f, (float)n2);
        Bitmap bitmap = cropView.bitmap;
        bitmap = Bitmap.createBitmap((int)bitmap.getHeight(), (int)bitmap.getWidth(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        new Canvas(bitmap).drawBitmap(this.bitmap, matrix2, null);
        this.bitmap.recycle();
        cropView.bitmap = bitmap;
        int n4 = cropView.getWidth();
        cropView.centerImage(n4, cropView.getHeight());
        cropView.invalidate();
    }

    public void onDraw(Canvas canvas) {
        CropView cropView = this;
        super.onDraw(canvas);
        Bitmap bitmap = cropView.bitmap;
        if (bitmap != null) {
            canvas.drawBitmap(bitmap, this.matrix, null);
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent motionEvent) {
        CropView cropView = this;
        boolean bl = cropView.scaleGestureDetector.onTouchEvent(motionEvent);
        boolean bl2 = cropView.gestureDetector.onTouchEvent(motionEvent) || bl;
        return bl2 || super.onTouchEvent(motionEvent);
    }

    public void setRestrictBound(Rect rect) {
        this.restrictBound = rect;
    }
}

