/*
 * Decompiled with CFR 0.152.
 */
package com.aitime.android.ocr.camera;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.aitime.android.ocr.camera.Camera1Control;
import com.aitime.android.ocr.camera.CameraThreadPool;
import com.aitime.android.ocr.camera.ICameraControl;
import com.aitime.android.ocr.camera.ImageQualityProcess;
import com.aitime.android.ocr.camera.ImageUtil;
import com.aitime.android.ocr.camera.MaskView;
import com.aitime.android.ocr.camera.R;
import com.aitime.android.ocr.camera.Utility;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class CameraView
extends FrameLayout {
    public static final int ORIENTATION_PORTRAIT = 0;
    public static final int ORIENTATION_HORIZONTAL = 90;
    public static final int ORIENTATION_INVERT = 270;
    public final int SCAN_SUCCESS;
    public CameraViewTakePictureCallback cameraViewTakePictureCallback;
    public ICameraControl cameraControl;
    public View displayView;
    public MaskView maskView;
    public ImageView hintImageView;
    public TextView hintTextView;
    public LinearLayout hintViewTextWrapper;
    public boolean isEnableScan;
    public OnTakePictureCallback autoPictureCallback;

    public CameraView(Context context) {
        this(context, null);
    }

    public CameraView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public CameraView(Context object, AttributeSet attributeSet, int n) {
        CameraViewTakePictureCallback cameraViewTakePictureCallback;
        CameraView cameraView = this;
        super(object, attributeSet, n);
        cameraView.SCAN_SUCCESS = 0;
        object = cameraViewTakePictureCallback;
        cameraViewTakePictureCallback = new CameraViewTakePictureCallback(null);
        cameraView.cameraViewTakePictureCallback = object;
        cameraView.init();
    }

    private int detect(byte[] object, int n) {
        if (this.cameraControl.getAbortingScan().get()) {
            return 0;
        }
        CameraView cameraView = this;
        Rect rect = cameraView.cameraControl.getPreviewFrame();
        if (cameraView.maskView.getWidth() != 0 && this.maskView.getHeight() != 0 && rect.width() != 0 && rect.height() != 0) {
            int n2;
            Bitmap bitmap;
            BitmapFactory.Options options;
            Rect rect2;
            object = null;
            int n3 = 0;
            try {
                object = BitmapRegionDecoder.newInstance((byte[])object, (int)n3, (int)((byte[])object).length, (boolean)true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (object == null) {
                return 0;
            }
            n3 = n % 180;
            int n4 = n3 == 0 ? object.getWidth() : object.getHeight();
            int n5 = n3 == 0 ? object.getHeight() : object.getWidth();
            Rect rect3 = this.maskView.getFrameRectExtend();
            int n6 = n4 * rect3.left / this.maskView.getWidth();
            int n7 = n5 * rect3.top / this.maskView.getHeight();
            int n8 = n4 * rect3.right / this.maskView.getWidth();
            int n9 = n5 * rect3.bottom / this.maskView.getHeight();
            if (rect.top < 0) {
                int n10 = rect.height() * this.getWidth() / rect.width();
                n4 = (n10 - rect3.height()) / 2 * this.getWidth() / rect.width();
                n7 = n4 * n5 / rect.height();
                n9 = (n10 + rect3.height()) / 2 * this.getWidth() / rect.width() * n5 / rect.height();
            } else if (rect.left < 0) {
                int n11 = rect.width() * this.getHeight() / rect.height();
                n5 = (n11 - this.maskView.getFrameRect().width()) / 2 * this.getHeight() / rect.height();
                n6 = n5 * n4 / rect.width();
                n8 = (n11 + this.maskView.getFrameRect().width()) / 2 * this.getHeight() / rect.height() * n4 / rect.width();
            }
            rect = rect2;
            new Rect().left = n6;
            new Rect().top = n7;
            new Rect().right = n8;
            new Rect().bottom = n9;
            if (n3 == 90) {
                n3 = object.getWidth() / 2;
                int n12 = object.getHeight() / 2;
                n4 = n12;
                int n13 = n3;
                int n14 = n4;
                Rect rect4 = rect;
                n4 = rect4.height();
                int n15 = n3;
                n3 = n4 / 2;
                rect.left = n15 - n3;
                n4 = rect4.width() / 2;
                rect.top = n14 - n4;
                rect.right = n13 + n3;
                rect.bottom = n12 + n4;
                rect.sort();
            }
            Rect rect5 = rect;
            rect = options;
            rect();
            int n16 = Math.min(Math.min(object.getWidth(), object.getHeight()), 2048);
            options.inSampleSize = ImageUtil.calculateInSampleSize(options, n16, n16);
            options.inScaled = true;
            options.inDensity = Math.max(options.outWidth, rect.outHeight);
            options.inTargetDensity = n16;
            options.inPreferredConfig = Bitmap.Config.ARGB_8888;
            Bitmap bitmap2 = object.decodeRegion(rect5, (BitmapFactory.Options)rect);
            if (n != 0) {
                Matrix matrix;
                Bitmap bitmap3 = bitmap2;
                rect = matrix;
                rect();
                matrix.postRotate((float)n);
                n = bitmap3.getWidth();
                n3 = bitmap3.getHeight();
                bitmap = Bitmap.createBitmap((Bitmap)bitmap3, (int)0, (int)0, (int)n, (int)n3, (Matrix)rect, (boolean)false);
                if (bitmap3 != bitmap) {
                    bitmap2.recycle();
                }
            } else {
                bitmap = bitmap2;
            }
            if ((n2 = ImageQualityProcess.imageQualityDetection(bitmap)) == 0) {
                if (!this.cameraControl.getAbortingScan().compareAndSet(false, true)) {
                    bitmap.recycle();
                    return 0;
                }
                this.autoPictureCallback.onPictureTaken(bitmap);
            }
            this.showTipMessage(n2);
            return n2;
        }
        return 0;
    }

    private void showTipMessage(final int n) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                if (n == 0) {
                    CameraView.this.hintTextView.setVisibility(4);
                } else if (!CameraView.this.cameraControl.getAbortingScan().get()) {
                    2 v0 = this;
                    v0.CameraView.this.hintTextView.setVisibility(0);
                    v0.CameraView.this.hintTextView.setText((CharSequence)CameraView.this.getScanMessage(n));
                }
            }
        };
        this.post(runnable2);
    }

    private String getScanMessage(int n) {
        String string2;
        switch (n) {
            default: {
                string2 = "\u8bf7\u5c06\u8eab\u4efd\u8bc1\u7f6e\u4e8e\u53d6\u666f\u6846\u5185";
                break;
            }
            case 7: {
                string2 = "\u8bf7\u5c06\u8eab\u4efd\u8bc1\u5b8c\u6574\u7f6e\u4e8e\u53d6\u666f\u6846\u5185";
                break;
            }
            case 6: {
                string2 = "\u8bf7\u5c06\u955c\u5934\u9760\u8fd1\u8eab\u4efd\u8bc1";
                break;
            }
            case 5: {
                string2 = "\u8bf7\u62ff\u7a33\u955c\u5934\u548c\u8eab\u4efd\u8bc1";
                break;
            }
            case 4: {
                string2 = "\u8bf7\u5c06\u8eab\u4efd\u8bc1\u524d\u540e\u53cd\u8f6c\u518d\u8fdb\u884c\u8bc6\u522b";
                break;
            }
            case 3: {
                string2 = "\u8eab\u4efd\u8bc1\u53cd\u5149\uff0c\u8bf7\u91cd\u65b0\u5c1d\u8bd5";
                break;
            }
            case 2: {
                string2 = "\u8eab\u4efd\u8bc1\u6a21\u7cca\uff0c\u8bf7\u91cd\u65b0\u5c1d\u8bd5";
                break;
            }
            case 0: {
                string2 = "";
            }
        }
        return string2;
    }

    private void init() {
        LinearLayout.LayoutParams layoutParams;
        ImageView imageView;
        MaskView maskView;
        View view;
        CameraView cameraView = this;
        this.cameraControl = new Camera1Control(this.getContext());
        cameraView.displayView = view = this.cameraControl.getDisplayView();
        cameraView.addView(view);
        view = maskView;
        cameraView.maskView = new MaskView(this.getContext());
        cameraView.addView(view);
        view = imageView;
        cameraView.hintImageView = new ImageView(this.getContext());
        cameraView.addView(view);
        this.hintViewTextWrapper = new LinearLayout(this.getContext());
        this.hintViewTextWrapper.setOrientation(1);
        view = layoutParams;
        new LinearLayout.LayoutParams((int)-2, (int)Utility.dp2px((Context)this.getContext(), (float)25.0f)).gravity = 17;
        this.hintTextView = new TextView(this.getContext());
        this.hintTextView.setBackgroundResource(R.drawable.ic_ocr_round_corner);
        cameraView.hintTextView.setAlpha(0.5f);
        cameraView.hintTextView.setPadding(Utility.dp2px(this.getContext(), 10.0f), 0, Utility.dp2px(this.getContext(), 10.0f), 0);
        cameraView.hintViewTextWrapper.addView((View)this.hintTextView, (ViewGroup.LayoutParams)view);
        cameraView.hintTextView.setGravity(17);
        cameraView.hintTextView.setTextColor(-1);
        cameraView.hintTextView.setTextSize(2, 14.0f);
        cameraView.hintTextView.setText((CharSequence)this.getScanMessage(-1));
        cameraView.addView((View)cameraView.hintViewTextWrapper, (ViewGroup.LayoutParams)view);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressLint(value={"WrongThread"})
    private Bitmap crop(File var1_1, byte[] var2_2, int var3_7) {
        block76: {
            block75: {
                block77: {
                    block74: {
                        block73: {
                            block72: {
                                block71: {
                                    v0 = this /* !! */ ;
                                    v1 = v0;
                                    var4_8 = v0.cameraControl.getPreviewFrame();
                                    if (v1.maskView.getWidth() == 0) return null;
                                    if (this /* !! */ .maskView.getHeight() == 0) return null;
                                    if (var4_8.width() == 0) return null;
                                    if (var4_8.height() == 0) return null;
                                    var2_3 = 0;
                                    var2_4 = BitmapRegionDecoder.newInstance((byte[])var2_2, (int)var2_3, (int)var2_2.length, (boolean)true);
                                    if (var3_7 % 180 != 0) break block71;
                                    v2 = var2_4.getWidth();
lbl20:
                                    // 2 sources

                                    while (true) {
                                        var5_11 = v2;
                                        ** GOTO lbl27
                                        break;
                                    }
                                }
                                v2 = var2_4.getHeight();
                                ** continue;
lbl27:
                                // 1 sources

                                if (var3_7 % 180 != 0) break block72;
                                v3 = var2_4.getHeight();
lbl30:
                                // 2 sources

                                while (true) {
                                    var6_12 = v3;
                                    ** GOTO lbl37
                                    break;
                                }
                            }
                            v3 = var2_4.getWidth();
                            ** continue;
lbl37:
                            // 1 sources

                            v4 = var4_8;
                            v5 = var6_12;
                            v6 = var5_11;
                            v7 = var6_12;
                            v8 = var5_11;
                            var7_13 = this /* !! */ .maskView.getFrameRect();
                            v9 = v8 * var7_13.left;
                            var8_15 = v9 / this /* !! */ .maskView.getWidth();
                            v10 = v7 * var7_13.top;
                            var9_16 = v10 / this /* !! */ .maskView.getHeight();
                            v11 = v6 * var7_13.right;
                            var10_17 = v11 / this /* !! */ .maskView.getWidth();
                            v12 = v5 * var7_13.bottom;
                            var11_18 = v12 / this /* !! */ .maskView.getHeight();
                            if (v4.top >= 0) break block73;
                            v13 = var4_8.height() * this /* !! */ .getWidth();
                            v14 = v13 / var4_8.width();
                            v15 = var7_13;
                            v16 = v14 - var7_13.height();
                            v17 = v16 / 2 * this /* !! */ .getWidth();
                            var5_11 = v17 / var4_8.width();
                            v18 = v14 + v15.height();
                            v19 = v18 / 2 * this /* !! */ .getWidth();
                            v20 = v19 / var4_8.width();
                            var9_16 = var5_11 * var6_12 / var4_8.height();
                            var11_18 = v20 * var6_12 / var4_8.height();
                            break block74;
                        }
                        if (var4_8.left >= 0) break block74;
                        v21 = var4_8.width() * this /* !! */ .getHeight();
                        v22 = v21 / var4_8.height();
                        v23 = this /* !! */ ;
                        v24 = v22 - this /* !! */ .maskView.getFrameRect().width();
                        v25 = v24 / 2 * this /* !! */ .getHeight();
                        var6_12 = v25 / var4_8.height();
                        v26 = v22 + v23.maskView.getFrameRect().width();
                        v27 = v26 / 2 * this /* !! */ .getHeight();
                        v28 = v27 / var4_8.height();
                        var8_15 = var6_12 * var5_11 / var4_8.width();
                        var10_17 = v28 * var5_11 / var4_8.width();
                    }
                    v29 = var3_7;
                    this /* !! */  = v30;
                    this /* !! */ ();
                    this /* !! */ .left = var8_15;
                    this /* !! */ .top = var9_16;
                    this /* !! */ .right = var10_17;
                    v30.bottom = var11_18;
                    if (v29 % 180 != 90) ** GOTO lbl154
                    v31 = this /* !! */ ;
                    v32 = v31;
                    v33 = v31;
                    v34 = var2_4;
                    v35 = v34;
                    var4_9 = v34.getWidth() / 2;
                    var5_11 = v35.getHeight() / 2;
                    v36 = this /* !! */ ;
                    v37 = v36;
                    var6_12 = v36.height();
                    var7_14 = v37.width();
                    v38 = this /* !! */ ;
                    v39 = var4_9;
                    v40 = var6_12;
                    v41 = this /* !! */ ;
                    v42 = var5_11;
                    v43 = var7_14;
                    v44 = this /* !! */ ;
                    v45 = var4_9 - var6_12 / 2;
                    v44.left = v45;
                    v46 = v42 - v43 / 2;
                    v41.top = v46;
                    v47 = v39 + v40 / 2;
                    v38.right = v47;
                    v48 = var5_11 + var7_14 / 2;
                    v32.bottom = v48;
                    v33.sort();
lbl154:
                    // 2 sources

                    v49 = var3_7;
                    v50 = var2_4;
                    v51 = this /* !! */ ;
                    this /* !! */  = v52;
                    this /* !! */ ();
                    var2_5 = Math.min(Math.min(var2_4.getWidth(), var2_4.getHeight()), 2048);
                    v52.inSampleSize = ImageUtil.calculateInSampleSize(v52, var2_5, var2_5);
                    v52.inScaled = true;
                    v52.inDensity = Math.max(v52.outWidth, this /* !! */ .outHeight);
                    v52.inTargetDensity = var2_5;
                    v52.inPreferredConfig = Bitmap.Config.ARGB_8888;
                    this /* !! */  = v50.decodeRegion((Rect)v51, v52);
                    if (v49 == 0) break block77;
                    v53 = this /* !! */ ;
                    v54 = v53;
                    v55 = v53;
                    v56 = v53;
                    v57 = v53;
                    var2_6 = v58;
                    var2_6();
                    v59 = var3_7;
                    v58.postRotate(v59);
                    var3_7 = 0;
                    var4_10 = 0;
                    var5_11 = v54.getWidth();
                    var6_12 = v55.getHeight();
                    var2_6 = Bitmap.createBitmap((Bitmap)v56, (int)var3_7, (int)var4_10, (int)var5_11, (int)var6_12, (Matrix)var2_6, (boolean)false);
                    if (v57 == var2_6) break block75;
                    this /* !! */ .recycle();
                    break block75;
                }
                var2_6 = this /* !! */ ;
            }
            if (var1_1.exists()) break block76;
            var1_1.createNewFile();
        }
        v60 = var2_6;
        this /* !! */  = v61;
        this /* !! */ (var1_1);
        var2_6.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)this /* !! */ );
        try {
            v61.flush();
            v61.close();
            return v60;
        }
        catch (IOException v62) {
            try {
                v62.printStackTrace();
                return null;
            }
            catch (IOException v63) {
                v63.printStackTrace();
            }
        }
        return null;
    }

    public void setEnableScan(boolean bl) {
        this.isEnableScan = bl;
    }

    public ICameraControl getCameraControl() {
        return this.cameraControl;
    }

    public void setOrientation(@Orientation int n) {
        this.cameraControl.setDisplayOrientation(n);
    }

    public void start() {
        CameraView cameraView = this;
        cameraView.cameraControl.start();
        cameraView.setKeepScreenOn(true);
    }

    public void stop() {
        CameraView cameraView = this;
        cameraView.cameraControl.stop();
        cameraView.setKeepScreenOn(false);
    }

    public void takePicture(File file, OnTakePictureCallback onTakePictureCallback) {
        CameraView cameraView = this;
        CameraViewTakePictureCallback.access$102(cameraView.cameraViewTakePictureCallback, file);
        CameraViewTakePictureCallback.access$202(cameraView.cameraViewTakePictureCallback, onTakePictureCallback);
        cameraView.cameraControl.takePicture(this.cameraViewTakePictureCallback);
    }

    public void setAutoPictureCallback(OnTakePictureCallback onTakePictureCallback) {
        this.autoPictureCallback = onTakePictureCallback;
    }

    /*
     * Unable to fully structure code
     */
    public void setOCRType(int var1_1) {
        block8: {
            block7: {
                v0 = this;
                v0.maskView.setOCRType(var1_1);
                v0.maskView.setVisibility(0);
                v0.hintImageView.setVisibility(4);
                v0.hintViewTextWrapper.setVisibility(4);
                var2_2 = 0;
                if (var1_1 == 1 || var1_1 == 11) break block7;
                if (var1_1 == 12) ** GOTO lbl-1000
                if (var1_1 == 21) break block7;
                if (var1_1 == 22) ** GOTO lbl-1000
                if (var1_1 != 31) {
                    if (var1_1 != 32) {
                        if (var1_1 != 41) {
                            ** if (var1_1 == 42) goto lbl-1000
lbl-1000:
                            // 1 sources

                            {
                                v1 = this;
                                v1.maskView.setVisibility((int)4);
                                v1.hintImageView.setVisibility((int)4);
                                v1.hintViewTextWrapper.setVisibility((int)4);
                                ** GOTO lbl27
                            }
                        } else {
                            ** GOTO lbl22
                        }
                    } else {
                        ** GOTO lbl21
                    }
                }
                break block7;
lbl21:
                // 2 sources

                ** GOTO lbl-1000
lbl22:
                // 2 sources

                break block7;
lbl-1000:
                // 4 sources

                {
                    var2_2 = R.string.ocr_camera_back_side;
                }
                break block8;
            }
            var2_2 = R.string.ocr_camera_front_side;
        }
        if (var2_2 != 0) {
            v2 = this;
            v2.hintImageView.setVisibility(4);
            v2.hintTextView.setText(var2_2);
            v2.hintViewTextWrapper.setVisibility(0);
        }
        if (this.isEnableScan) {
            this.cameraControl.setDetectCallback(new ICameraControl.OnDetectPictureCallback(){

                @Override
                public int onDetect(byte[] byArray, int n) {
                    return CameraView.this.detect(byArray, n);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        void var4_8;
        int n5;
        int n6;
        void var5_9;
        CameraView cameraView = this;
        void var1_3 = var5_9 - n6;
        cameraView.displayView.layout(n5, 0, (int)var4_8, (int)var1_3);
        cameraView.maskView.layout(n5, 0, (int)var4_8, (int)var1_3);
        int n7 = Utility.dp2px(cameraView.getContext(), 250.0f);
        n5 = Utility.dp2px(cameraView.getContext(), 25.0f);
        n6 = (cameraView.getWidth() - n7) / 2;
        int n52 = cameraView.maskView.getFrameRect().bottom + Utility.dp2px(this.getContext(), 16.0f);
        int n8 = n6 + n7;
        n5 = n52 + n5;
        cameraView.hintViewTextWrapper.layout(n6, n52, n8, n5);
        cameraView.hintImageView.layout(n6, n52, n8, n5);
    }

    public class CameraViewTakePictureCallback
    implements ICameraControl.OnTakePictureCallback {
        public File file;
        public OnTakePictureCallback callback;

        public CameraViewTakePictureCallback() {
        }

        public /* synthetic */ CameraViewTakePictureCallback(com.aitime.android.ocr.camera.CameraView$1 var2_2) {
            this();
        }

        public static /* synthetic */ File access$102(CameraViewTakePictureCallback cameraViewTakePictureCallback, File file) {
            cameraViewTakePictureCallback.file = file;
            return file;
        }

        public static /* synthetic */ OnTakePictureCallback access$202(CameraViewTakePictureCallback cameraViewTakePictureCallback, OnTakePictureCallback onTakePictureCallback) {
            cameraViewTakePictureCallback.callback = onTakePictureCallback;
            return onTakePictureCallback;
        }

        @Override
        public void onPictureTaken(final byte[] byArray) {
            CameraThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    1 v0 = object;
                    int n = ImageUtil.getOrientation(v0.byArray);
                    CameraViewTakePictureCallback cameraViewTakePictureCallback = v0.CameraViewTakePictureCallback.this;
                    1 v1 = object;
                    Object object = cameraViewTakePictureCallback.file;
                    object = cameraViewTakePictureCallback.CameraView.this.crop((File)object, v1.byArray, n);
                    v0.CameraViewTakePictureCallback.this.callback.onPictureTaken((Bitmap)object);
                }
            });
        }
    }

    public static @interface Orientation {
    }

    public static interface OnTakePictureCallback {
        public void onPictureTaken(Bitmap var1);
    }
}

