/*
 * Decompiled with CFR 0.152.
 */
package com.aitime.android.ocr.camera;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class CameraThreadPool {
    public static Timer timerFocus;
    public static final long cameraScanInterval = 2000L;
    public static int poolCount;
    public static ExecutorService fixedThreadPool;

    public static void execute(Runnable runnable) {
        fixedThreadPool.execute(runnable);
    }

    public static Timer createAutoFocusTimerTask(final Runnable runnable) {
        TimerTask timerTask;
        Object object = timerFocus;
        if (object != null) {
            return object;
        }
        timerFocus = new Timer();
        object = timerTask;
        timerTask = new TimerTask(){

            @Override
            public void run() {
                runnable.run();
            }
        };
        timerFocus.scheduleAtFixedRate((TimerTask)object, 0L, 2000L);
        return timerFocus;
    }

    public static void cancelAutoFocusTimer() {
        Timer timer = timerFocus;
        if (timer != null) {
            timer.cancel();
            timerFocus = null;
        }
    }

    static {
        poolCount = Runtime.getRuntime().availableProcessors();
        fixedThreadPool = Executors.newFixedThreadPool(poolCount);
    }
}

