/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.utils;

import android.graphics.Matrix;
import android.graphics.PointF;

public class Transform3D {
    public static void applyTransform(Matrix outMatrix, PointF anchor, PointF position, float scaleX, float scaleY, float rotationX, float rotationY, float rotationZ, float preComputedCosX, float preComputedCosY) {
        outMatrix.reset();
        if (position != null && (position.x != 0.0f || position.y != 0.0f)) {
            outMatrix.preTranslate(position.x, position.y);
        }
        if (rotationZ != 0.0f) {
            outMatrix.preRotate(rotationZ);
        }
        if (rotationY != 0.0f) {
            Transform3D.applyYRotation(outMatrix, preComputedCosY);
        }
        if (rotationX != 0.0f) {
            Transform3D.applyXRotation(outMatrix, preComputedCosX);
        }
        if (scaleX != 1.0f || scaleY != 1.0f) {
            outMatrix.preScale(scaleX, scaleY);
        }
        if (anchor != null && (anchor.x != 0.0f || anchor.y != 0.0f)) {
            outMatrix.preTranslate(-anchor.x, -anchor.y);
        }
    }

    public static void apply3DRotations(Matrix matrix, float rotationX, float rotationY, float rotationZ, float preComputedCosX, float preComputedCosY) {
        if (rotationZ != 0.0f) {
            matrix.preRotate(rotationZ);
        }
        if (rotationY != 0.0f) {
            Transform3D.applyYRotation(matrix, preComputedCosY);
        }
        if (rotationX != 0.0f) {
            Transform3D.applyXRotation(matrix, preComputedCosX);
        }
    }

    private static void applyXRotation(Matrix matrix, float cosX) {
        matrix.preScale(1.0f, cosX);
    }

    private static void applyYRotation(Matrix matrix, float cosY) {
        matrix.preScale(cosY, 1.0f);
    }

    public static boolean has3DRotation(Float rotationX, Float rotationY, Float rotationZ) {
        return rotationX != null && rotationX.floatValue() != 0.0f || rotationY != null && rotationY.floatValue() != 0.0f || rotationZ != null && rotationZ.floatValue() != 0.0f;
    }
}

