/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.graphics.PointF;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatablePathValue;
import com.airbnb.lottie.model.animatable.AnimatableSplitDimensionPathValue;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import com.airbnb.lottie.parser.AnimatableValueParser;
import com.airbnb.lottie.parser.JsonUtils;
import com.airbnb.lottie.parser.KeyframesParser;
import com.airbnb.lottie.parser.PathKeyframeParser;
import com.airbnb.lottie.parser.moshi.JsonReader;
import com.airbnb.lottie.utils.Utils;
import com.airbnb.lottie.value.Keyframe;
import java.io.IOException;
import java.util.ArrayList;

public class AnimatablePathValueParser {
    private static final JsonReader.Options NAMES = JsonReader.Options.of("k", "x", "y");

    private AnimatablePathValueParser() {
    }

    public static AnimatablePathValue parse(JsonReader reader, LottieComposition composition) throws IOException {
        ArrayList<Keyframe<PointF>> keyframes = new ArrayList<Keyframe<PointF>>();
        if (reader.peek() == JsonReader.Token.BEGIN_ARRAY) {
            reader.beginArray();
            while (reader.hasNext()) {
                keyframes.add(PathKeyframeParser.parse(reader, composition));
            }
            reader.endArray();
            KeyframesParser.setEndFrames(keyframes);
        } else {
            keyframes.add(new Keyframe<PointF>(JsonUtils.jsonToPoint(reader, Utils.dpScale())));
        }
        return new AnimatablePathValue(keyframes);
    }

    static AnimatableValue<PointF, PointF> parseSplitPath(JsonReader reader, LottieComposition composition) throws IOException {
        AnimatablePathValue pathAnimation = null;
        AnimatableFloatValue xAnimation = null;
        AnimatableFloatValue yAnimation = null;
        boolean hasExpressions = false;
        reader.beginObject();
        block5: while (reader.peek() != JsonReader.Token.END_OBJECT) {
            switch (reader.selectName(NAMES)) {
                case 0: {
                    pathAnimation = AnimatablePathValueParser.parse(reader, composition);
                    continue block5;
                }
                case 1: {
                    if (reader.peek() == JsonReader.Token.STRING) {
                        hasExpressions = true;
                        reader.skipValue();
                        continue block5;
                    }
                    xAnimation = AnimatableValueParser.parseFloat(reader, composition);
                    continue block5;
                }
                case 2: {
                    if (reader.peek() == JsonReader.Token.STRING) {
                        hasExpressions = true;
                        reader.skipValue();
                        continue block5;
                    }
                    yAnimation = AnimatableValueParser.parseFloat(reader, composition);
                    continue block5;
                }
            }
            reader.skipName();
            reader.skipValue();
        }
        reader.endObject();
        if (hasExpressions) {
            composition.addWarning("Lottie doesn't support expressions.");
        }
        if (pathAnimation != null) {
            return pathAnimation;
        }
        return new AnimatableSplitDimensionPathValue(xAnimation, yAnimation);
    }
}

