/*
 * Decompiled with CFR 0.152.
 */
package com.aigestudio.wheelpicker.widgets;

import android.content.Context;
import android.util.AttributeSet;
import com.aigestudio.wheelpicker.WheelPicker;
import com.aigestudio.wheelpicker.widgets.IWheelDayPicker;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WheelDayPicker
extends WheelPicker
implements IWheelDayPicker {
    private static final Map<Integer, List<Integer>> DAYS = new HashMap<Integer, List<Integer>>();
    private Calendar mCalendar = Calendar.getInstance();
    private int mYear = this.mCalendar.get(1);
    private int mMonth = this.mCalendar.get(2);
    private int mSelectedDay;

    public WheelDayPicker(Context context) {
        this(context, null);
    }

    public WheelDayPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.updateDays();
        this.mSelectedDay = this.mCalendar.get(5);
        this.updateSelectedDay();
    }

    private void updateDays() {
        this.mCalendar.set(1, this.mYear);
        this.mCalendar.set(2, this.mMonth);
        int days = this.mCalendar.getActualMaximum(5);
        List<Integer> data = DAYS.get(days);
        if (null == data) {
            data = new ArrayList<Integer>();
            for (int i = 1; i <= days; ++i) {
                data.add(i);
            }
            DAYS.put(days, data);
        }
        super.setData(data);
    }

    private void updateSelectedDay() {
        this.setSelectedItemPosition(this.mSelectedDay - 1);
    }

    @Override
    public void setData(List data) {
        throw new UnsupportedOperationException("You can not invoke setData in WheelDayPicker");
    }

    @Override
    public int getSelectedDay() {
        return this.mSelectedDay;
    }

    @Override
    public void setSelectedDay(int day) {
        this.mSelectedDay = day;
        this.updateSelectedDay();
    }

    @Override
    public int getCurrentDay() {
        return Integer.valueOf(String.valueOf(this.getData().get(this.getCurrentItemPosition())));
    }

    @Override
    public void setYearAndMonth(int year, int month) {
        this.mYear = year;
        this.mMonth = month - 1;
        this.updateDays();
    }

    @Override
    public int getYear() {
        return this.mYear;
    }

    @Override
    public void setYear(int year) {
        this.mYear = year;
        this.updateDays();
    }

    @Override
    public int getMonth() {
        return this.mMonth;
    }

    @Override
    public void setMonth(int month) {
        this.mMonth = month - 1;
        this.updateDays();
    }
}

