/*
 * Decompiled with CFR 0.152.
 */
package com.aigestudio.wheelpicker.widgets;

import android.content.Context;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.aigestudio.wheelpicker.IDebug;
import com.aigestudio.wheelpicker.IWheelPicker;
import com.aigestudio.wheelpicker.R;
import com.aigestudio.wheelpicker.WheelPicker;
import com.aigestudio.wheelpicker.widgets.IWheelDatePicker;
import com.aigestudio.wheelpicker.widgets.IWheelDayPicker;
import com.aigestudio.wheelpicker.widgets.IWheelMonthPicker;
import com.aigestudio.wheelpicker.widgets.IWheelYearPicker;
import com.aigestudio.wheelpicker.widgets.WheelDayPicker;
import com.aigestudio.wheelpicker.widgets.WheelMonthPicker;
import com.aigestudio.wheelpicker.widgets.WheelYearPicker;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class WheelDatePicker
extends LinearLayout
implements WheelPicker.OnItemSelectedListener,
IDebug,
IWheelPicker,
IWheelDatePicker,
IWheelYearPicker,
IWheelMonthPicker,
IWheelDayPicker {
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-M-d", Locale.getDefault());
    private WheelYearPicker mPickerYear;
    private WheelMonthPicker mPickerMonth;
    private WheelDayPicker mPickerDay;
    private OnDateSelectedListener mListener;
    private TextView mTVYear;
    private TextView mTVMonth;
    private TextView mTVDay;
    private int mYear;
    private int mMonth;
    private int mDay;

    public WheelDatePicker(Context context) {
        this(context, null);
    }

    public WheelDatePicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.view_wheel_date_picker, (ViewGroup)this);
        this.mPickerYear = (WheelYearPicker)this.findViewById(R.id.wheel_date_picker_year);
        this.mPickerMonth = (WheelMonthPicker)this.findViewById(R.id.wheel_date_picker_month);
        this.mPickerDay = (WheelDayPicker)this.findViewById(R.id.wheel_date_picker_day);
        this.mPickerYear.setOnItemSelectedListener(this);
        this.mPickerMonth.setOnItemSelectedListener(this);
        this.mPickerDay.setOnItemSelectedListener(this);
        this.setMaximumWidthTextYear();
        this.mPickerMonth.setMaximumWidthText("00");
        this.mPickerDay.setMaximumWidthText("00");
        this.mTVYear = (TextView)this.findViewById(R.id.wheel_date_picker_year_tv);
        this.mTVMonth = (TextView)this.findViewById(R.id.wheel_date_picker_month_tv);
        this.mTVDay = (TextView)this.findViewById(R.id.wheel_date_picker_day_tv);
        this.mYear = this.mPickerYear.getCurrentYear();
        this.mMonth = this.mPickerMonth.getCurrentMonth();
        this.mDay = this.mPickerDay.getCurrentDay();
    }

    private void setMaximumWidthTextYear() {
        List years = this.mPickerYear.getData();
        String lastYear = String.valueOf(years.get(years.size() - 1));
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lastYear.length(); ++i) {
            sb.append("0");
        }
        this.mPickerYear.setMaximumWidthText(sb.toString());
    }

    @Override
    public void onItemSelected(WheelPicker picker, Object data, int position) {
        if (picker.getId() == R.id.wheel_date_picker_year) {
            this.mYear = (Integer)data;
            this.mPickerDay.setYear(this.mYear);
        } else if (picker.getId() == R.id.wheel_date_picker_month) {
            this.mMonth = (Integer)data;
            this.mPickerDay.setMonth(this.mMonth);
        }
        this.mDay = this.mPickerDay.getCurrentDay();
        String date = this.mYear + "-" + this.mMonth + "-" + this.mDay;
        if (null != this.mListener) {
            try {
                this.mListener.onDateSelected(this, SDF.parse(date));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setDebug(boolean isDebug) {
        this.mPickerYear.setDebug(isDebug);
        this.mPickerMonth.setDebug(isDebug);
        this.mPickerDay.setDebug(isDebug);
    }

    @Override
    public int getVisibleItemCount() {
        if (this.mPickerYear.getVisibleItemCount() == this.mPickerMonth.getVisibleItemCount() && this.mPickerMonth.getVisibleItemCount() == this.mPickerDay.getVisibleItemCount()) {
            return this.mPickerYear.getVisibleItemCount();
        }
        throw new ArithmeticException("Can not get visible item count correctly fromWheelDatePicker!");
    }

    @Override
    public void setVisibleItemCount(int count) {
        this.mPickerYear.setVisibleItemCount(count);
        this.mPickerMonth.setVisibleItemCount(count);
        this.mPickerDay.setVisibleItemCount(count);
    }

    @Override
    public boolean isCyclic() {
        return this.mPickerYear.isCyclic() && this.mPickerMonth.isCyclic() && this.mPickerDay.isCyclic();
    }

    @Override
    public void setCyclic(boolean isCyclic) {
        this.mPickerYear.setCyclic(isCyclic);
        this.mPickerMonth.setCyclic(isCyclic);
        this.mPickerDay.setCyclic(isCyclic);
    }

    @Override
    @Deprecated
    public void setOnItemSelectedListener(WheelPicker.OnItemSelectedListener listener) {
        throw new UnsupportedOperationException("You can not set OnItemSelectedListener forWheelDatePicker");
    }

    @Override
    @Deprecated
    public int getSelectedItemPosition() {
        throw new UnsupportedOperationException("You can not get position of selected item fromWheelDatePicker");
    }

    @Override
    @Deprecated
    public void setSelectedItemPosition(int position) {
        throw new UnsupportedOperationException("You can not set position of selected item forWheelDatePicker");
    }

    @Override
    @Deprecated
    public int getCurrentItemPosition() {
        throw new UnsupportedOperationException("You can not get position of current item fromWheelDatePicker");
    }

    @Override
    @Deprecated
    public List getData() {
        throw new UnsupportedOperationException("You can not get data source from WheelDatePicker");
    }

    @Override
    @Deprecated
    public void setData(List data) {
        throw new UnsupportedOperationException("You don't need to set data source forWheelDatePicker");
    }

    @Override
    @Deprecated
    public void setSameWidth(boolean hasSameSize) {
        throw new UnsupportedOperationException("You don't need to set same width forWheelDatePicker");
    }

    @Override
    @Deprecated
    public boolean hasSameWidth() {
        throw new UnsupportedOperationException("You don't need to set same width forWheelDatePicker");
    }

    @Override
    @Deprecated
    public void setOnWheelChangeListener(WheelPicker.OnWheelChangeListener listener) {
        throw new UnsupportedOperationException("WheelDatePicker unsupport setOnWheelChangeListener");
    }

    @Override
    @Deprecated
    public String getMaximumWidthText() {
        throw new UnsupportedOperationException("You can not get maximum width text fromWheelDatePicker");
    }

    @Override
    @Deprecated
    public void setMaximumWidthText(String text) {
        throw new UnsupportedOperationException("You don't need to set maximum width text forWheelDatePicker");
    }

    @Override
    @Deprecated
    public int getMaximumWidthTextPosition() {
        throw new UnsupportedOperationException("You can not get maximum width text positionfrom WheelDatePicker");
    }

    @Override
    @Deprecated
    public void setMaximumWidthTextPosition(int position) {
        throw new UnsupportedOperationException("You don't need to set maximum width textposition for WheelDatePicker");
    }

    @Override
    public int getSelectedItemTextColor() {
        if (this.mPickerYear.getSelectedItemTextColor() == this.mPickerMonth.getSelectedItemTextColor() && this.mPickerMonth.getSelectedItemTextColor() == this.mPickerDay.getSelectedItemTextColor()) {
            return this.mPickerYear.getSelectedItemTextColor();
        }
        throw new RuntimeException("Can not get color of selected item text correctly fromWheelDatePicker!");
    }

    @Override
    public void setSelectedItemTextColor(int color) {
        this.mPickerYear.setSelectedItemTextColor(color);
        this.mPickerMonth.setSelectedItemTextColor(color);
        this.mPickerDay.setSelectedItemTextColor(color);
    }

    @Override
    public int getItemTextColor() {
        if (this.mPickerYear.getItemTextColor() == this.mPickerMonth.getItemTextColor() && this.mPickerMonth.getItemTextColor() == this.mPickerDay.getItemTextColor()) {
            return this.mPickerYear.getItemTextColor();
        }
        throw new RuntimeException("Can not get color of item text correctly fromWheelDatePicker!");
    }

    @Override
    public void setItemTextColor(int color) {
        this.mPickerYear.setItemTextColor(color);
        this.mPickerMonth.setItemTextColor(color);
        this.mPickerDay.setItemTextColor(color);
    }

    @Override
    public int getItemTextSize() {
        if (this.mPickerYear.getItemTextSize() == this.mPickerMonth.getItemTextSize() && this.mPickerMonth.getItemTextSize() == this.mPickerDay.getItemTextSize()) {
            return this.mPickerYear.getItemTextSize();
        }
        throw new RuntimeException("Can not get size of item text correctly fromWheelDatePicker!");
    }

    @Override
    public void setItemTextSize(int size) {
        this.mPickerYear.setItemTextSize(size);
        this.mPickerMonth.setItemTextSize(size);
        this.mPickerDay.setItemTextSize(size);
    }

    @Override
    public int getItemSpace() {
        if (this.mPickerYear.getItemSpace() == this.mPickerMonth.getItemSpace() && this.mPickerMonth.getItemSpace() == this.mPickerDay.getItemSpace()) {
            return this.mPickerYear.getItemSpace();
        }
        throw new RuntimeException("Can not get item space correctly from WheelDatePicker!");
    }

    @Override
    public void setItemSpace(int space) {
        this.mPickerYear.setItemSpace(space);
        this.mPickerMonth.setItemSpace(space);
        this.mPickerDay.setItemSpace(space);
    }

    @Override
    public void setIndicator(boolean hasIndicator) {
        this.mPickerYear.setIndicator(hasIndicator);
        this.mPickerMonth.setIndicator(hasIndicator);
        this.mPickerDay.setIndicator(hasIndicator);
    }

    @Override
    public boolean hasIndicator() {
        return this.mPickerYear.hasIndicator() && this.mPickerMonth.hasIndicator() && this.mPickerDay.hasIndicator();
    }

    @Override
    public int getIndicatorSize() {
        if (this.mPickerYear.getIndicatorSize() == this.mPickerMonth.getIndicatorSize() && this.mPickerMonth.getIndicatorSize() == this.mPickerDay.getIndicatorSize()) {
            return this.mPickerYear.getIndicatorSize();
        }
        throw new RuntimeException("Can not get indicator size correctly from WheelDatePicker!");
    }

    @Override
    public void setIndicatorSize(int size) {
        this.mPickerYear.setIndicatorSize(size);
        this.mPickerMonth.setIndicatorSize(size);
        this.mPickerDay.setIndicatorSize(size);
    }

    @Override
    public int getIndicatorColor() {
        if (this.mPickerYear.getCurtainColor() == this.mPickerMonth.getCurtainColor() && this.mPickerMonth.getCurtainColor() == this.mPickerDay.getCurtainColor()) {
            return this.mPickerYear.getCurtainColor();
        }
        throw new RuntimeException("Can not get indicator color correctly from WheelDatePicker!");
    }

    @Override
    public void setIndicatorColor(int color) {
        this.mPickerYear.setIndicatorColor(color);
        this.mPickerMonth.setIndicatorColor(color);
        this.mPickerDay.setIndicatorColor(color);
    }

    @Override
    public void setCurtain(boolean hasCurtain) {
        this.mPickerYear.setCurtain(hasCurtain);
        this.mPickerMonth.setCurtain(hasCurtain);
        this.mPickerDay.setCurtain(hasCurtain);
    }

    @Override
    public boolean hasCurtain() {
        return this.mPickerYear.hasCurtain() && this.mPickerMonth.hasCurtain() && this.mPickerDay.hasCurtain();
    }

    @Override
    public int getCurtainColor() {
        if (this.mPickerYear.getCurtainColor() == this.mPickerMonth.getCurtainColor() && this.mPickerMonth.getCurtainColor() == this.mPickerDay.getCurtainColor()) {
            return this.mPickerYear.getCurtainColor();
        }
        throw new RuntimeException("Can not get curtain color correctly from WheelDatePicker!");
    }

    @Override
    public void setCurtainColor(int color) {
        this.mPickerYear.setCurtainColor(color);
        this.mPickerMonth.setCurtainColor(color);
        this.mPickerDay.setCurtainColor(color);
    }

    @Override
    public void setAtmospheric(boolean hasAtmospheric) {
        this.mPickerYear.setAtmospheric(hasAtmospheric);
        this.mPickerMonth.setAtmospheric(hasAtmospheric);
        this.mPickerDay.setAtmospheric(hasAtmospheric);
    }

    @Override
    public boolean hasAtmospheric() {
        return this.mPickerYear.hasAtmospheric() && this.mPickerMonth.hasAtmospheric() && this.mPickerDay.hasAtmospheric();
    }

    @Override
    public boolean isCurved() {
        return this.mPickerYear.isCurved() && this.mPickerMonth.isCurved() && this.mPickerDay.isCurved();
    }

    @Override
    public void setCurved(boolean isCurved) {
        this.mPickerYear.setCurved(isCurved);
        this.mPickerMonth.setCurved(isCurved);
        this.mPickerDay.setCurved(isCurved);
    }

    @Override
    @Deprecated
    public int getItemAlign() {
        throw new UnsupportedOperationException("You can not get item align from WheelDatePicker");
    }

    @Override
    @Deprecated
    public void setItemAlign(int align) {
        throw new UnsupportedOperationException("You don't need to set item align forWheelDatePicker");
    }

    @Override
    public Typeface getTypeface() {
        if (this.mPickerYear.getTypeface().equals((Object)this.mPickerMonth.getTypeface()) && this.mPickerMonth.getTypeface().equals((Object)this.mPickerDay.getTypeface())) {
            return this.mPickerYear.getTypeface();
        }
        throw new RuntimeException("Can not get typeface correctly from WheelDatePicker!");
    }

    @Override
    public void setTypeface(Typeface tf) {
        this.mPickerYear.setTypeface(tf);
        this.mPickerMonth.setTypeface(tf);
        this.mPickerDay.setTypeface(tf);
    }

    @Override
    public void setOnDateSelectedListener(OnDateSelectedListener listener) {
        this.mListener = listener;
    }

    @Override
    public Date getCurrentDate() {
        String date = this.mYear + "-" + this.mMonth + "-" + this.mDay;
        try {
            return SDF.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int getItemAlignYear() {
        return this.mPickerYear.getItemAlign();
    }

    @Override
    public void setItemAlignYear(int align) {
        this.mPickerYear.setItemAlign(align);
    }

    @Override
    public int getItemAlignMonth() {
        return this.mPickerMonth.getItemAlign();
    }

    @Override
    public void setItemAlignMonth(int align) {
        this.mPickerMonth.setItemAlign(align);
    }

    @Override
    public int getItemAlignDay() {
        return this.mPickerDay.getItemAlign();
    }

    @Override
    public void setItemAlignDay(int align) {
        this.mPickerDay.setItemAlign(align);
    }

    @Override
    public WheelYearPicker getWheelYearPicker() {
        return this.mPickerYear;
    }

    @Override
    public WheelMonthPicker getWheelMonthPicker() {
        return this.mPickerMonth;
    }

    @Override
    public WheelDayPicker getWheelDayPicker() {
        return this.mPickerDay;
    }

    @Override
    public TextView getTextViewYear() {
        return this.mTVYear;
    }

    @Override
    public TextView getTextViewMonth() {
        return this.mTVMonth;
    }

    @Override
    public TextView getTextViewDay() {
        return this.mTVDay;
    }

    @Override
    public void setYearFrame(int start, int end) {
        this.mPickerYear.setYearFrame(start, end);
    }

    @Override
    public int getYearStart() {
        return this.mPickerYear.getYearStart();
    }

    @Override
    public void setYearStart(int start) {
        this.mPickerYear.setYearStart(start);
    }

    @Override
    public int getYearEnd() {
        return this.mPickerYear.getYearEnd();
    }

    @Override
    public void setYearEnd(int end) {
        this.mPickerYear.setYearEnd(end);
    }

    @Override
    public int getSelectedYear() {
        return this.mPickerYear.getSelectedYear();
    }

    @Override
    public void setSelectedYear(int year) {
        this.mYear = year;
        this.mPickerYear.setSelectedYear(year);
        this.mPickerDay.setYear(year);
    }

    @Override
    public int getCurrentYear() {
        return this.mPickerYear.getCurrentYear();
    }

    @Override
    public int getSelectedMonth() {
        return this.mPickerMonth.getSelectedMonth();
    }

    @Override
    public void setSelectedMonth(int month) {
        this.mMonth = month;
        this.mPickerMonth.setSelectedMonth(month);
        this.mPickerDay.setMonth(month);
    }

    @Override
    public int getCurrentMonth() {
        return this.mPickerMonth.getCurrentMonth();
    }

    @Override
    public int getSelectedDay() {
        return this.mPickerDay.getSelectedDay();
    }

    @Override
    public void setSelectedDay(int day) {
        this.mDay = day;
        this.mPickerDay.setSelectedDay(day);
    }

    @Override
    public int getCurrentDay() {
        return this.mPickerDay.getCurrentDay();
    }

    @Override
    public void setYearAndMonth(int year, int month) {
        this.mYear = year;
        this.mMonth = month;
        this.mPickerYear.setSelectedYear(year);
        this.mPickerMonth.setSelectedMonth(month);
        this.mPickerDay.setYearAndMonth(year, month);
    }

    @Override
    public int getYear() {
        return this.getSelectedYear();
    }

    @Override
    public void setYear(int year) {
        this.mYear = year;
        this.mPickerYear.setSelectedYear(year);
        this.mPickerDay.setYear(year);
    }

    @Override
    public int getMonth() {
        return this.getSelectedMonth();
    }

    @Override
    public void setMonth(int month) {
        this.mMonth = month;
        this.mPickerMonth.setSelectedMonth(month);
        this.mPickerDay.setMonth(month);
    }

    public static interface OnDateSelectedListener {
        public void onDateSelected(WheelDatePicker var1, Date var2);
    }
}

