/*
 * Decompiled with CFR 0.152.
 */
package com.agrawalsuneet.dotsloader.loaders;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import android.widget.LinearLayout;
import com.agrawalsuneet.dotsloader.R;
import com.agrawalsuneet.dotsloader.basicviews.CircleView;
import com.agrawalsuneet.dotsloader.contracts.AbstractLinearLayout;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB1\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u0012\u0006\u0010\r\u001a\u00020\t\u0012\u0006\u0010\u000e\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\tH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010#\u001a\u00020\"H\u0016J\u0018\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\tH\u0014J\u0018\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\tH\u0002J\b\u0010*\u001a\u00020\"H\u0002R\u001a\u0010\u0010\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0012\"\u0004\b\u001c\u0010\u0014\u00a8\u0006+"}, d2={"Lcom/agrawalsuneet/dotsloader/loaders/TashieLoader;", "Lcom/agrawalsuneet/dotsloader/contracts/AbstractLinearLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "noOfDots", "dotsRadius", "dotsDist", "dotsColor", "(Landroid/content/Context;IIII)V", "animDelay", "getAnimDelay", "()I", "setAnimDelay", "(I)V", "dotsArray", "", "Lcom/agrawalsuneet/dotsloader/basicviews/CircleView;", "[Lcom/agrawalsuneet/dotsloader/basicviews/CircleView;", "isDotsExpanding", "", "getNoOfDots", "setNoOfDots", "getScaleAnimation", "Landroid/view/animation/AnimationSet;", "isExpanding", "delay", "initAttributes", "", "initView", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "setAnimationListener", "anim", "dotPosition", "startLoading", "dotsloader_release"})
public final class TashieLoader
extends AbstractLinearLayout {
    private int noOfDots;
    private int animDelay;
    private CircleView[] dotsArray;
    private boolean isDotsExpanding;

    public final int getNoOfDots() {
        return this.noOfDots;
    }

    public final void setNoOfDots(int n) {
        this.noOfDots = n;
    }

    public final int getAnimDelay() {
        return this.animDelay;
    }

    public final void setAnimDelay(int n) {
        this.animDelay = n;
    }

    @Override
    public void initAttributes(@NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.TashieLoader, 0, 0);
        this.setDotsRadius(typedArray.getDimensionPixelSize(R.styleable.TashieLoader_tashieloader_dotsRadius, 30));
        this.setDotsDist(typedArray.getDimensionPixelSize(R.styleable.TashieLoader_tashieloader_dotsDist, 15));
        this.setDotsColor(typedArray.getColor(R.styleable.TashieLoader_tashieloader_dotsColor, this.getResources().getColor(R.color.loader_selected)));
        this.setAnimDuration(typedArray.getInt(R.styleable.TashieLoader_tashieloader_animDur, 500));
        Interpolator interpolator = AnimationUtils.loadInterpolator((Context)this.getContext(), (int)typedArray.getResourceId(R.styleable.TashieLoader_tashieloader_interpolator, 17432587));
        Intrinsics.checkExpressionValueIsNotNull((Object)interpolator, (String)"AnimationUtils.loadInter\u2026nim.linear_interpolator))");
        this.setInterpolator(interpolator);
        this.noOfDots = typedArray.getInt(R.styleable.TashieLoader_tashieloader_noOfDots, 8);
        this.animDelay = typedArray.getInt(R.styleable.TashieLoader_tashieloader_animDelay, 100);
        typedArray.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int calHeight = 2 * this.getDotsRadius();
        int calWidth = 2 * this.noOfDots * this.getDotsRadius() + (this.noOfDots - 1) * this.getDotsDist();
        this.setMeasuredDimension(calWidth, calHeight);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initView() {
        this.removeAllViews();
        this.removeAllViewsInLayout();
        this.setVerticalGravity(80);
        this.dotsArray = new CircleView[this.noOfDots];
        int n = 0;
        int n2 = this.noOfDots;
        while (n < n2) {
            void iCount;
            Context context = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            CircleView circle = new CircleView(context, this.getDotsRadius(), this.getDotsColor(), false, 8, null);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(2 * this.getDotsRadius(), 2 * this.getDotsRadius());
            if (iCount != this.noOfDots - 1) {
                params.rightMargin = this.getDotsDist();
            }
            this.addView(circle, (ViewGroup.LayoutParams)params);
            if (this.dotsArray == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dotsArray");
            }
            this.dotsArray[iCount] = circle;
            ++iCount;
        }
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(this){
            final /* synthetic */ TashieLoader this$0;

            public void onGlobalLayout() {
                this.this$0.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                TashieLoader.access$startLoading(this.this$0);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void startLoading() {
        int n = 0;
        int n2 = this.noOfDots;
        while (n < n2) {
            void iCount;
            AnimationSet anim = this.getScaleAnimation(this.isDotsExpanding, (int)iCount);
            if (this.dotsArray == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dotsArray");
            }
            CircleView circleView = this.dotsArray[iCount];
            if (circleView == null) {
                Intrinsics.throwNpe();
            }
            circleView.startAnimation((Animation)anim);
            this.setAnimationListener(anim, (int)iCount);
            ++iCount;
        }
        this.isDotsExpanding = !this.isDotsExpanding;
    }

    private final AnimationSet getScaleAnimation(boolean isExpanding, int delay) {
        ScaleAnimation scaleAnimation;
        AnimationSet anim = new AnimationSet(true);
        boolean bl = isExpanding;
        if (bl) {
            scaleAnimation = new ScaleAnimation(0.0f, 1.0f, 0.0f, 1.0f, 1, 0.5f, 1, 0.5f);
        } else if (!bl) {
            scaleAnimation = new ScaleAnimation(1.0f, 0.0f, 1.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        ScaleAnimation scaleAnim = scaleAnimation;
        scaleAnim.setDuration((long)this.getAnimDuration());
        scaleAnim.setFillAfter(true);
        scaleAnim.setRepeatCount(0);
        scaleAnim.setStartOffset((long)(this.animDelay * delay));
        anim.addAnimation((Animation)scaleAnim);
        anim.setInterpolator(this.getInterpolator());
        return anim;
    }

    private final void setAnimationListener(AnimationSet anim, int dotPosition) {
        if (dotPosition == this.noOfDots - 1) {
            anim.setAnimationListener(new Animation.AnimationListener(this){
                final /* synthetic */ TashieLoader this$0;

                public void onAnimationRepeat(@Nullable Animation p0) {
                }

                public void onAnimationEnd(@Nullable Animation p0) {
                    TashieLoader.access$startLoading(this.this$0);
                }

                public void onAnimationStart(@Nullable Animation p0) {
                }
                {
                    this.this$0 = $outer;
                }
            });
        } else {
            anim.setAnimationListener(new Animation.AnimationListener(this, dotPosition){
                final /* synthetic */ TashieLoader this$0;
                final /* synthetic */ int $dotPosition;

                public void onAnimationRepeat(@Nullable Animation p0) {
                }

                public void onAnimationEnd(@Nullable Animation p0) {
                    boolean bl;
                    boolean bl2 = bl = !TashieLoader.access$isDotsExpanding$p(this.this$0);
                    if (bl) {
                        CircleView circleView = TashieLoader.access$getDotsArray$p(this.this$0)[this.$dotPosition];
                        if (circleView == null) {
                            Intrinsics.throwNpe();
                        }
                        circleView.setVisibility(0);
                    } else if (!bl) {
                        CircleView circleView = TashieLoader.access$getDotsArray$p(this.this$0)[this.$dotPosition];
                        if (circleView == null) {
                            Intrinsics.throwNpe();
                        }
                        circleView.setVisibility(4);
                    }
                }

                public void onAnimationStart(@Nullable Animation p0) {
                }
                {
                    this.this$0 = $outer;
                    this.$dotPosition = $captured_local_variable$1;
                }
            });
        }
    }

    public TashieLoader(@Nullable Context context) {
        super(context);
        this.noOfDots = 8;
        this.animDelay = 100;
        this.isDotsExpanding = true;
        this.initView();
    }

    public TashieLoader(@Nullable Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.noOfDots = 8;
        this.animDelay = 100;
        this.isDotsExpanding = true;
        this.initAttributes(attrs);
        this.initView();
    }

    public TashieLoader(@Nullable Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.noOfDots = 8;
        this.animDelay = 100;
        this.isDotsExpanding = true;
        this.initAttributes(attrs);
        this.initView();
    }

    public TashieLoader(@Nullable Context context, int noOfDots, int dotsRadius, int dotsDist, int dotsColor) {
        super(context);
        this.noOfDots = 8;
        this.animDelay = 100;
        this.isDotsExpanding = true;
        this.noOfDots = noOfDots;
        this.setDotsRadius(dotsRadius);
        this.setDotsDist(dotsDist);
        this.setDotsColor(dotsColor);
        this.initView();
    }

    public static final /* synthetic */ void access$startLoading(TashieLoader $this) {
        $this.startLoading();
    }

    public static final /* synthetic */ boolean access$isDotsExpanding$p(TashieLoader $this) {
        return $this.isDotsExpanding;
    }

    public static final /* synthetic */ void access$setDotsExpanding$p(TashieLoader $this, boolean bl) {
        $this.isDotsExpanding = bl;
    }

    @NotNull
    public static final /* synthetic */ CircleView[] access$getDotsArray$p(TashieLoader $this) {
        if ($this.dotsArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dotsArray");
        }
        return $this.dotsArray;
    }

    public static final /* synthetic */ void access$setDotsArray$p(TashieLoader $this, @NotNull CircleView[] circleViewArray) {
        $this.dotsArray = circleViewArray;
    }
}

