/*
 * Decompiled with CFR 0.152.
 */
package com.agrawalsuneet.dotsloader.loaders;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.LinearLayout;
import com.agrawalsuneet.dotsloader.R;
import com.agrawalsuneet.dotsloader.basicviews.CircularLoaderBaseView;
import com.agrawalsuneet.dotsloader.contracts.LoaderContract;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005B'\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nB\u0019\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB!\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010!\u001a\u00020 H\u0002J\u0018\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007H\u0014J\u0018\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0007H\u0014J\b\u0010)\u001a\u00020 H\u0002R\u001a\u0010\u0010\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0012\"\u0004\b\u001c\u0010\u0014\u00a8\u0006*"}, d2={"Lcom/agrawalsuneet/dotsloader/loaders/RotatingCircularDotsLoader;", "Landroid/widget/LinearLayout;", "Lcom/agrawalsuneet/dotsloader/contracts/LoaderContract;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "dotsRadius", "", "bigCircleRadius", "dotsColor", "(Landroid/content/Context;III)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "animDuration", "getAnimDuration", "()I", "setAnimDuration", "(I)V", "getBigCircleRadius", "setBigCircleRadius", "circularLoaderBaseView", "Lcom/agrawalsuneet/dotsloader/basicviews/CircularLoaderBaseView;", "getDotsColor", "setDotsColor", "getDotsRadius", "setDotsRadius", "getRotateAnimation", "Landroid/view/animation/RotateAnimation;", "initAttributes", "", "initView", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onVisibilityChanged", "changedView", "Landroid/view/View;", "visibility", "startLoading", "dotsloader_release"})
public final class RotatingCircularDotsLoader
extends LinearLayout
implements LoaderContract {
    private int dotsRadius;
    private int dotsColor;
    private int bigCircleRadius;
    private int animDuration;
    private CircularLoaderBaseView circularLoaderBaseView;

    public final int getDotsRadius() {
        return this.dotsRadius;
    }

    public final void setDotsRadius(int n) {
        this.dotsRadius = n;
    }

    public final int getDotsColor() {
        return this.dotsColor;
    }

    public final void setDotsColor(int n) {
        this.dotsColor = n;
    }

    public final int getBigCircleRadius() {
        return this.bigCircleRadius;
    }

    public final void setBigCircleRadius(int n) {
        this.bigCircleRadius = n;
    }

    public final int getAnimDuration() {
        return this.animDuration;
    }

    public final void setAnimDuration(int n) {
        this.animDuration = n;
    }

    @Override
    public void initAttributes(@NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.RotatingCircularDotsLoader, 0, 0);
        this.dotsRadius = typedArray.getDimensionPixelSize(R.styleable.RotatingCircularDotsLoader_rotatingcircular_dotsRadius, 30);
        this.dotsColor = typedArray.getColor(R.styleable.RotatingCircularDotsLoader_rotatingcircular_dotsColor, this.getResources().getColor(R.color.loader_selected));
        this.bigCircleRadius = typedArray.getDimensionPixelSize(R.styleable.RotatingCircularDotsLoader_rotatingcircular_bigCircleRadius, 90);
        this.animDuration = typedArray.getInt(R.styleable.RotatingCircularDotsLoader_rotatingcircular_animDur, 5000);
        typedArray.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int calWidth;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int calHeight = calWidth = 2 * this.bigCircleRadius + 2 * this.dotsRadius;
        this.setMeasuredDimension(calWidth, calHeight);
    }

    private final void initView() {
        this.removeAllViews();
        this.removeAllViewsInLayout();
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        CircularLoaderBaseView circularLoaderBaseView = this.circularLoaderBaseView = new CircularLoaderBaseView(context, this.dotsRadius, this.bigCircleRadius, this.dotsColor);
        if (circularLoaderBaseView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"circularLoaderBaseView");
        }
        this.addView(circularLoaderBaseView);
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(this){
            final /* synthetic */ RotatingCircularDotsLoader this$0;

            public void onGlobalLayout() {
                RotatingCircularDotsLoader.access$startLoading(this.this$0);
                this.this$0.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    protected void onVisibilityChanged(@NotNull View changedView, int visibility) {
        Intrinsics.checkParameterIsNotNull((Object)changedView, (String)"changedView");
        super.onVisibilityChanged(changedView, visibility);
        if (visibility != 0) {
            this.initView();
        } else {
            CircularLoaderBaseView circularLoaderBaseView = this.circularLoaderBaseView;
            if (circularLoaderBaseView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"circularLoaderBaseView");
            }
            circularLoaderBaseView.clearAnimation();
        }
    }

    private final void startLoading() {
        RotateAnimation rotationAnim = this.getRotateAnimation();
        CircularLoaderBaseView circularLoaderBaseView = this.circularLoaderBaseView;
        if (circularLoaderBaseView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"circularLoaderBaseView");
        }
        circularLoaderBaseView.startAnimation((Animation)rotationAnim);
    }

    private final RotateAnimation getRotateAnimation() {
        RotateAnimation transAnim = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f);
        transAnim.setDuration((long)this.animDuration);
        transAnim.setFillAfter(true);
        transAnim.setRepeatCount(-1);
        transAnim.setRepeatMode(1);
        transAnim.setInterpolator((Interpolator)new LinearInterpolator());
        return transAnim;
    }

    public RotatingCircularDotsLoader(@Nullable Context context) {
        super(context);
        this.dotsRadius = 30;
        this.dotsColor = this.getResources().getColor(R.color.loader_selected);
        this.bigCircleRadius = 90;
        this.animDuration = 5000;
        this.initView();
    }

    public RotatingCircularDotsLoader(@NotNull Context context, int dotsRadius, int bigCircleRadius, int dotsColor) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.dotsRadius = 30;
        this.dotsColor = this.getResources().getColor(R.color.loader_selected);
        this.bigCircleRadius = 90;
        this.animDuration = 5000;
        this.dotsRadius = dotsRadius;
        this.bigCircleRadius = bigCircleRadius;
        this.dotsColor = dotsColor;
        this.initView();
    }

    public RotatingCircularDotsLoader(@Nullable Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.dotsRadius = 30;
        this.dotsColor = this.getResources().getColor(R.color.loader_selected);
        this.bigCircleRadius = 90;
        this.animDuration = 5000;
        this.initAttributes(attrs);
        this.initView();
    }

    public RotatingCircularDotsLoader(@Nullable Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.dotsRadius = 30;
        this.dotsColor = this.getResources().getColor(R.color.loader_selected);
        this.bigCircleRadius = 90;
        this.animDuration = 5000;
        this.initAttributes(attrs);
        this.initView();
    }

    public static final /* synthetic */ void access$startLoading(RotatingCircularDotsLoader $this) {
        $this.startLoading();
    }
}

