/*
 * Decompiled with CFR 0.152.
 */
package com.agrawalsuneet.dotsloader.loaders;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.RotateAnimation;
import android.view.animation.ScaleAnimation;
import android.widget.LinearLayout;
import com.agrawalsuneet.dotsloader.R;
import com.agrawalsuneet.dotsloader.basicviews.CircularLoaderBaseView;
import com.agrawalsuneet.dotsloader.contracts.LoaderContract;
import com.agrawalsuneet.dotsloader.loaders.PullInLoader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005B'\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nB'\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB\u0019\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010B!\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0012J\b\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u00100\u001a\u00020/H\u0002J\u0018\u00101\u001a\u00020/2\u0006\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u0007H\u0014J\u0018\u00104\u001a\u00020/2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0007H\u0014J\b\u00108\u001a\u00020/H\u0002J\u0018\u00109\u001a\u00020\f2\u0006\u0010:\u001a\u00020\u00072\u0006\u0010;\u001a\u00020\u0007H\u0002J\u001a\u0010<\u001a\u00020/*\u00020=2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020/0?H\u0002R\u001a\u0010\u0013\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0015\"\u0004\b\u0019\u0010\u0017R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0015\"\u0004\b\u001d\u0010\u0017R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0015\"\u0004\b#\u0010\u0017R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u0006@"}, d2={"Lcom/agrawalsuneet/dotsloader/loaders/PullInLoader;", "Landroid/widget/LinearLayout;", "Lcom/agrawalsuneet/dotsloader/contracts/LoaderContract;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "dotsRadius", "", "bigCircleRadius", "dotsColor", "(Landroid/content/Context;III)V", "dotsColorsArray", "", "(Landroid/content/Context;II[I)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "animDuration", "getAnimDuration", "()I", "setAnimDuration", "(I)V", "getBigCircleRadius", "setBigCircleRadius", "circularLoaderBaseView", "Lcom/agrawalsuneet/dotsloader/basicviews/CircularLoaderBaseView;", "getDotsColor", "setDotsColor", "getDotsColorsArray", "()[I", "setDotsColorsArray", "([I)V", "getDotsRadius", "setDotsRadius", "useMultipleColors", "", "getUseMultipleColors", "()Z", "setUseMultipleColors", "(Z)V", "getRotateAnimation", "Landroid/view/animation/RotateAnimation;", "getScaleAnimation", "Landroid/view/animation/AnimationSet;", "initAttributes", "", "initView", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onVisibilityChanged", "changedView", "Landroid/view/View;", "visibility", "startLoading", "validateColorsArray", "arrayId", "color", "setListener", "Landroid/view/animation/Animation;", "onEnd", "Lkotlin/Function0;", "dotsloader_release"})
public final class PullInLoader
extends LinearLayout
implements LoaderContract {
    private int dotsRadius;
    private int bigCircleRadius;
    private boolean useMultipleColors;
    private int dotsColor;
    @NotNull
    private int[] dotsColorsArray;
    private int animDuration;
    private CircularLoaderBaseView circularLoaderBaseView;

    public final int getDotsRadius() {
        return this.dotsRadius;
    }

    public final void setDotsRadius(int n) {
        this.dotsRadius = n;
    }

    public final int getBigCircleRadius() {
        return this.bigCircleRadius;
    }

    public final void setBigCircleRadius(int n) {
        this.bigCircleRadius = n;
    }

    public final boolean getUseMultipleColors() {
        return this.useMultipleColors;
    }

    public final void setUseMultipleColors(boolean bl) {
        this.useMultipleColors = bl;
    }

    public final int getDotsColor() {
        return this.dotsColor;
    }

    public final void setDotsColor(int n) {
        this.dotsColor = n;
    }

    @NotNull
    public final int[] getDotsColorsArray() {
        return this.dotsColorsArray;
    }

    public final void setDotsColorsArray(@NotNull int[] nArray) {
        Intrinsics.checkParameterIsNotNull((Object)nArray, (String)"<set-?>");
        this.dotsColorsArray = nArray;
    }

    public final int getAnimDuration() {
        return this.animDuration;
    }

    public final void setAnimDuration(int n) {
        this.animDuration = n;
    }

    @Override
    public void initAttributes(@NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.PullInLoader, 0, 0);
        this.dotsRadius = typedArray.getDimensionPixelSize(R.styleable.PullInLoader_pullin_dotsRadius, 30);
        this.useMultipleColors = typedArray.getBoolean(R.styleable.PullInLoader_pullin_useMultipleColors, false);
        if (this.useMultipleColors) {
            int dotsArrayId = typedArray.getResourceId(R.styleable.PullInLoader_pullin_colorsArray, 0);
            this.dotsColorsArray = this.validateColorsArray(dotsArrayId, this.getResources().getColor(0x1060000));
        } else {
            this.dotsColor = typedArray.getColor(R.styleable.PullInLoader_pullin_dotsColor, this.getResources().getColor(0x1060000));
        }
        this.bigCircleRadius = typedArray.getDimensionPixelSize(R.styleable.PullInLoader_pullin_bigCircleRadius, 90);
        this.animDuration = typedArray.getInt(R.styleable.PullInLoader_pullin_animDur, 2000);
        typedArray.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int calWidthHeight = 2 * this.bigCircleRadius + 2 * this.dotsRadius;
        this.setMeasuredDimension(calWidthHeight, calWidthHeight);
    }

    /*
     * WARNING - void declaration
     */
    private final int[] validateColorsArray(int arrayId, int color2) {
        int[] nArray;
        if (arrayId != 0) {
            int[] colors = new int[8];
            int[] colorsArray = this.getResources().getIntArray(arrayId);
            int n = 0;
            int n2 = 7;
            while (n <= n2) {
                void i;
                colors[i] = colorsArray.length > i ? colorsArray[i] : color2;
                ++i;
            }
            nArray = colors;
        } else {
            int size$iv = 8;
            int[] result$iv = new int[size$iv];
            int i = 0;
            int n = result$iv.length;
            while (i < n) {
                int n3;
                void i$iv;
                void var7_11 = i$iv;
                void var11_13 = i$iv++;
                int[] nArray2 = result$iv;
                nArray2[var11_13] = n3 = color2;
            }
            nArray = result$iv;
        }
        return nArray;
    }

    private final void initView() {
        CircularLoaderBaseView circularLoaderBaseView;
        this.removeAllViews();
        this.removeAllViewsInLayout();
        if (this.useMultipleColors) {
            Context context = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            circularLoaderBaseView = new CircularLoaderBaseView(context, this.dotsRadius, this.bigCircleRadius, this.dotsColorsArray);
        } else {
            Context context = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            circularLoaderBaseView = new CircularLoaderBaseView(context, this.dotsRadius, this.bigCircleRadius, this.dotsColor);
        }
        CircularLoaderBaseView circularLoaderBaseView2 = this.circularLoaderBaseView = circularLoaderBaseView;
        if (circularLoaderBaseView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"circularLoaderBaseView");
        }
        this.addView(circularLoaderBaseView2);
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(this){
            final /* synthetic */ PullInLoader this$0;

            public void onGlobalLayout() {
                PullInLoader.access$startLoading(this.this$0);
                this.this$0.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    protected void onVisibilityChanged(@NotNull View changedView, int visibility) {
        Intrinsics.checkParameterIsNotNull((Object)changedView, (String)"changedView");
        super.onVisibilityChanged(changedView, visibility);
        if (visibility != 0) {
            this.initView();
        } else {
            CircularLoaderBaseView circularLoaderBaseView = this.circularLoaderBaseView;
            if (circularLoaderBaseView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"circularLoaderBaseView");
            }
            circularLoaderBaseView.clearAnimation();
        }
    }

    private final void startLoading() {
        CircularLoaderBaseView circularLoaderBaseView = this.circularLoaderBaseView;
        if (circularLoaderBaseView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"circularLoaderBaseView");
        }
        circularLoaderBaseView.clearAnimation();
        RotateAnimation rotationAnim = this.getRotateAnimation();
        this.setListener((Animation)rotationAnim, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ PullInLoader this$0;

            public final void invoke() {
                AnimationSet scaleAnimation = PullInLoader.access$getScaleAnimation(this.this$0);
                PullInLoader.access$setListener(this.this$0, (Animation)scaleAnimation, (Function0)new Function0<Unit>(this){
                    final /* synthetic */ startLoading.1 this$0;

                    public final void invoke() {
                        PullInLoader.access$startLoading(this.this$0.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
                PullInLoader.access$getCircularLoaderBaseView$p(this.this$0).startAnimation((Animation)scaleAnimation);
            }
            {
                this.this$0 = pullInLoader;
                super(0);
            }
        }));
        CircularLoaderBaseView circularLoaderBaseView2 = this.circularLoaderBaseView;
        if (circularLoaderBaseView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"circularLoaderBaseView");
        }
        circularLoaderBaseView2.startAnimation((Animation)rotationAnim);
    }

    private final void setListener(@NotNull Animation $receiver, Function0<Unit> onEnd) {
        $receiver.setAnimationListener(new Animation.AnimationListener(onEnd){
            final /* synthetic */ Function0 $onEnd;

            public void onAnimationRepeat(@Nullable Animation animation) {
            }

            public void onAnimationEnd(@Nullable Animation animation) {
                this.$onEnd.invoke();
            }

            public void onAnimationStart(@Nullable Animation animation) {
            }
            {
                this.$onEnd = $captured_local_variable$0;
            }
        });
    }

    private final RotateAnimation getRotateAnimation() {
        RotateAnimation transAnim = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f);
        transAnim.setDuration((long)this.animDuration);
        transAnim.setFillAfter(true);
        transAnim.setRepeatCount(0);
        transAnim.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        return transAnim;
    }

    private final AnimationSet getScaleAnimation() {
        CircularLoaderBaseView circularLoaderBaseView = this.circularLoaderBaseView;
        if (circularLoaderBaseView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"circularLoaderBaseView");
        }
        float f = circularLoaderBaseView.getWidth() / 2;
        CircularLoaderBaseView circularLoaderBaseView2 = this.circularLoaderBaseView;
        if (circularLoaderBaseView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"circularLoaderBaseView");
        }
        ScaleAnimation scaleAnimation = new ScaleAnimation(1.0f, 0.5f, 1.0f, 0.5f, f, (float)(circularLoaderBaseView2.getHeight() / 2));
        scaleAnimation.setRepeatCount(1);
        scaleAnimation.setRepeatMode(2);
        AlphaAnimation alphaAnimation = new AlphaAnimation(1.0f, 0.0f);
        alphaAnimation.setRepeatCount(1);
        alphaAnimation.setRepeatMode(2);
        AnimationSet animSet = new AnimationSet(true);
        animSet.addAnimation((Animation)scaleAnimation);
        animSet.addAnimation((Animation)alphaAnimation);
        animSet.setRepeatCount(1);
        animSet.setRepeatMode(2);
        animSet.setDuration(this.animDuration > 0 ? (long)(this.animDuration / 8) : 100L);
        animSet.setInterpolator((Interpolator)new AccelerateInterpolator());
        return animSet;
    }

    /*
     * WARNING - void declaration
     */
    public PullInLoader(@Nullable Context context) {
        super(context);
        void var3_4;
        int[] nArray;
        void size$iv;
        this.dotsRadius = 30;
        this.bigCircleRadius = 90;
        this.dotsColor = this.getResources().getColor(0x1060000);
        int n = 8;
        PullInLoader pullInLoader = this;
        int[] result$iv = new int[size$iv];
        int n2 = 0;
        int n3 = result$iv.length;
        while (n2 < n3) {
            int n4;
            void i$iv;
            void var6_7 = i$iv;
            void var11_9 = i$iv++;
            nArray = result$iv;
            nArray[var11_9] = n4 = this.getResources().getColor(0x1060000);
        }
        nArray = var3_4;
        pullInLoader.dotsColorsArray = nArray;
        this.animDuration = 3000;
        this.initView();
    }

    /*
     * WARNING - void declaration
     */
    public PullInLoader(@NotNull Context context, int dotsRadius, int bigCircleRadius, int dotsColor) {
        int[] nArray;
        void size$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.dotsRadius = 30;
        this.bigCircleRadius = 90;
        this.dotsColor = this.getResources().getColor(0x1060000);
        int n = 8;
        PullInLoader pullInLoader = this;
        int[] result$iv = new int[size$iv];
        int n2 = 0;
        int n3 = result$iv.length;
        while (n2 < n3) {
            int n4;
            void i$iv;
            void var9_10 = i$iv;
            void var14_12 = i$iv++;
            nArray = result$iv;
            nArray[var14_12] = n4 = this.getResources().getColor(0x1060000);
        }
        nArray = result$iv;
        pullInLoader.dotsColorsArray = nArray;
        this.animDuration = 3000;
        this.dotsRadius = dotsRadius;
        this.bigCircleRadius = bigCircleRadius;
        this.dotsColor = dotsColor;
        this.useMultipleColors = false;
        this.initView();
    }

    /*
     * WARNING - void declaration
     */
    public PullInLoader(@NotNull Context context, int dotsRadius, int bigCircleRadius, @NotNull int[] dotsColorsArray) {
        int[] nArray;
        void size$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)dotsColorsArray, (String)"dotsColorsArray");
        super(context);
        this.dotsRadius = 30;
        this.bigCircleRadius = 90;
        this.dotsColor = this.getResources().getColor(0x1060000);
        int n = 8;
        PullInLoader pullInLoader = this;
        int[] result$iv = new int[size$iv];
        int n2 = 0;
        int n3 = result$iv.length;
        while (n2 < n3) {
            int n4;
            void i$iv;
            void var9_10 = i$iv;
            void var14_12 = i$iv++;
            nArray = result$iv;
            nArray[var14_12] = n4 = this.getResources().getColor(0x1060000);
        }
        nArray = result$iv;
        pullInLoader.dotsColorsArray = nArray;
        this.animDuration = 3000;
        this.dotsRadius = dotsRadius;
        this.bigCircleRadius = bigCircleRadius;
        this.dotsColorsArray = dotsColorsArray;
        this.useMultipleColors = true;
        this.initView();
    }

    /*
     * WARNING - void declaration
     */
    public PullInLoader(@Nullable Context context, @NotNull AttributeSet attrs) {
        int[] nArray;
        void size$iv;
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.dotsRadius = 30;
        this.bigCircleRadius = 90;
        this.dotsColor = this.getResources().getColor(0x1060000);
        int n = 8;
        PullInLoader pullInLoader = this;
        int[] result$iv = new int[size$iv];
        int n2 = 0;
        int n3 = result$iv.length;
        while (n2 < n3) {
            int n4;
            void i$iv;
            void var7_8 = i$iv;
            void var12_10 = i$iv++;
            nArray = result$iv;
            nArray[var12_10] = n4 = this.getResources().getColor(0x1060000);
        }
        nArray = result$iv;
        pullInLoader.dotsColorsArray = nArray;
        this.animDuration = 3000;
        this.initAttributes(attrs);
        this.initView();
    }

    /*
     * WARNING - void declaration
     */
    public PullInLoader(@Nullable Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        int[] nArray;
        void size$iv;
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.dotsRadius = 30;
        this.bigCircleRadius = 90;
        this.dotsColor = this.getResources().getColor(0x1060000);
        int n = 8;
        PullInLoader pullInLoader = this;
        int[] result$iv = new int[size$iv];
        int n2 = 0;
        int n3 = result$iv.length;
        while (n2 < n3) {
            int n4;
            void i$iv;
            void var8_9 = i$iv;
            void var13_11 = i$iv++;
            nArray = result$iv;
            nArray[var13_11] = n4 = this.getResources().getColor(0x1060000);
        }
        nArray = result$iv;
        pullInLoader.dotsColorsArray = nArray;
        this.animDuration = 3000;
        this.initAttributes(attrs);
        this.initView();
    }

    public static final /* synthetic */ void access$startLoading(PullInLoader $this) {
        $this.startLoading();
    }

    @NotNull
    public static final /* synthetic */ AnimationSet access$getScaleAnimation(PullInLoader $this) {
        return $this.getScaleAnimation();
    }

    public static final /* synthetic */ void access$setListener(PullInLoader $this, @NotNull Animation $receiver, @NotNull Function0 onEnd) {
        $this.setListener($receiver, (Function0<Unit>)onEnd);
    }

    @NotNull
    public static final /* synthetic */ CircularLoaderBaseView access$getCircularLoaderBaseView$p(PullInLoader $this) {
        CircularLoaderBaseView circularLoaderBaseView = $this.circularLoaderBaseView;
        if (circularLoaderBaseView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"circularLoaderBaseView");
        }
        return circularLoaderBaseView;
    }

    public static final /* synthetic */ void access$setCircularLoaderBaseView$p(PullInLoader $this, @NotNull CircularLoaderBaseView circularLoaderBaseView) {
        $this.circularLoaderBaseView = circularLoaderBaseView;
    }
}

