/*
 * Decompiled with CFR 0.152.
 */
package com.agrawalsuneet.dotsloader.loaders;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.LinearLayout;
import com.agrawalsuneet.dotsloader.R;
import com.agrawalsuneet.dotsloader.basicviews.CircleView;
import com.agrawalsuneet.dotsloader.contracts.LoaderContract;
import com.agrawalsuneet.dotsloader.utils.HelperKt;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB/\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\n\u0012\u0006\u0010\u000e\u001a\u00020\n\u0012\u0006\u0010\u000f\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0010J\b\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010$\u001a\u00020#H\u0002J\u0018\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020\nH\u0014J\b\u0010(\u001a\u00020#H\u0002R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u000e\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0013\"\u0004\b\u0017\u0010\u0015R\u001a\u0010\r\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0013\"\u0004\b\u0019\u0010\u0015R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0013\"\u0004\b\u001f\u0010\u0015\u00a8\u0006)"}, d2={"Lcom/agrawalsuneet/dotsloader/loaders/LightsLoader;", "Landroid/widget/LinearLayout;", "Lcom/agrawalsuneet/dotsloader/contracts/LoaderContract;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "noOfCircles", "circleRadius", "circleDistance", "circleColor", "(Landroid/content/Context;IIII)V", "calWidthHeight", "getCircleColor", "()I", "setCircleColor", "(I)V", "getCircleDistance", "setCircleDistance", "getCircleRadius", "setCircleRadius", "circlesList", "Ljava/util/ArrayList;", "Lcom/agrawalsuneet/dotsloader/basicviews/CircleView;", "value", "getNoOfCircles", "setNoOfCircles", "getAlphaAnimation", "Landroid/view/animation/Animation;", "initAttributes", "", "initView", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "startLoading", "dotsloader_release"})
public final class LightsLoader
extends LinearLayout
implements LoaderContract {
    private int noOfCircles;
    private int circleRadius;
    private int circleDistance;
    private int circleColor;
    private int calWidthHeight;
    private ArrayList<CircleView> circlesList;

    public final int getNoOfCircles() {
        return this.noOfCircles;
    }

    public final void setNoOfCircles(int value) {
        this.noOfCircles = value < 1 ? 1 : value;
    }

    public final int getCircleRadius() {
        return this.circleRadius;
    }

    public final void setCircleRadius(int n) {
        this.circleRadius = n;
    }

    public final int getCircleDistance() {
        return this.circleDistance;
    }

    public final void setCircleDistance(int n) {
        this.circleDistance = n;
    }

    public final int getCircleColor() {
        return this.circleColor;
    }

    public final void setCircleColor(int n) {
        this.circleColor = n;
    }

    @Override
    public void initAttributes(@NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.LightsLoader, 0, 0);
        this.setNoOfCircles(typedArray.getInteger(R.styleable.LightsLoader_lights_noOfCircles, 3));
        this.circleRadius = typedArray.getDimensionPixelSize(R.styleable.LightsLoader_lights_circleRadius, 30);
        this.circleDistance = typedArray.getDimensionPixelSize(R.styleable.LightsLoader_lights_circleDistance, 10);
        this.circleColor = typedArray.getColor(R.styleable.LightsLoader_lights_circleColor, this.getResources().getColor(17170458));
        typedArray.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.calWidthHeight == 0) {
            this.calWidthHeight = 2 * this.circleRadius * this.noOfCircles + (this.noOfCircles - 1) * this.circleDistance;
        }
        this.setMeasuredDimension(this.calWidthHeight, this.calWidthHeight);
    }

    /*
     * WARNING - void declaration
     */
    private final void initView() {
        this.removeAllViews();
        this.removeAllViewsInLayout();
        this.setOrientation(1);
        this.circlesList = new ArrayList();
        if (this.calWidthHeight == 0) {
            this.calWidthHeight = 2 * this.circleRadius * this.noOfCircles + (this.noOfCircles - 1) * this.circleDistance;
        }
        int n = 0;
        int n2 = this.noOfCircles;
        while (n < n2) {
            void countI;
            LinearLayout linearLayout = new LinearLayout(this.getContext());
            linearLayout.setOrientation(0);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
            if (countI != false) {
                params.topMargin = this.circleDistance;
            }
            linearLayout.setLayoutParams((ViewGroup.LayoutParams)params);
            int n3 = 0;
            int n4 = this.noOfCircles;
            while (n3 < n4) {
                void countJ;
                Context context = this.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                CircleView circleView = new CircleView(context, this.circleRadius, this.circleColor, false, 8, null);
                LinearLayout.LayoutParams innerParam = new LinearLayout.LayoutParams(-2, -2);
                if (countJ != false) {
                    innerParam.leftMargin = this.circleDistance;
                }
                linearLayout.addView((View)circleView, (ViewGroup.LayoutParams)innerParam);
                ArrayList<CircleView> arrayList = this.circlesList;
                if (arrayList == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"circlesList");
                }
                arrayList.add(circleView);
                ++countJ;
            }
            this.addView((View)linearLayout);
            ++countI;
        }
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(this){
            final /* synthetic */ LightsLoader this$0;

            public void onGlobalLayout() {
                LightsLoader.access$startLoading(this.this$0);
                this.this$0.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void startLoading() {
        int n = 0;
        int n2 = this.noOfCircles;
        while (n < n2) {
            void count;
            ArrayList<CircleView> arrayList = this.circlesList;
            if (arrayList == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"circlesList");
            }
            for (CircleView item : arrayList) {
                item.startAnimation(this.getAlphaAnimation());
            }
            ++count;
        }
    }

    private final Animation getAlphaAnimation() {
        AlphaAnimation alphaAnimation;
        float fromAplha = HelperKt.random((ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)0.5f, (float)1.0f));
        float toAplha = HelperKt.random((ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)0.1f, (float)0.5f));
        AlphaAnimation $receiver = alphaAnimation = new AlphaAnimation(fromAplha, toAplha);
        int n = 100;
        $receiver.setDuration((long)HelperKt.random((ClosedRange<Integer>)((ClosedRange)new IntRange(n, 1000))));
        $receiver.setRepeatMode(2);
        $receiver.setRepeatCount(-1);
        AlphaAnimation alphaAnim = alphaAnimation;
        return (Animation)alphaAnim;
    }

    public LightsLoader(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.noOfCircles = 3;
        this.circleRadius = 30;
        this.circleDistance = 10;
        this.circleColor = this.getResources().getColor(17170458);
        this.initView();
    }

    public LightsLoader(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.noOfCircles = 3;
        this.circleRadius = 30;
        this.circleDistance = 10;
        this.circleColor = this.getResources().getColor(17170458);
        this.initAttributes(attrs);
        this.initView();
    }

    public LightsLoader(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.noOfCircles = 3;
        this.circleRadius = 30;
        this.circleDistance = 10;
        this.circleColor = this.getResources().getColor(17170458);
        this.initAttributes(attrs);
        this.initView();
    }

    public LightsLoader(@NotNull Context context, int noOfCircles, int circleRadius, int circleDistance, int circleColor) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.noOfCircles = 3;
        this.circleRadius = 30;
        this.circleDistance = 10;
        this.circleColor = this.getResources().getColor(17170458);
        this.setNoOfCircles(noOfCircles);
        this.circleRadius = circleRadius;
        this.circleDistance = circleDistance;
        this.circleColor = circleColor;
        this.initView();
    }

    public static final /* synthetic */ void access$startLoading(LightsLoader $this) {
        $this.startLoading();
    }
}

