/*
 * Decompiled with CFR 0.152.
 */
package com.agrawalsuneet.dotsloader.loaders;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.agrawalsuneet.dotsloader.R;
import com.agrawalsuneet.dotsloader.basicviews.CircleView;
import com.agrawalsuneet.dotsloader.contracts.LoaderContract;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005B\u0019\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB!\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB3\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\n\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0011J\b\u0010.\u001a\u00020/H\u0002J\b\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u0002032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u00104\u001a\u000203H\u0002J\u0018\u00105\u001a\u0002032\u0006\u00106\u001a\u00020\n2\u0006\u00107\u001a\u00020\nH\u0014J\b\u00108\u001a\u000203H\u0002R\u000e\u0010\u0012\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0019\"\u0004\b\u001f\u0010\u001bR\u001a\u0010\f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0019\"\u0004\b!\u0010\u001bR\u0010\u0010\"\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0019\"\u0004\b(\u0010\u001bR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/agrawalsuneet/dotsloader/loaders/BounceLoader;", "Landroid/widget/LinearLayout;", "Lcom/agrawalsuneet/dotsloader/contracts/LoaderContract;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "ballRadius", "ballColor", "showShadow", "", "shadowColor", "(Landroid/content/Context;IIZI)V", "STATE_COMINGUP", "STATE_GOINGDOWN", "STATE_RESIZING", "STATE_SQUEEZING", "value", "animDuration", "getAnimDuration", "()I", "setAnimDuration", "(I)V", "ballCircleView", "Lcom/agrawalsuneet/dotsloader/basicviews/CircleView;", "getBallColor", "setBallColor", "getBallRadius", "setBallRadius", "ballShadowView", "calHeight", "calWidth", "relativeLayout", "Landroid/widget/RelativeLayout;", "getShadowColor", "setShadowColor", "getShowShadow", "()Z", "setShowShadow", "(Z)V", "state", "getBallAnimation", "Landroid/view/animation/Animation;", "getShadowAnimation", "Landroid/view/animation/AnimationSet;", "initAttributes", "", "initView", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "startLoading", "dotsloader_release"})
public final class BounceLoader
extends LinearLayout
implements LoaderContract {
    private int ballRadius;
    private int ballColor;
    private boolean showShadow;
    private int shadowColor;
    private int animDuration;
    private RelativeLayout relativeLayout;
    private CircleView ballCircleView;
    private CircleView ballShadowView;
    private int calWidth;
    private int calHeight;
    private final int STATE_GOINGDOWN = 0;
    private final int STATE_SQUEEZING = 1;
    private final int STATE_RESIZING = 2;
    private final int STATE_COMINGUP = 3;
    private int state;

    public final int getBallRadius() {
        return this.ballRadius;
    }

    public final void setBallRadius(int n) {
        this.ballRadius = n;
    }

    public final int getBallColor() {
        return this.ballColor;
    }

    public final void setBallColor(int n) {
        this.ballColor = n;
    }

    public final boolean getShowShadow() {
        return this.showShadow;
    }

    public final void setShowShadow(boolean bl) {
        this.showShadow = bl;
    }

    public final int getShadowColor() {
        return this.shadowColor;
    }

    public final void setShadowColor(int n) {
        this.shadowColor = n;
    }

    public final int getAnimDuration() {
        return this.animDuration;
    }

    public final void setAnimDuration(int value) {
        this.animDuration = value <= 0 ? 1000 : value;
    }

    @Override
    public void initAttributes(@NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.BounceLoader, 0, 0);
        this.ballRadius = typedArray.getDimensionPixelSize(R.styleable.BounceLoader_bounce_ballRadius, 60);
        this.ballColor = typedArray.getColor(R.styleable.BounceLoader_bounce_ballColor, this.getResources().getColor(17170455));
        this.shadowColor = typedArray.getColor(R.styleable.BounceLoader_bounce_shadowColor, this.getResources().getColor(17170444));
        this.showShadow = typedArray.getBoolean(R.styleable.BounceLoader_bounce_showShadow, true);
        this.setAnimDuration(typedArray.getInt(R.styleable.BounceLoader_bounce_animDuration, 1500));
        typedArray.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.calWidth == 0 || this.calHeight == 0) {
            this.calWidth = 5 * this.ballRadius;
            this.calHeight = 8 * this.ballRadius;
        }
        this.setMeasuredDimension(this.calWidth, this.calHeight);
    }

    private final void initView() {
        this.removeAllViews();
        this.removeAllViewsInLayout();
        if (this.calWidth == 0 || this.calHeight == 0) {
            this.calWidth = 5 * this.ballRadius;
            this.calHeight = 8 * this.ballRadius;
        }
        this.relativeLayout = new RelativeLayout(this.getContext());
        if (this.showShadow) {
            Context context = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            this.ballShadowView = new CircleView(context, this.ballRadius, this.shadowColor, false);
            RelativeLayout.LayoutParams shadowParam = new RelativeLayout.LayoutParams(-2, -2);
            shadowParam.addRule(14, -1);
            shadowParam.addRule(12, -1);
            RelativeLayout relativeLayout = this.relativeLayout;
            if (relativeLayout != null) {
                relativeLayout.addView((View)this.ballShadowView, (ViewGroup.LayoutParams)shadowParam);
            }
        }
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        this.ballCircleView = new CircleView(context, this.ballRadius, this.ballColor, false, 8, null);
        RelativeLayout.LayoutParams ballParam = new RelativeLayout.LayoutParams(-2, -2);
        ballParam.addRule(14, -1);
        ballParam.addRule(12, -1);
        RelativeLayout relativeLayout = this.relativeLayout;
        if (relativeLayout != null) {
            relativeLayout.addView((View)this.ballCircleView, (ViewGroup.LayoutParams)ballParam);
        }
        RelativeLayout.LayoutParams relParam = new RelativeLayout.LayoutParams(this.calWidth, this.calHeight);
        this.addView((View)this.relativeLayout, (ViewGroup.LayoutParams)relParam);
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(this){
            final /* synthetic */ BounceLoader this$0;

            public void onGlobalLayout() {
                BounceLoader.access$startLoading(this.this$0);
                this.this$0.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void startLoading() {
        block7: {
            Animation ballAnim = this.getBallAnimation();
            ballAnim.setAnimationListener(new Animation.AnimationListener(this){
                final /* synthetic */ BounceLoader this$0;

                public void onAnimationEnd(@Nullable Animation anim) {
                    BounceLoader.access$setState$p(this.this$0, (BounceLoader.access$getState$p(this.this$0) + 1) % 4);
                    BounceLoader.access$startLoading(this.this$0);
                }

                public void onAnimationRepeat(@Nullable Animation p0) {
                }

                public void onAnimationStart(@Nullable Animation p0) {
                }
                {
                    this.this$0 = $outer;
                }
            });
            if (this.showShadow) {
                if (this.state == this.STATE_SQUEEZING || this.state == this.STATE_RESIZING) {
                    CircleView circleView = this.ballShadowView;
                    if (circleView != null) {
                        circleView.clearAnimation();
                    }
                    CircleView circleView2 = this.ballShadowView;
                    if (circleView2 != null) {
                        circleView2.setVisibility(8);
                    }
                } else {
                    CircleView circleView = this.ballShadowView;
                    if (circleView != null) {
                        circleView.setVisibility(0);
                    }
                    AnimationSet shadowAnim = this.getShadowAnimation();
                    CircleView circleView3 = this.ballShadowView;
                    if (circleView3 != null) {
                        circleView3.startAnimation((Animation)shadowAnim);
                    }
                }
            }
            CircleView circleView = this.ballCircleView;
            if (circleView == null) break block7;
            circleView.startAnimation(ballAnim);
        }
    }

    private final Animation getBallAnimation() {
        Animation animation;
        Animation animation2;
        TranslateAnimation $receiver;
        TranslateAnimation translateAnimation;
        int n = this.state;
        if (n == this.STATE_GOINGDOWN) {
            $receiver = translateAnimation = new TranslateAnimation(0.0f, 0.0f, (float)(-6 * this.ballRadius), 0.0f);
            $receiver.setDuration((long)this.animDuration);
            $receiver.setInterpolator((Interpolator)new AccelerateInterpolator());
            animation2 = (Animation)translateAnimation;
        } else if (n == this.STATE_SQUEEZING) {
            $receiver = translateAnimation = new ScaleAnimation(1.0f, 1.0f, 1.0f, 0.85f, (float)this.ballRadius, (float)(2 * this.ballRadius));
            $receiver.setDuration((long)(this.animDuration / 20));
            $receiver.setInterpolator((Interpolator)new AccelerateInterpolator());
            animation2 = (Animation)translateAnimation;
        } else if (n == this.STATE_RESIZING) {
            $receiver = translateAnimation = new ScaleAnimation(1.0f, 1.0f, 0.85f, 1.0f, (float)this.ballRadius, (float)(2 * this.ballRadius));
            $receiver.setDuration((long)(this.animDuration / 20));
            $receiver.setInterpolator((Interpolator)new DecelerateInterpolator());
            animation2 = (Animation)translateAnimation;
        } else {
            $receiver = translateAnimation = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)(-6 * this.ballRadius));
            $receiver.setDuration((long)this.animDuration);
            $receiver.setInterpolator((Interpolator)new DecelerateInterpolator());
            animation2 = (Animation)translateAnimation;
        }
        Animation $receiver2 = animation = animation2;
        $receiver2.setFillAfter(true);
        $receiver2.setRepeatCount(0);
        return animation;
    }

    private final AnimationSet getShadowAnimation() {
        AnimationSet animationSet;
        AlphaAnimation alphaAnim;
        Animation scaleAnim;
        Animation transAnim;
        AnimationSet set = new AnimationSet(true);
        int n = this.state;
        if (n == this.STATE_COMINGUP) {
            transAnim = (Animation)new TranslateAnimation(0.0f, (float)(-4 * this.ballRadius), 0.0f, (float)(-3 * this.ballRadius));
            scaleAnim = (Animation)new ScaleAnimation(0.9f, 0.5f, 0.9f, 0.5f, (float)this.ballRadius, (float)this.ballRadius);
            alphaAnim = new AlphaAnimation(0.6f, 0.2f);
            set.setInterpolator((Interpolator)new DecelerateInterpolator());
        } else {
            transAnim = (Animation)new TranslateAnimation((float)(-4 * this.ballRadius), 0.0f, (float)(-3 * this.ballRadius), 0.0f);
            scaleAnim = (Animation)new ScaleAnimation(0.5f, 0.9f, 0.5f, 0.9f, (float)this.ballRadius, (float)this.ballRadius);
            alphaAnim = new AlphaAnimation(0.2f, 0.6f);
            set.setInterpolator((Interpolator)new AccelerateInterpolator());
        }
        set.addAnimation(transAnim);
        set.addAnimation(scaleAnim);
        set.addAnimation((Animation)alphaAnim);
        AnimationSet $receiver = animationSet = set;
        $receiver.setDuration((long)this.animDuration);
        $receiver.setFillAfter(true);
        $receiver.setRepeatCount(0);
        return set;
    }

    public BounceLoader(@Nullable Context context) {
        super(context);
        this.ballRadius = 60;
        this.ballColor = this.getResources().getColor(17170455);
        this.showShadow = true;
        this.shadowColor = this.getResources().getColor(17170444);
        this.animDuration = 1500;
        this.STATE_SQUEEZING = 1;
        this.STATE_RESIZING = 2;
        this.STATE_COMINGUP = 3;
        this.state = this.STATE_GOINGDOWN;
        this.initView();
    }

    public BounceLoader(@Nullable Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.ballRadius = 60;
        this.ballColor = this.getResources().getColor(17170455);
        this.showShadow = true;
        this.shadowColor = this.getResources().getColor(17170444);
        this.animDuration = 1500;
        this.STATE_SQUEEZING = 1;
        this.STATE_RESIZING = 2;
        this.STATE_COMINGUP = 3;
        this.state = this.STATE_GOINGDOWN;
        this.initAttributes(attrs);
        this.initView();
    }

    public BounceLoader(@Nullable Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.ballRadius = 60;
        this.ballColor = this.getResources().getColor(17170455);
        this.showShadow = true;
        this.shadowColor = this.getResources().getColor(17170444);
        this.animDuration = 1500;
        this.STATE_SQUEEZING = 1;
        this.STATE_RESIZING = 2;
        this.STATE_COMINGUP = 3;
        this.state = this.STATE_GOINGDOWN;
        this.initAttributes(attrs);
        this.initView();
    }

    public BounceLoader(@Nullable Context context, int ballRadius, int ballColor, boolean showShadow, int shadowColor) {
        super(context);
        this.ballRadius = 60;
        this.ballColor = this.getResources().getColor(17170455);
        this.showShadow = true;
        this.shadowColor = this.getResources().getColor(17170444);
        this.animDuration = 1500;
        this.STATE_SQUEEZING = 1;
        this.STATE_RESIZING = 2;
        this.STATE_COMINGUP = 3;
        this.state = this.STATE_GOINGDOWN;
        this.ballRadius = ballRadius;
        this.ballColor = ballColor;
        this.shadowColor = shadowColor;
        this.initView();
    }

    public /* synthetic */ BounceLoader(Context context, int n, int n2, boolean bl, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x10) != 0) {
            n3 = 0;
        }
        this(context, n, n2, bl, n3);
    }

    public static final /* synthetic */ void access$startLoading(BounceLoader $this) {
        $this.startLoading();
    }

    public static final /* synthetic */ int access$getState$p(BounceLoader $this) {
        return $this.state;
    }

    public static final /* synthetic */ void access$setState$p(BounceLoader $this, int n) {
        $this.state = n;
    }
}

