/*
 * Decompiled with CFR 0.152.
 */
package com.agrawalsuneet.dotsloader.loaders;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.agrawalsuneet.dotsloader.R;
import com.agrawalsuneet.dotsloader.basicviews.CircleView;
import com.agrawalsuneet.dotsloader.contracts.LoaderContract;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bBI\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\n\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\n\u0012\u0006\u0010\u0011\u001a\u00020\n\u0012\u0006\u0010\u0012\u001a\u00020\n\u0012\u0006\u0010\u0013\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0014J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\nH\u0002J\u0010\u0010;\u001a\u00020<2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010=\u001a\u00020<H\u0002J\b\u0010>\u001a\u00020<H\u0002J\u0018\u0010?\u001a\u00020<2\u0006\u0010@\u001a\u00020\n2\u0006\u0010A\u001a\u00020\nH\u0014J\b\u0010B\u001a\u00020<H\u0002R\u001a\u0010\u0015\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0017\"\u0004\b\u001d\u0010\u0019R\u001a\u0010\f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010\u0011\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0017\"\u0004\b%\u0010\u0019R\u000e\u0010&\u001a\u00020'X\u0082.\u00a2\u0006\u0002\n\u0000RX\u0010(\u001aL\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020+0*0)0)j0\u0012,\u0012*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020+0*0)j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020+0*`,`,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020'X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0017\"\u0004\b1\u0010\u0019R\u000e\u00102\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u0017\"\u0004\b4\u0010\u0019R\u000e\u00105\u001a\u00020'X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0017\"\u0004\b7\u0010\u0019\u00a8\u0006C"}, d2={"Lcom/agrawalsuneet/dotsloader/loaders/AllianceLoader;", "Landroid/widget/LinearLayout;", "Lcom/agrawalsuneet/dotsloader/contracts/LoaderContract;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "dotsRadius", "distanceMultiplier", "drawOnlyStroke", "", "strokeWidth", "firsDotColor", "secondDotColor", "thirdDotColor", "(Landroid/content/Context;IIZIIII)V", "animDuration", "getAnimDuration", "()I", "setAnimDuration", "(I)V", "calWidthHeight", "value", "getDistanceMultiplier", "setDistanceMultiplier", "getDotsRadius", "setDotsRadius", "getDrawOnlyStroke", "()Z", "setDrawOnlyStroke", "(Z)V", "getFirsDotColor", "setFirsDotColor", "firstCircle", "Lcom/agrawalsuneet/dotsloader/basicviews/CircleView;", "posArrayList", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "", "Lkotlin/collections/ArrayList;", "relativeLayout", "Landroid/widget/RelativeLayout;", "secondCircle", "getSecondDotColor", "setSecondDotColor", "step", "getStrokeWidth", "setStrokeWidth", "thirdCircle", "getThirdDotColor", "setThirdDotColor", "getTranslateAnim", "Landroid/view/animation/TranslateAnimation;", "circleCount", "initAttributes", "", "initInitialValues", "initView", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "startLoading", "dotsloader_release"})
public final class AllianceLoader
extends LinearLayout
implements LoaderContract {
    private int dotsRadius;
    private int strokeWidth;
    private boolean drawOnlyStroke;
    private int distanceMultiplier;
    private int firsDotColor;
    private int secondDotColor;
    private int thirdDotColor;
    private int animDuration;
    private int step;
    private int calWidthHeight;
    private CircleView firstCircle;
    private CircleView secondCircle;
    private CircleView thirdCircle;
    private RelativeLayout relativeLayout;
    private ArrayList<ArrayList<Pair<Float, Float>>> posArrayList;

    public final int getDotsRadius() {
        return this.dotsRadius;
    }

    public final void setDotsRadius(int n) {
        this.dotsRadius = n;
    }

    public final int getStrokeWidth() {
        return this.strokeWidth;
    }

    public final void setStrokeWidth(int n) {
        this.strokeWidth = n;
    }

    public final boolean getDrawOnlyStroke() {
        return this.drawOnlyStroke;
    }

    public final void setDrawOnlyStroke(boolean bl) {
        this.drawOnlyStroke = bl;
    }

    public final int getDistanceMultiplier() {
        return this.distanceMultiplier;
    }

    public final void setDistanceMultiplier(int value) {
        this.distanceMultiplier = value < 1 ? 1 : value;
    }

    public final int getFirsDotColor() {
        return this.firsDotColor;
    }

    public final void setFirsDotColor(int n) {
        this.firsDotColor = n;
    }

    public final int getSecondDotColor() {
        return this.secondDotColor;
    }

    public final void setSecondDotColor(int n) {
        this.secondDotColor = n;
    }

    public final int getThirdDotColor() {
        return this.thirdDotColor;
    }

    public final void setThirdDotColor(int n) {
        this.thirdDotColor = n;
    }

    public final int getAnimDuration() {
        return this.animDuration;
    }

    public final void setAnimDuration(int n) {
        this.animDuration = n;
    }

    @Override
    public void initAttributes(@NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.AllianceLoader, 0, 0);
        this.dotsRadius = typedArray.getDimensionPixelSize(R.styleable.AllianceLoader_alliance_dotsRadius, 50);
        this.setDistanceMultiplier(typedArray.getInteger(R.styleable.AllianceLoader_alliance_distanceMultiplier, 4));
        this.firsDotColor = typedArray.getColor(R.styleable.AllianceLoader_alliance_firstDotsColor, this.getResources().getColor(R.color.loader_selected));
        this.secondDotColor = typedArray.getColor(R.styleable.AllianceLoader_alliance_secondDotsColor, this.getResources().getColor(R.color.loader_selected));
        this.thirdDotColor = typedArray.getColor(R.styleable.AllianceLoader_alliance_thirdDotsColor, this.getResources().getColor(R.color.loader_selected));
        this.drawOnlyStroke = typedArray.getBoolean(R.styleable.AllianceLoader_alliance_drawOnlyStroke, false);
        if (this.drawOnlyStroke) {
            this.strokeWidth = typedArray.getDimensionPixelSize(R.styleable.AllianceLoader_alliance_strokeWidth, 20);
        }
        this.animDuration = typedArray.getInt(R.styleable.AllianceLoader_alliance_animDuration, 500);
        typedArray.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.calWidthHeight == 0) {
            this.calWidthHeight = 2 * this.dotsRadius * this.distanceMultiplier + this.strokeWidth;
        }
        this.setMeasuredDimension(this.calWidthHeight, this.calWidthHeight);
    }

    private final void initView() {
        this.removeAllViews();
        this.removeAllViewsInLayout();
        this.setGravity(1);
        RelativeLayout relativeLayout = this.relativeLayout = new RelativeLayout(this.getContext());
        if (relativeLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"relativeLayout");
        }
        relativeLayout.setGravity(1);
        if (this.calWidthHeight == 0) {
            this.calWidthHeight = 2 * this.dotsRadius * this.distanceMultiplier + this.strokeWidth;
        }
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        this.firstCircle = new CircleView(context, this.dotsRadius, this.firsDotColor, this.drawOnlyStroke, this.strokeWidth);
        RelativeLayout.LayoutParams firstParam = new RelativeLayout.LayoutParams(-2, -2);
        firstParam.addRule(10, -1);
        firstParam.addRule(14, -1);
        RelativeLayout relativeLayout2 = this.relativeLayout;
        if (relativeLayout2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"relativeLayout");
        }
        CircleView circleView = this.firstCircle;
        if (circleView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"firstCircle");
        }
        relativeLayout2.addView((View)circleView, (ViewGroup.LayoutParams)firstParam);
        Context context2 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
        this.secondCircle = new CircleView(context2, this.dotsRadius, this.secondDotColor, this.drawOnlyStroke, this.strokeWidth);
        RelativeLayout.LayoutParams secondParam = new RelativeLayout.LayoutParams(-2, -2);
        secondParam.addRule(12, -1);
        secondParam.addRule(11, -1);
        RelativeLayout relativeLayout3 = this.relativeLayout;
        if (relativeLayout3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"relativeLayout");
        }
        CircleView circleView2 = this.secondCircle;
        if (circleView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"secondCircle");
        }
        relativeLayout3.addView((View)circleView2, (ViewGroup.LayoutParams)secondParam);
        Context context3 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"context");
        this.thirdCircle = new CircleView(context3, this.dotsRadius, this.thirdDotColor, this.drawOnlyStroke, this.strokeWidth);
        RelativeLayout.LayoutParams thirdParam = new RelativeLayout.LayoutParams(-2, -2);
        thirdParam.addRule(12, -1);
        thirdParam.addRule(9, -1);
        RelativeLayout relativeLayout4 = this.relativeLayout;
        if (relativeLayout4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"relativeLayout");
        }
        CircleView circleView3 = this.thirdCircle;
        if (circleView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"thirdCircle");
        }
        relativeLayout4.addView((View)circleView3, (ViewGroup.LayoutParams)thirdParam);
        RelativeLayout.LayoutParams relParam = new RelativeLayout.LayoutParams(this.calWidthHeight, this.calWidthHeight);
        RelativeLayout relativeLayout5 = this.relativeLayout;
        if (relativeLayout5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"relativeLayout");
        }
        this.addView((View)relativeLayout5, (ViewGroup.LayoutParams)relParam);
        this.initInitialValues();
        AllianceLoader loaderView = this;
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(this, loaderView){
            final /* synthetic */ AllianceLoader this$0;
            final /* synthetic */ AllianceLoader $loaderView;

            public void onGlobalLayout() {
                AllianceLoader.access$startLoading(this.this$0);
                ViewTreeObserver vto = this.$loaderView.getViewTreeObserver();
                vto.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
            {
                this.this$0 = $outer;
                this.$loaderView = $captured_local_variable$1;
            }
        });
    }

    private final void initInitialValues() {
        float fullDistance = this.calWidthHeight - (2 * this.dotsRadius + this.strokeWidth);
        float halfDistance = fullDistance / (float)2;
        ArrayList<Pair> firstPosArray = new ArrayList<Pair>();
        firstPosArray.add(new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)));
        firstPosArray.add(new Pair((Object)Float.valueOf(halfDistance), (Object)Float.valueOf(fullDistance)));
        firstPosArray.add(new Pair((Object)Float.valueOf(-halfDistance), (Object)Float.valueOf(fullDistance)));
        this.posArrayList.add(firstPosArray);
        ArrayList<Pair> secondPosArray = new ArrayList<Pair>();
        secondPosArray.add(new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)));
        secondPosArray.add(new Pair((Object)Float.valueOf(-fullDistance), (Object)Float.valueOf(0.0f)));
        secondPosArray.add(new Pair((Object)Float.valueOf(-halfDistance), (Object)Float.valueOf(-fullDistance)));
        this.posArrayList.add(secondPosArray);
        ArrayList<Pair> thirdPosArray = new ArrayList<Pair>();
        thirdPosArray.add(new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)));
        thirdPosArray.add(new Pair((Object)Float.valueOf(halfDistance), (Object)Float.valueOf(-fullDistance)));
        thirdPosArray.add(new Pair((Object)Float.valueOf(fullDistance), (Object)Float.valueOf(0.0f)));
        this.posArrayList.add(thirdPosArray);
    }

    private final void startLoading() {
        TranslateAnimation firstCircleAnim = this.getTranslateAnim(1);
        CircleView circleView = this.firstCircle;
        if (circleView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"firstCircle");
        }
        circleView.startAnimation((Animation)firstCircleAnim);
        TranslateAnimation secondCircleAnim = this.getTranslateAnim(2);
        CircleView circleView2 = this.secondCircle;
        if (circleView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"secondCircle");
        }
        circleView2.startAnimation((Animation)secondCircleAnim);
        TranslateAnimation thirdCircleAnim = this.getTranslateAnim(3);
        thirdCircleAnim.setAnimationListener(new Animation.AnimationListener(this){
            final /* synthetic */ AllianceLoader this$0;

            public void onAnimationEnd(@Nullable Animation p0) {
                AllianceLoader allianceLoader = this.this$0;
                int n = AllianceLoader.access$getStep$p(allianceLoader);
                AllianceLoader.access$setStep$p(allianceLoader, n + 1);
                if (AllianceLoader.access$getStep$p(this.this$0) > 2) {
                    AllianceLoader.access$setStep$p(this.this$0, 0);
                }
                AllianceLoader.access$startLoading(this.this$0);
            }

            public void onAnimationRepeat(@Nullable Animation p0) {
            }

            public void onAnimationStart(@Nullable Animation p0) {
            }
            {
                this.this$0 = $outer;
            }
        });
        CircleView circleView3 = this.thirdCircle;
        if (circleView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"thirdCircle");
        }
        circleView3.startAnimation((Animation)thirdCircleAnim);
    }

    private final TranslateAnimation getTranslateAnim(int circleCount) {
        int nextStep = this.step + 1;
        if (nextStep > 2) {
            nextStep = 0;
        }
        float fromXPos = ((Number)this.posArrayList.get(circleCount - 1).get(this.step).getFirst()).floatValue();
        float fromYPos = ((Number)this.posArrayList.get(circleCount - 1).get(this.step).getSecond()).floatValue();
        float toXPos = ((Number)this.posArrayList.get(circleCount - 1).get(nextStep).getFirst()).floatValue();
        float toYPos = ((Number)this.posArrayList.get(circleCount - 1).get(nextStep).getSecond()).floatValue();
        TranslateAnimation transAnim = new TranslateAnimation(fromXPos, toXPos, fromYPos, toYPos);
        transAnim.setDuration((long)this.animDuration);
        transAnim.setFillAfter(true);
        transAnim.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        transAnim.setRepeatCount(0);
        return transAnim;
    }

    public AllianceLoader(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.dotsRadius = 50;
        this.distanceMultiplier = 4;
        this.firsDotColor = this.getResources().getColor(17170455);
        this.secondDotColor = this.getResources().getColor(17170453);
        this.thirdDotColor = this.getResources().getColor(R.color.loader_selected);
        this.animDuration = 500;
        this.posArrayList = new ArrayList();
        this.initView();
    }

    public AllianceLoader(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.dotsRadius = 50;
        this.distanceMultiplier = 4;
        this.firsDotColor = this.getResources().getColor(17170455);
        this.secondDotColor = this.getResources().getColor(17170453);
        this.thirdDotColor = this.getResources().getColor(R.color.loader_selected);
        this.animDuration = 500;
        this.posArrayList = new ArrayList();
        this.initAttributes(attrs);
        this.initView();
    }

    public AllianceLoader(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.dotsRadius = 50;
        this.distanceMultiplier = 4;
        this.firsDotColor = this.getResources().getColor(17170455);
        this.secondDotColor = this.getResources().getColor(17170453);
        this.thirdDotColor = this.getResources().getColor(R.color.loader_selected);
        this.animDuration = 500;
        this.posArrayList = new ArrayList();
        this.initAttributes(attrs);
        this.initView();
    }

    public AllianceLoader(@Nullable Context context, int dotsRadius, int distanceMultiplier, boolean drawOnlyStroke, int strokeWidth, int firsDotColor, int secondDotColor, int thirdDotColor) {
        super(context);
        this.dotsRadius = 50;
        this.distanceMultiplier = 4;
        this.firsDotColor = this.getResources().getColor(17170455);
        this.secondDotColor = this.getResources().getColor(17170453);
        this.thirdDotColor = this.getResources().getColor(R.color.loader_selected);
        this.animDuration = 500;
        this.posArrayList = new ArrayList();
        this.dotsRadius = dotsRadius;
        this.setDistanceMultiplier(distanceMultiplier);
        this.drawOnlyStroke = drawOnlyStroke;
        this.strokeWidth = strokeWidth;
        this.firsDotColor = firsDotColor;
        this.secondDotColor = secondDotColor;
        this.thirdDotColor = thirdDotColor;
        this.initView();
    }

    public static final /* synthetic */ void access$startLoading(AllianceLoader $this) {
        $this.startLoading();
    }

    public static final /* synthetic */ int access$getStep$p(AllianceLoader $this) {
        return $this.step;
    }

    public static final /* synthetic */ void access$setStep$p(AllianceLoader $this, int n) {
        $this.step = n;
    }
}

