/*
 * Decompiled with CFR 0.152.
 */
package com.agilie.dribbblesdk.service.retrofit.services;

import com.agilie.dribbblesdk.domain.Bucket;
import com.agilie.dribbblesdk.domain.Followee;
import com.agilie.dribbblesdk.domain.Follower;
import com.agilie.dribbblesdk.domain.Like;
import com.agilie.dribbblesdk.domain.Project;
import com.agilie.dribbblesdk.domain.Shot;
import com.agilie.dribbblesdk.domain.Team;
import com.agilie.dribbblesdk.domain.User;
import java.util.List;
import retrofit2.Call;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface DribbbleUserService {
    @GET(value="users/{user}")
    public Call<User> getSingleUser(@Path(value="user") long var1);

    @GET(value="user")
    public Call<User> fetchAuthenticatedUser();

    @GET(value="users/{user}/buckets")
    public Call<List<Bucket>> getUsersBuckets(@Path(value="user") long var1);

    @GET(value="user/buckets")
    public Call<List<Bucket>> getAuthenticatedUsersBuckets();

    @GET(value="users/{user}/followers")
    public Call<List<Follower>> getUsersFollowers(@Path(value="user") long var1, @Query(value="page") int var3, @Query(value="per_page") int var4);

    @GET(value="user/followers")
    public Call<List<Follower>> getAuthenticatedUsersFollowers(@Query(value="page") int var1, @Query(value="per_page") int var2);

    @GET(value="users/{user}/following")
    public Call<List<Followee>> getFollowingByUser(@Path(value="user") long var1);

    @GET(value="users/{user}/following")
    public Call<List<Followee>> getFollowingByUser(@Path(value="user") long var1, @Query(value="page") int var3, @Query(value="per_page") int var4);

    @GET(value="user/following")
    public Call<List<Followee>> getFollowingByCurrentUser();

    @GET(value="user/following/shots")
    public Call<List<Shot>> shotsForUserFollowedByUser();

    @GET(value="user/following/{user}")
    public Call<Void> checkUserIsFollowed(@Path(value="user") long var1);

    @GET(value="users/{user}/following/{target_user}")
    public Call<Void> checkUserIsFollowingAnother(@Path(value="user") long var1, @Path(value="target_user") long var3);

    @PUT(value="users/{id}/follow")
    public Call<Void> followUser(@Path(value="id") long var1);

    @DELETE(value="users/{id}/follow")
    public Call<Void> unfollowUser(@Path(value="id") long var1);

    @GET(value="users/{user}/likes")
    public Call<List<Like>> getUsersLikes(@Path(value="user") long var1);

    @GET(value="users/{user}/likes")
    public Call<List<Like>> getUsersLikes(@Path(value="user") long var1, @Query(value="page") int var3, @Query(value="per_page") int var4);

    @GET(value="user/likes")
    public Call<List<Like>> getAuthenticatedUsersLikes();

    @GET(value="users/{user}/projects")
    public Call<List<Project>> getUsersProjects(@Path(value="user") long var1);

    @GET(value="user/projects")
    public Call<List<Project>> getAuthenticatedUsersProjects();

    @GET(value="users/{user}/shots")
    public Call<List<Shot>> getUsersShots(@Path(value="user") long var1);

    @GET(value="users/{user}/shots")
    public Call<List<Shot>> getUsersShots(@Path(value="user") long var1, @Query(value="page") int var3, @Query(value="per_page") int var4);

    @GET(value="user/shots")
    public Call<List<Shot>> getAuthenticatedUsersShots(@Query(value="page") int var1, @Query(value="per_page") int var2);

    @GET(value="users/{user}/teams")
    public Call<List<Team>> getUsersTeams(@Path(value="user") long var1);

    @GET(value="user/teams")
    public Call<List<Team>> getAuthenticatedUsersTeams(@Query(value="page") int var1);
}

