/*
 * Decompiled with CFR 0.152.
 */
package com.agilie.dribbblesdk.service.retrofit.services;

import com.agilie.dribbblesdk.domain.Attachment;
import com.agilie.dribbblesdk.domain.Bucket;
import com.agilie.dribbblesdk.domain.Comment;
import com.agilie.dribbblesdk.domain.Like;
import com.agilie.dribbblesdk.domain.Project;
import com.agilie.dribbblesdk.domain.Rebound;
import com.agilie.dribbblesdk.domain.Shot;
import java.util.List;
import java.util.Map;
import okhttp3.MultipartBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Part;
import retrofit2.http.PartMap;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;

public interface DribbbleShotsService {
    @GET(value="shots")
    public Call<List<Shot>> fetchShots(@Query(value="page") int var1);

    @GET(value="shots")
    public Call<List<Shot>> fetchShots(@Query(value="page") int var1, @Query(value="per_page") int var2);

    @GET(value="shots")
    public Call<List<Shot>> fetchShots(@Query(value="page") int var1, @Query(value="per_page") int var2, @Query(value="list") String var3, @Query(value="sort") String var4);

    @GET(value="shots")
    public Call<List<Shot>> fetchShots(@Query(value="page") int var1, @Query(value="per_page") int var2, @Query(value="list") String var3, @Query(value="sort") String var4, @Query(value="date") String var5, @Query(value="timeframe") String var6);

    @GET(value="shots")
    public Call<List<Shot>> fetchShots(@Query(value="page") int var1, @Query(value="list") String var2, @Query(value="sort") String var3, @Query(value="date") String var4, @Query(value="timeframe") String var5);

    @GET(value="shots")
    public Call<List<Shot>> fetchShots(@Query(value="list") String var1);

    @GET(value="shots")
    public Call<List<Shot>> fetchShots(@QueryMap Map<String, Object> var1);

    @GET(value="shots")
    public Call<List<Shot>> fetchSortedShots(@Query(value="sort") String var1);

    @GET(value="shots/{id}")
    public Call<Shot> getShot(@Path(value="id") long var1);

    @Multipart
    @POST(value="shots")
    public Call<Void> createShot(@Part(value="title") String var1, @Part MultipartBody.Part var2, @Part(value="description") String var3, @Part(value="tags") String[] var4, @Part(value="team_id") int var5, @Part(value="rebound_source_id") int var6);

    @Multipart
    @POST(value="shots")
    public Call<Void> createShot(@Part(value="title") String var1, @Part MultipartBody.Part var2, @Part(value="description") String var3, @Part(value="tags") String[] var4);

    @Multipart
    @POST(value="shots")
    public Call<Void> createShot(@Part(value="title") String var1, @Part MultipartBody.Part var2);

    @Multipart
    @POST(value="shots")
    public Call<Void> createShot(@PartMap Map<String, Object> var1);

    @Multipart
    @PUT(value="shots/{id}")
    public Call<Shot> updateShot(@Path(value="id") long var1, @Part(value="title") String var3, @Part(value="description") String var4, @Part(value="team_id") int var5, @Part(value="tags") String[] var6);

    @Multipart
    @PUT(value="shots/{id}")
    public Call<Shot> updateShot(@Path(value="id") long var1, @Part(value="title") String var3, @Part(value="description") String var4, @Part(value="tags") String[] var5);

    @Multipart
    @PUT(value="shots/{id}")
    public Call<Shot> updateShot(@Path(value="id") long var1, @Part(value="description") String var3);

    @DELETE(value="shots/{id}")
    public Call<Void> deleteShot(@Path(value="id") long var1);

    @GET(value="shots/{id}/attachments")
    public Call<List<Attachment>> getShotAttachments(@Path(value="id") long var1);

    @POST(value="shots/{shot}/attachments")
    public Call<Void> createShotAttachment(@Path(value="shot") long var1, @Part MultipartBody.Part var3);

    @GET(value="shots/{shot}/attachments/{id}")
    public Call<Attachment> getShotAttachment(@Path(value="shot") long var1, @Path(value="id") long var3);

    @DELETE(value="shots/{shot}/attachments/{id}")
    public Call<Void> deleteShotAttachment(@Path(value="shot") long var1, @Path(value="id") long var3);

    @GET(value="shots/{id}/buckets")
    public Call<List<Bucket>> getShotBuckets(@Path(value="id") long var1);

    @GET(value="shots/{shot}/comments")
    public Call<List<Comment>> getShotComments(@Path(value="shot") long var1);

    @GET(value="shots/{shot}/comments/{id}/likes")
    public Call<List<Like>> getCommentLikes(@Path(value="shot") long var1, @Path(value="id") long var3);

    @POST(value="shots/{shot}/comments")
    public Call<Comment> createComment(@Path(value="shot") long var1, @Body Comment var3);

    @GET(value="shots/{shot}/comments/{id}")
    public Call<Comment> getShotComment(@Path(value="shot") long var1, @Path(value="id") long var3);

    @PUT(value="shots/{shot}/comments/{id}")
    public Call<Comment> updateShotComment(@Path(value="shot") long var1, @Path(value="id") long var3, @Body Comment var5);

    @DELETE(value="shots/{shot}/comments/{id}")
    public Call<Void> deleteShotComment(@Path(value="shot") long var1, @Path(value="id") long var3);

    @GET(value="shots/{shot}/comments/{id}/like")
    public Call<Like> checkIsLikedShotComment(@Path(value="shot") long var1, @Path(value="id") long var3);

    @POST(value="shots/{shot}/comments/{id}/like")
    public Call<Like> likeShotComment(@Path(value="shot") long var1, @Path(value="id") long var3);

    @DELETE(value="shots/{shot}/comments/{id}/like")
    public Call<Void> unlikeShotComment(@Path(value="shot") long var1, @Path(value="id") long var3);

    @GET(value="shots/{id}/likes")
    public Call<List<Like>> getShotLikes(@Path(value="id") long var1);

    @GET(value="shots/{id}/like")
    public Call<Like> checkShotIsLiked(@Path(value="id") long var1);

    @POST(value="shots/{id}/like")
    public Call<Like> likeShot(@Path(value="id") long var1);

    @DELETE(value="shots/{id}/like")
    public Call<Void> unlikeShot(@Path(value="id") long var1);

    @GET(value="shots/{id}/projects")
    public Call<List<Project>> getShotProjectsList(@Path(value="id") long var1);

    @GET(value="shots/{id}/rebounds")
    public Call<List<Rebound>> getShotReboundsList(@Path(value="id") long var1);
}

