/*
 * Decompiled with CFR 0.152.
 */
package com.agilie.dribbblesdk.service.retrofit;

import android.os.Build;
import android.util.Log;
import com.agilie.dribbblesdk.service.retrofit.Tls12SocketFactory;
import com.agilie.dribbblesdk.service.retrofit.services.DribbbleBucketsService;
import com.agilie.dribbblesdk.service.retrofit.services.DribbbleProjectsService;
import com.agilie.dribbblesdk.service.retrofit.services.DribbbleShotsService;
import com.agilie.dribbblesdk.service.retrofit.services.DribbbleTeamsService;
import com.agilie.dribbblesdk.service.retrofit.services.DribbbleUserService;
import java.io.IOException;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.ConnectionSpec;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.TlsVersion;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class DribbbleWebServiceHelper {
    public static String DRIBBBLE_URL = "https://api.dribbble.com/v1/";

    public static DribbbleBucketsService getDribbbleBucketService(Retrofit retrofit) {
        DribbbleBucketsService service = (DribbbleBucketsService)retrofit.create(DribbbleBucketsService.class);
        return service;
    }

    public static DribbbleProjectsService getDribbbleProjectService(Retrofit retrofit) {
        DribbbleProjectsService service = (DribbbleProjectsService)retrofit.create(DribbbleProjectsService.class);
        return service;
    }

    public static DribbbleShotsService getDribbbleShotService(Retrofit retrofit) {
        DribbbleShotsService service = (DribbbleShotsService)retrofit.create(DribbbleShotsService.class);
        return service;
    }

    public static DribbbleTeamsService getDribbbleTeamService(Retrofit retrofit) {
        DribbbleTeamsService service = (DribbbleTeamsService)retrofit.create(DribbbleTeamsService.class);
        return service;
    }

    public static DribbbleUserService getDribbbleUserService(Retrofit retrofit) {
        DribbbleUserService service = (DribbbleUserService)retrofit.create(DribbbleUserService.class);
        return service;
    }

    public static OkHttpClient.Builder getOkHttpClientBuilder(final String authToken) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                Request authRequest = request.newBuilder().addHeader("Authorization", "Bearer " + authToken).build();
                return chain.proceed(authRequest);
            }
        });
        return DribbbleWebServiceHelper.enableTls12OnPreLollipop(builder);
    }

    public static Retrofit.Builder getRetrofitBuilder(OkHttpClient.Builder builder) {
        return new Retrofit.Builder().baseUrl(DRIBBBLE_URL).client(builder.build()).addConverterFactory((Converter.Factory)GsonConverterFactory.create());
    }

    public static OkHttpClient.Builder enableTls12OnPreLollipop(OkHttpClient.Builder client) {
        if (Build.VERSION.SDK_INT < 22) {
            try {
                SSLContext sc = SSLContext.getInstance("TLSv1.2");
                sc.init(null, null, null);
                client.sslSocketFactory((SSLSocketFactory)new Tls12SocketFactory(sc.getSocketFactory()));
                ConnectionSpec cs = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2}).build();
                ArrayList<ConnectionSpec> specs = new ArrayList<ConnectionSpec>();
                specs.add(cs);
                specs.add(ConnectionSpec.COMPATIBLE_TLS);
                specs.add(ConnectionSpec.CLEARTEXT);
                client.connectionSpecs(specs);
            }
            catch (Exception exc) {
                Log.e((String)"OkHttpTLSCompat", (String)"Error while setting TLS 1.2", (Throwable)exc);
            }
        }
        return client;
    }
}

