/*
 * Decompiled with CFR 0.152.
 */
package com.agilie.dribbblesdk.service.auth;

import android.content.Context;
import android.os.Build;
import android.support.v4.app.FragmentActivity;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.agilie.dribbblesdk.oAuth.AuthorizationFlow;
import com.agilie.dribbblesdk.oAuth.DialogFragmentController;
import com.agilie.dribbblesdk.oAuth.OAuthManager;
import com.agilie.dribbblesdk.oAuth.oauth2.implicit.ImplicitResponseUrl;
import com.agilie.dribbblesdk.oAuth.oauth2.store.SharedPreferencesCredentialStore;
import com.agilie.dribbblesdk.service.auth.AuthCredentials;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.extensions.android.http.AndroidHttp;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.CancellationException;

public class DribbbleAuthHelper {
    public static void startOauthDialog(final FragmentActivity activity, final AuthCredentials credentials, final AuthListener listener) {
        new Thread(){

            @Override
            public void run() {
                block3: {
                    super.run();
                    try {
                        Credential credential = DribbbleAuthHelper.getOauth(activity, credentials).authorizeExplicitly("dribbble", null, null).getResult();
                        if (listener != null) {
                            listener.onSuccess(credential);
                        }
                    }
                    catch (IOException | CancellationException ex) {
                        if (listener == null) break block3;
                        listener.onError(ex);
                    }
                }
            }
        }.start();
    }

    private static OAuthManager getOauth(FragmentActivity activity, final AuthCredentials credentials) {
        SharedPreferencesCredentialStore credentialStore = new SharedPreferencesCredentialStore((Context)activity, "credential_store_name", (JsonFactory)new JacksonFactory());
        AuthorizationFlow.Builder builder = new AuthorizationFlow.Builder(BearerToken.authorizationHeaderAccessMethod(), AndroidHttp.newCompatibleTransport(), (JsonFactory)new JacksonFactory(), new GenericUrl("https://dribbble.com/oauth/token"), (HttpExecuteInterceptor)new ClientParametersAuthentication(credentials.getClientId(), credentials.getClientSecret()), credentials.getClientId(), credentials.getOauthUrl());
        if (credentials.getScopes() != null) {
            builder.setScopes((Collection)credentials.getScopes());
        }
        builder.setCredentialStore(credentialStore);
        AuthorizationFlow flow = builder.build();
        DialogFragmentController controller = new DialogFragmentController(activity.getSupportFragmentManager()){

            @Override
            public String getRedirectUri() throws IOException {
                return credentials.getRedirectUrl();
            }

            @Override
            public boolean isJavascriptEnabledForWebView() {
                return true;
            }

            @Override
            public ImplicitResponseUrl waitForImplicitResponseUrl() throws IOException {
                return super.waitForImplicitResponseUrl();
            }
        };
        OAuthManager oauth = new OAuthManager(flow, controller);
        return oauth;
    }

    public static boolean logout(FragmentActivity activity, AuthCredentials credentials) {
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                CookieManager.getInstance().removeAllCookies(null);
            } else {
                CookieSyncManager.createInstance((Context)activity);
                CookieManager.getInstance().removeAllCookie();
            }
            return DribbbleAuthHelper.getOauth(activity, credentials).deleteCredential("dribbble", null, null).getResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static interface AuthListener {
        public void onSuccess(Credential var1);

        public void onError(Exception var1);
    }
}

