/*
 * Decompiled with CFR 0.152.
 */
package com.agilie.dribbblesdk.service.auth;

import android.text.TextUtils;
import java.util.Collection;

public class AuthCredentials {
    private String clientId;
    private String clientSecret;
    private String clientAccessToken;
    private String redirectUrl;
    private String state;
    private Collection<String> scopes;

    private AuthCredentials(String clientId, String clientSecret, String clientAccessToken, String redirectUrl) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.clientAccessToken = clientAccessToken;
        this.redirectUrl = redirectUrl;
    }

    public String getOauthUrl() {
        if (TextUtils.isEmpty((CharSequence)this.state)) {
            return "https://dribbble.com/oauth/authorize";
        }
        return "https://dribbble.com/oauth/authorize" + String.format("?state=%s", this.state);
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getClientAccessToken() {
        return this.clientAccessToken;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public String getState() {
        return this.state;
    }

    public Collection<String> getScopes() {
        return this.scopes;
    }

    public static Builder newBuilder(String clientId, String clientSecret, String clientAccessToken, String redirectUrl) {
        AuthCredentials authCredentials = new AuthCredentials(clientId, clientSecret, clientAccessToken, redirectUrl);
        authCredentials.getClass();
        return authCredentials.new Builder();
    }

    public class Builder {
        private Builder() {
        }

        public Builder setState(String state) {
            AuthCredentials.this.state = state;
            return this;
        }

        public Builder setScope(Collection<String> scope) {
            AuthCredentials.this.scopes = scope;
            return this;
        }

        public AuthCredentials build() {
            return AuthCredentials.this;
        }
    }
}

