/*
 * Decompiled with CFR 0.152.
 */
package com.agilie.dribbblesdk.oAuth.oauth2.store;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.agilie.dribbblesdk.oAuth.oauth2.store.FilePersistedCredential;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialStore;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Preconditions;
import java.io.IOException;

@TargetApi(value=9)
public class SharedPreferencesCredentialStore
implements CredentialStore {
    private final JsonFactory jsonFactory;
    private final SharedPreferences prefs;

    public SharedPreferencesCredentialStore(Context context, String name, JsonFactory jsonFactory) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)name);
        this.prefs = (SharedPreferences)Preconditions.checkNotNull((Object)context.getSharedPreferences(name, 0));
        this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory);
    }

    public boolean load(String userId, Credential credential) throws IOException {
        Preconditions.checkNotNull((Object)userId);
        String credentialJson = this.prefs.getString(userId, null);
        if (TextUtils.isEmpty((CharSequence)credentialJson)) {
            return false;
        }
        FilePersistedCredential fileCredential = (FilePersistedCredential)((Object)this.jsonFactory.fromString(credentialJson, FilePersistedCredential.class));
        if (fileCredential == null) {
            return false;
        }
        fileCredential.load(credential);
        return true;
    }

    public void store(String userId, Credential credential) throws IOException {
        Preconditions.checkNotNull((Object)userId);
        FilePersistedCredential fileCredential = new FilePersistedCredential();
        fileCredential.store(credential);
        String credentialJson = this.jsonFactory.toString((Object)fileCredential);
        this.prefs.edit().putString(userId, credentialJson).apply();
    }

    public void delete(String userId, Credential credential) throws IOException {
        Preconditions.checkNotNull((Object)userId);
        this.prefs.edit().remove(userId).apply();
    }
}

