/*
 * Decompiled with CFR 0.152.
 */
package com.agilie.dribbblesdk.oAuth.oauth2.store;

import com.agilie.dribbblesdk.oAuth.oauth.OAuthHmacCredential;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.json.GenericJson;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Key;

@Beta
public class FilePersistedCredential
extends GenericJson {
    @Key(value="access_token")
    private String accessToken;
    @Key(value="refresh_token")
    private String refreshToken;
    @Key(value="expiration_time_millis")
    private Long expirationTimeMillis;
    @Key(value="token_shared_secret")
    private String tokenSharedSecret;
    @Key(value="consumer_key")
    private String consumerKey;
    @Key(value="shared_secret")
    private String sharedSecret;

    public String getAccessToken() {
        return (String)this.get("accessToken");
    }

    public String getRefreshToken() {
        return (String)this.get("refreshToken");
    }

    public Long getExpirationTimeMilliseconds() {
        return (Long)this.get("expirationTimeMillis");
    }

    public String getTokenSharedSecret() {
        return (String)this.get("tokenSharedSecret");
    }

    public String getConsumerKey() {
        return (String)this.get("consumerKey");
    }

    public String getSharedSecret() {
        return (String)this.get("sharedSecret");
    }

    public void setAccessToken(String accessToken) {
        this.set("accessToken", accessToken);
    }

    public void setRefreshToken(String refreshToken) {
        this.set("refreshToken", refreshToken);
    }

    public void setExpirationTimeMilliseconds(Long expirationTimeMilliseconds) {
        this.set("expirationTimeMillis", expirationTimeMilliseconds);
    }

    public void setTokenSharedSecret(String tokenSharedSecret) {
        this.set("tokenSharedSecret", tokenSharedSecret);
    }

    public void setConsumerKey(String consumerKey) {
        this.set("consumerKey", consumerKey);
    }

    public void setSharedSecret(String sharedSecret) {
        this.set("sharedSecret", sharedSecret);
    }

    void store(Credential credential) {
        this.accessToken = credential.getAccessToken();
        this.refreshToken = credential.getRefreshToken();
        this.expirationTimeMillis = credential.getExpirationTimeMilliseconds();
        if (credential instanceof OAuthHmacCredential) {
            OAuthHmacCredential oauth10aCredential = (OAuthHmacCredential)credential;
            this.tokenSharedSecret = oauth10aCredential.getTokenSharedSecret();
            this.consumerKey = oauth10aCredential.getConsumerKey();
            this.sharedSecret = oauth10aCredential.getSharedSecret();
        }
    }

    void load(Credential credential) {
        credential.setAccessToken(this.accessToken);
        credential.setRefreshToken(this.refreshToken);
        credential.setExpirationTimeMilliseconds(this.expirationTimeMillis);
        if (credential instanceof OAuthHmacCredential) {
            OAuthHmacCredential oauth10aCredential = (OAuthHmacCredential)credential;
            oauth10aCredential.setTokenSharedSecret(this.tokenSharedSecret);
            oauth10aCredential.setConsumerKey(this.consumerKey);
            oauth10aCredential.setSharedSecret(this.sharedSecret);
        }
    }

    public FilePersistedCredential set(String fieldName, Object value) {
        return (FilePersistedCredential)super.set(fieldName, value);
    }

    public FilePersistedCredential clone() {
        return (FilePersistedCredential)super.clone();
    }
}

