/*
 * Decompiled with CFR 0.152.
 */
package com.agilie.dribbblesdk.oAuth.oauth2.implicit;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.UrlEncodedParser;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.escape.CharEscapers;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class ImplicitResponseUrl
extends GenericUrl {
    @Key(value="access_token")
    private String accessToken;
    @Key(value="token_type")
    private String tokenType;
    @Key(value="expires_in")
    private Long expiresInSeconds;
    @Key
    private String scope;
    @Key
    private String state;
    @Key
    private String error;
    @Key(value="error_description")
    private String errorDescription;
    @Key(value="error_uri")
    private String errorUri;

    ImplicitResponseUrl() {
    }

    public ImplicitResponseUrl(String encodedUrl) {
        this(ImplicitResponseUrl.toURI(encodedUrl));
    }

    ImplicitResponseUrl(URI uri) {
        this(uri.getScheme(), uri.getHost(), uri.getPort(), uri.getRawPath(), uri.getRawFragment(), uri.getRawQuery(), uri.getRawUserInfo());
    }

    ImplicitResponseUrl(URL url) {
        this(url.getProtocol(), url.getHost(), url.getPort(), url.getPath(), url.getRef(), url.getQuery(), url.getUserInfo());
    }

    private ImplicitResponseUrl(String scheme, String host, int port, String path, String fragment, String query, String userInfo) {
        this.setScheme(scheme);
        this.setHost(host);
        this.setPort(port);
        this.setPathParts(ImplicitResponseUrl.toPathParts((String)path));
        this.setFragment(fragment != null ? CharEscapers.decodeUri((String)fragment) : null);
        if (fragment != null) {
            UrlEncodedParser.parse((String)fragment, (Object)((Object)this));
        }
        this.setUserInfo(userInfo != null ? CharEscapers.decodeUri((String)userInfo) : null);
    }

    public final String getAccessToken() {
        return this.accessToken;
    }

    public ImplicitResponseUrl setAccessToken(String accessToken) {
        this.accessToken = (String)Preconditions.checkNotNull((Object)accessToken);
        return this;
    }

    public final String getTokenType() {
        return this.tokenType;
    }

    public ImplicitResponseUrl setTokenType(String tokenType) {
        this.tokenType = (String)Preconditions.checkNotNull((Object)tokenType);
        return this;
    }

    public final Long getExpiresInSeconds() {
        return this.expiresInSeconds;
    }

    public ImplicitResponseUrl setExpiresInSeconds(Long expiresInSeconds) {
        this.expiresInSeconds = expiresInSeconds;
        return this;
    }

    public final String getScope() {
        return this.scope;
    }

    public ImplicitResponseUrl setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public final String getState() {
        return this.state;
    }

    public ImplicitResponseUrl setState(String state) {
        this.state = state;
        return this;
    }

    public final String getError() {
        return this.error;
    }

    public ImplicitResponseUrl setError(String error) {
        this.error = error;
        return this;
    }

    public final String getErrorDescription() {
        return this.errorDescription;
    }

    public ImplicitResponseUrl setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
        return this;
    }

    public final String getErrorUri() {
        return this.errorUri;
    }

    public ImplicitResponseUrl setErrorUri(String errorUri) {
        this.errorUri = errorUri;
        return this;
    }

    public ImplicitResponseUrl set(String fieldName, Object value) {
        return (ImplicitResponseUrl)super.set(fieldName, value);
    }

    public ImplicitResponseUrl clone() {
        return (ImplicitResponseUrl)super.clone();
    }

    private static URI toURI(String encodedUrl) {
        try {
            return new URI(encodedUrl);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

