/*
 * Decompiled with CFR 0.152.
 */
package com.agilie.dribbblesdk.oAuth.oauth2.explicit;

import com.google.api.client.auth.oauth2.TokenErrorResponse;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.json.Json;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.StringUtils;
import com.google.api.client.util.Strings;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class LenientTokenResponseException
extends HttpResponseException {
    private static final long serialVersionUID = 7709534258323056472L;
    private final transient TokenErrorResponse details;

    LenientTokenResponseException(HttpResponseException.Builder builder, TokenErrorResponse details) {
        super(builder);
        this.details = details;
    }

    public final TokenErrorResponse getDetails() {
        return this.details;
    }

    public static LenientTokenResponseException from(JsonFactory jsonFactory, HttpResponse readResponse, String responseContent) {
        HttpResponseException.Builder builder = new HttpResponseException.Builder(readResponse.getStatusCode(), readResponse.getStatusMessage(), readResponse.getHeaders());
        Preconditions.checkNotNull((Object)jsonFactory);
        TokenErrorResponse details = null;
        String detailString = null;
        String contentType = readResponse.getContentType();
        try {
            if (contentType != null && HttpMediaType.equalsIgnoreParameters((String)Json.MEDIA_TYPE, (String)contentType)) {
                details = (TokenErrorResponse)readResponse.getRequest().getParser().parseAndClose((Reader)new StringReader(responseContent), TokenErrorResponse.class);
                detailString = details.toPrettyString();
            } else {
                detailString = responseContent;
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        StringBuilder message = HttpResponseException.computeMessageBuffer((HttpResponse)readResponse);
        if (!Strings.isNullOrEmpty((String)detailString)) {
            message.append(StringUtils.LINE_SEPARATOR).append(detailString);
            builder.setContent(detailString);
        }
        builder.setMessage(message.toString());
        return new LenientTokenResponseException(builder, details);
    }
}

