/*
 * Decompiled with CFR 0.152.
 */
package com.agilie.dribbblesdk.oAuth.oauth2.explicit;

import com.agilie.dribbblesdk.oAuth.oauth2.explicit.HttpResponseUtils;
import com.agilie.dribbblesdk.oAuth.oauth2.explicit.LenientTokenResponseException;
import com.google.api.client.auth.oauth2.AuthorizationCodeTokenRequest;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.auth.oauth2.TokenResponseException;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.ObjectParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Logger;

public class LenientAuthorizationCodeTokenRequest
extends AuthorizationCodeTokenRequest {
    static final Logger LOGGER = Logger.getLogger("OAuthAndroid");

    public LenientAuthorizationCodeTokenRequest(HttpTransport transport, JsonFactory jsonFactory, GenericUrl tokenServerUrl, String code) {
        super(transport, jsonFactory, tokenServerUrl, code);
    }

    public TokenResponse execute() throws IOException {
        return this.executeLeniently();
    }

    private TokenResponse executeLeniently() throws IOException {
        HttpRequestFactory requestFactory = this.getTransport().createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) throws IOException {
                if (LenientAuthorizationCodeTokenRequest.this.getRequestInitializer() != null) {
                    LenientAuthorizationCodeTokenRequest.this.getRequestInitializer().initialize(request);
                }
                final HttpExecuteInterceptor interceptor = request.getInterceptor();
                request.setInterceptor(new HttpExecuteInterceptor(){

                    public void intercept(HttpRequest request) throws IOException {
                        if (interceptor != null) {
                            interceptor.intercept(request);
                        }
                        if (LenientAuthorizationCodeTokenRequest.this.getClientAuthentication() != null) {
                            LenientAuthorizationCodeTokenRequest.this.getClientAuthentication().intercept(request);
                        }
                    }
                });
            }
        });
        HttpRequest request = requestFactory.buildPostRequest(this.getTokenServerUrl(), (HttpContent)new UrlEncodedContent((Object)this));
        request.setParser((ObjectParser)new JsonObjectParser(this.getJsonFactory()));
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        if (response.isSuccessStatusCode()) {
            if (!HttpResponseUtils.hasMessageBody(response)) {
                return null;
            }
            String responseContent = HttpResponseUtils.parseAsStringWithoutClosing(response);
            TokenResponse tokenResponse = (TokenResponse)response.getRequest().getParser().parseAndClose((Reader)new StringReader(responseContent), TokenResponse.class);
            if (tokenResponse.containsKey((Object)"error")) {
                throw LenientTokenResponseException.from(this.getJsonFactory(), response, responseContent);
            }
            return (TokenResponse)response.getRequest().getParser().parseAndClose((Reader)new StringReader(responseContent), TokenResponse.class);
        }
        throw TokenResponseException.from((JsonFactory)this.getJsonFactory(), (HttpResponse)response);
    }
}

