/*
 * Decompiled with CFR 0.152.
 */
package com.agilie.dribbblesdk.oAuth.oauth;

import com.google.api.client.auth.oauth.OAuthHmacSigner;
import com.google.api.client.auth.oauth.OAuthParameters;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialRefreshListener;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Clock;
import com.google.api.client.util.Preconditions;
import java.io.IOException;
import java.util.Collection;

public class OAuthHmacCredential
extends Credential {
    private String consumerKey;
    private String sharedSecret;
    private String tokenSharedSecret;
    private OAuthParameters authorizer;

    protected OAuthHmacCredential(Builder builder) {
        super((Credential.Builder)builder);
        this.consumerKey = builder.consumerKey;
        this.sharedSecret = builder.sharedSecret;
        this.postConstruct();
    }

    private void postConstruct() {
        OAuthHmacSigner signer = new OAuthHmacSigner();
        signer.clientSharedSecret = this.sharedSecret;
        signer.tokenSharedSecret = this.tokenSharedSecret;
        this.authorizer = new OAuthParameters();
        this.authorizer.consumerKey = this.consumerKey;
        this.authorizer.signer = signer;
        this.authorizer.token = this.getAccessToken();
    }

    public final String getConsumerKey() {
        return this.consumerKey;
    }

    public OAuthHmacCredential setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
        this.postConstruct();
        return this;
    }

    public final String getSharedSecret() {
        return this.sharedSecret;
    }

    public OAuthHmacCredential setSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
        this.postConstruct();
        return this;
    }

    public final String getTokenSharedSecret() {
        return this.tokenSharedSecret;
    }

    public OAuthHmacCredential setTokenSharedSecret(String tokenSharedSecret) {
        this.tokenSharedSecret = tokenSharedSecret;
        this.postConstruct();
        return this;
    }

    public OAuthHmacCredential setAccessToken(String accessToken) {
        super.setAccessToken(accessToken);
        this.postConstruct();
        return this;
    }

    public OAuthHmacCredential setRefreshToken(String refreshToken) {
        return (OAuthHmacCredential)super.setRefreshToken(refreshToken);
    }

    public OAuthHmacCredential setExpirationTimeMilliseconds(Long expirationTimeMilliseconds) {
        return (OAuthHmacCredential)super.setExpirationTimeMilliseconds(expirationTimeMilliseconds);
    }

    public OAuthHmacCredential setExpiresInSeconds(Long expiresIn) {
        return (OAuthHmacCredential)super.setExpiresInSeconds(expiresIn);
    }

    public OAuthHmacCredential setFromTokenResponse(TokenResponse tokenResponse) {
        return (OAuthHmacCredential)super.setFromTokenResponse(tokenResponse);
    }

    public void initialize(HttpRequest request) throws IOException {
        this.authorizer.initialize(request);
        super.initialize(request);
    }

    public void intercept(HttpRequest request) throws IOException {
        super.intercept(request);
        this.authorizer.intercept(request);
    }

    public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) {
        if (response.getStatusCode() == 401) {
            this.setAccessToken(null);
        }
        return false;
    }

    public static class Builder
    extends Credential.Builder {
        String consumerKey;
        String sharedSecret;

        public Builder(Credential.AccessMethod method, String consumerKey, String sharedSecret) {
            super(method);
            this.consumerKey = (String)Preconditions.checkNotNull((Object)consumerKey);
            this.sharedSecret = (String)Preconditions.checkNotNull((Object)sharedSecret);
        }

        public OAuthHmacCredential build() {
            return new OAuthHmacCredential(this);
        }

        public final String getConsumerKey() {
            return this.consumerKey;
        }

        public Builder setConsumerKey(String consumerKey) {
            this.consumerKey = consumerKey;
            return this;
        }

        public final String getSharedSecret() {
            return this.sharedSecret;
        }

        public Builder setSharedSecret(String sharedSecret) {
            this.sharedSecret = sharedSecret;
            return this;
        }

        public Builder setTransport(HttpTransport transport) {
            return (Builder)super.setTransport(transport);
        }

        public Builder setClock(Clock clock) {
            return (Builder)super.setClock(clock);
        }

        public Builder setJsonFactory(JsonFactory jsonFactory) {
            return (Builder)super.setJsonFactory(jsonFactory);
        }

        public Builder setTokenServerUrl(GenericUrl tokenServerUrl) {
            return (Builder)super.setTokenServerUrl(tokenServerUrl);
        }

        public Builder setTokenServerEncodedUrl(String tokenServerEncodedUrl) {
            return (Builder)super.setTokenServerEncodedUrl(tokenServerEncodedUrl);
        }

        public Builder setClientAuthentication(HttpExecuteInterceptor clientAuthentication) {
            return (Builder)super.setClientAuthentication(clientAuthentication);
        }

        public Builder setRequestInitializer(HttpRequestInitializer requestInitializer) {
            return (Builder)super.setRequestInitializer(requestInitializer);
        }

        public Builder setRefreshListeners(Collection<CredentialRefreshListener> refreshListeners) {
            return (Builder)super.setRefreshListeners(refreshListeners);
        }

        public Builder addRefreshListener(CredentialRefreshListener refreshListener) {
            return (Builder)super.addRefreshListener(refreshListener);
        }
    }
}

