/*
 * Decompiled with CFR 0.152.
 */
package com.agilie.dribbblesdk.oAuth;

import android.os.Handler;
import android.os.Looper;
import com.agilie.dribbblesdk.oAuth.AuthorizationFlow;
import com.agilie.dribbblesdk.oAuth.AuthorizationUIController;
import com.agilie.dribbblesdk.oAuth.oauth.OAuthHmacCredential;
import com.agilie.dribbblesdk.oAuth.oauth2.explicit.LenientTokenResponseException;
import com.agilie.dribbblesdk.oAuth.oauth2.implicit.ImplicitResponseUrl;
import com.google.api.client.auth.oauth.OAuthAuthorizeTemporaryTokenUrl;
import com.google.api.client.auth.oauth.OAuthCredentialsResponse;
import com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.api.client.auth.oauth2.BrowserClientRequestUrl;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialStore;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.auth.oauth2.TokenResponseException;
import com.google.api.client.util.Preconditions;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OAuthManager {
    static final Logger LOGGER = Logger.getLogger("OAuthAndroid");
    private final AuthorizationFlow mFlow;
    private final AuthorizationUIController mUIController;
    private final Handler mMainHandler = new Handler(Looper.getMainLooper());
    private final ExecutorService mExecutor;

    public OAuthManager(AuthorizationFlow flow, AuthorizationUIController uiController) {
        this(flow, uiController, Executors.newSingleThreadExecutor());
    }

    public OAuthManager(AuthorizationFlow flow, AuthorizationUIController uiController, ExecutorService executor) {
        this.mFlow = flow;
        this.mUIController = uiController;
        this.mExecutor = (ExecutorService)Preconditions.checkNotNull((Object)executor);
    }

    public OAuthFuture<Boolean> deleteCredential(final String userId, OAuthCallback<Boolean> callback, Handler handler) {
        Preconditions.checkNotNull((Object)userId);
        Future2Task<Boolean> task = new Future2Task<Boolean>(handler, callback){

            @Override
            public void doWork() throws Exception {
                LOGGER.info("deleteCredential");
                CredentialStore store = OAuthManager.this.mFlow.getCredentialStore();
                if (store == null) {
                    this.set(false);
                    return;
                }
                store.delete(userId, null);
                this.set(true);
            }
        };
        this.submitTaskToExecutor(task);
        return task;
    }

    public OAuthFuture<Credential> authorize10a(final String userId, OAuthCallback<Credential> callback, Handler handler) {
        Preconditions.checkNotNull((Object)userId);
        Future2Task<Credential> task = new Future2Task<Credential>(handler, callback){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doWork() throws Exception {
                try {
                    LOGGER.info("authorize10a");
                    OAuthHmacCredential credential = OAuthManager.this.mFlow.load10aCredential(userId);
                    if (credential != null && credential.getAccessToken() != null && (credential.getRefreshToken() != null || credential.getExpiresInSeconds() == null || credential.getExpiresInSeconds() > 60L)) {
                        this.set(credential);
                        return;
                    }
                    String redirectUri = OAuthManager.this.mUIController.getRedirectUri();
                    OAuthCredentialsResponse tempCredentials = OAuthManager.this.mFlow.new10aTemporaryTokenRequest(redirectUri);
                    OAuthAuthorizeTemporaryTokenUrl authorizationUrl = OAuthManager.this.mFlow.new10aAuthorizationUrl(tempCredentials.token);
                    OAuthManager.this.mUIController.requestAuthorization(authorizationUrl);
                    String code = OAuthManager.this.mUIController.waitForVerifierCode();
                    OAuthCredentialsResponse response = OAuthManager.this.mFlow.new10aTokenRequest(tempCredentials, code).execute();
                    credential = OAuthManager.this.mFlow.createAndStoreCredential(response, userId);
                    this.set(credential);
                }
                finally {
                    OAuthManager.this.mUIController.stop();
                }
            }
        };
        this.submitTaskToExecutor(task);
        return task;
    }

    public OAuthFuture<Credential> authorizeExplicitly(final String userId, OAuthCallback<Credential> callback, Handler handler) {
        Preconditions.checkNotNull((Object)userId);
        Future2Task<Credential> task = new Future2Task<Credential>(handler, callback){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doWork() throws Exception {
                try {
                    Credential credential = OAuthManager.this.mFlow.loadCredential(userId);
                    LOGGER.info("authorizeExplicitly");
                    if (credential != null && credential.getAccessToken() != null && (credential.getRefreshToken() != null || credential.getExpiresInSeconds() == null || credential.getExpiresInSeconds() > 60L)) {
                        this.set(credential);
                        return;
                    }
                    String redirectUri = OAuthManager.this.mUIController.getRedirectUri();
                    AuthorizationCodeRequestUrl authorizationUrl = OAuthManager.this.mFlow.newExplicitAuthorizationUrl().setRedirectUri(redirectUri);
                    OAuthManager.this.mUIController.requestAuthorization(authorizationUrl);
                    String code = OAuthManager.this.mUIController.waitForExplicitCode();
                    TokenResponse response = OAuthManager.this.mFlow.newTokenRequest(code).setRedirectUri(redirectUri).execute();
                    credential = OAuthManager.this.mFlow.createAndStoreCredential(response, userId);
                    this.set(credential);
                }
                finally {
                    OAuthManager.this.mUIController.stop();
                }
            }
        };
        this.submitTaskToExecutor(task);
        return task;
    }

    public OAuthFuture<Credential> authorizeImplicitly(final String userId, OAuthCallback<Credential> callback, Handler handler) {
        Preconditions.checkNotNull((Object)userId);
        Future2Task<Credential> task = new Future2Task<Credential>(handler, callback){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doWork() throws TokenResponseException, Exception {
                try {
                    LOGGER.info("authorizeImplicitly");
                    Credential credential = OAuthManager.this.mFlow.loadCredential(userId);
                    if (credential != null && credential.getAccessToken() != null && (credential.getRefreshToken() != null || credential.getExpiresInSeconds() == null || credential.getExpiresInSeconds() > 60L)) {
                        this.set(credential);
                        return;
                    }
                    String redirectUri = OAuthManager.this.mUIController.getRedirectUri();
                    BrowserClientRequestUrl authorizationUrl = OAuthManager.this.mFlow.newImplicitAuthorizationUrl().setRedirectUri(redirectUri);
                    OAuthManager.this.mUIController.requestAuthorization(authorizationUrl);
                    ImplicitResponseUrl implicitResponse = OAuthManager.this.mUIController.waitForImplicitResponseUrl();
                    credential = OAuthManager.this.mFlow.createAndStoreCredential(implicitResponse, userId);
                    this.set(credential);
                }
                finally {
                    OAuthManager.this.mUIController.stop();
                }
            }
        };
        this.submitTaskToExecutor(task);
        return task;
    }

    protected final void submitTaskToExecutor(final Future2Task<?> task) {
        this.mExecutor.submit(new Runnable(){

            @Override
            public void run() {
                task.start();
            }
        });
    }

    public abstract class Future2Task<T>
    extends BaseFutureTask<T>
    implements OAuthFuture<T> {
        final OAuthCallback<T> mCallback;

        public Future2Task(Handler handler, OAuthCallback<T> callback) {
            super(handler);
            this.mCallback = callback;
        }

        public Future2Task<T> start() {
            this.startTask();
            return this;
        }

        @Override
        protected void done() {
            if (this.mCallback != null) {
                this.postRunnableToHandler(new Runnable(){

                    @Override
                    public void run() {
                        Future2Task.this.mCallback.run(Future2Task.this);
                    }
                });
            }
        }

        @Override
        public T getResult() throws CancellationException, IOException {
            return this.internalGetResult(null, null);
        }

        @Override
        public T getResult(long timeout, TimeUnit unit) throws CancellationException, IOException {
            return this.internalGetResult(timeout, unit);
        }

        private T internalGetResult(Long timeout, TimeUnit unit) throws CancellationException, IOException {
            if (!this.isDone()) {
                this.ensureNotOnMainThread();
            }
            try {
                if (timeout == null) {
                    Object v = this.get();
                    return (T)v;
                }
                Object v = this.get(timeout, unit);
                return (T)v;
            }
            catch (CancellationException e) {
                throw new CancellationException(e.getMessage());
            }
            catch (TimeoutException e) {
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof LenientTokenResponseException) {
                    throw (LenientTokenResponseException)((Object)cause);
                }
                if (cause instanceof TokenResponseException) {
                    throw (TokenResponseException)cause;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new IllegalStateException(cause);
            }
            finally {
                this.cancel(true);
            }
            throw new CancellationException();
        }

        private void ensureNotOnMainThread() {
            Looper looper = Looper.myLooper();
            if (looper != null && looper == Looper.getMainLooper()) {
                IllegalStateException exception = new IllegalStateException("calling this from your main thread can lead to deadlock");
                LOGGER.log(Level.WARNING, "calling this from your main thread can lead to deadlock and/or ANRs", exception);
                throw exception;
            }
        }
    }

    private abstract class BaseFutureTask<T>
    extends FutureTask<T> {
        final Handler mHandler;

        public BaseFutureTask(Handler handler) {
            super(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    throw new IllegalStateException("this should never be called");
                }
            });
            this.mHandler = handler;
        }

        public abstract void doWork() throws Exception;

        protected void startTask() {
            try {
                this.doWork();
            }
            catch (Exception e) {
                this.setException(e);
            }
        }

        protected void postRunnableToHandler(Runnable runnable) {
            Handler handler = this.mHandler == null ? OAuthManager.this.mMainHandler : this.mHandler;
            handler.post(runnable);
        }
    }

    public static interface OAuthFuture<V> {
        public boolean cancel(boolean var1);

        public boolean isCancelled();

        public boolean isDone();

        public V getResult() throws CancellationException, IOException;

        public V getResult(long var1, TimeUnit var3) throws CancellationException, IOException;
    }

    public static interface OAuthCallback<T> {
        public void run(OAuthFuture<T> var1);
    }
}

