/*
 * Decompiled with CFR 0.152.
 */
package com.agilie.dribbblesdk.oAuth;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.agilie.dribbblesdk.oAuth.AuthorizationDialogController;
import com.agilie.dribbblesdk.oAuth.CompatUri;
import com.agilie.dribbblesdk.oAuth.DialogFragmentCompat;
import com.agilie.dribbblesdk.oAuth.DialogFragmentController;
import com.agilie.dribbblesdk.oAuth.oauth.OAuth10aResponseUrl;
import com.agilie.dribbblesdk.oAuth.oauth2.implicit.ImplicitResponseUrl;
import com.google.api.client.auth.oauth.OAuthAuthorizeTemporaryTokenUrl;
import com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.api.client.auth.oauth2.AuthorizationCodeResponseUrl;
import com.google.api.client.http.GenericUrl;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Logger;

class OAuthDialogFragment
extends DialogFragmentCompat {
    static final Logger LOGGER = Logger.getLogger("OAuthAndroid");
    public static final String UNACCEPTABLE_URL_PART = "session/new";
    private static final String ARG_AUTHORIZATION_REQUEST_URL = "authRequestUrl";
    private static final String ARG_AUTHORIZATION_TYPE = "authType";
    private static final String AUTHORIZATION_10A = "10a";
    private static final String AUTHORIZATION_EXPLICIT = "explicit";
    private static final String AUTHORIZATION_IMPLICIT = "implicit";
    private AuthorizationDialogController mController;
    private boolean mFullScreen;
    private boolean mHorizontalProgress;
    private boolean mHideFullScreenTitle;

    private OAuthDialogFragment(android.app.DialogFragment fragment, boolean fullScreen, boolean horizontalProgress, boolean hideFullScreenTitle) {
        super(fragment);
        this.mFullScreen = fullScreen;
        this.mHorizontalProgress = horizontalProgress;
        this.mHideFullScreenTitle = hideFullScreenTitle;
    }

    private OAuthDialogFragment(DialogFragment fragment, boolean fullScreen, boolean horizontalProgress, boolean hideFullScreenTitle) {
        super(fragment);
        this.mFullScreen = fullScreen;
        this.mHorizontalProgress = horizontalProgress;
        this.mHideFullScreenTitle = hideFullScreenTitle;
    }

    final void setController(AuthorizationDialogController controller) {
        this.mController = controller;
    }

    @TargetApi(value=11)
    public static final OAuthDialogFragment newInstance(GenericUrl authorizationRequestUrl, DialogFragmentController controller) {
        OAuthDialogFragment frag;
        DialogFragmentCompat.BaseDialogFragmentImpl fragImpl;
        Bundle args = new Bundle();
        args.putString(ARG_AUTHORIZATION_REQUEST_URL, authorizationRequestUrl.build());
        if (authorizationRequestUrl instanceof OAuthAuthorizeTemporaryTokenUrl) {
            args.putString(ARG_AUTHORIZATION_TYPE, AUTHORIZATION_10A);
        } else if (authorizationRequestUrl instanceof AuthorizationCodeRequestUrl) {
            args.putString(ARG_AUTHORIZATION_TYPE, AUTHORIZATION_EXPLICIT);
        } else {
            args.putString(ARG_AUTHORIZATION_TYPE, AUTHORIZATION_IMPLICIT);
        }
        if (controller.getFragmentManager() instanceof FragmentManager) {
            fragImpl = new DialogFragmentCompat.SupportDialogFragmentImpl();
            frag = new OAuthDialogFragment((DialogFragment)fragImpl, controller.fullScreen, controller.horizontalProgress, controller.hideFullScreenTitle);
            if (controller.hideFullScreenTitle) {
                if (Build.VERSION.SDK_INT >= 14) {
                    ((DialogFragment)fragImpl).setStyle(0, 16974065);
                } else {
                    ((DialogFragment)fragImpl).setStyle(0, 16973834);
                }
            }
        } else {
            fragImpl = new DialogFragmentCompat.NativeDialogFragmentImpl();
            frag = new OAuthDialogFragment((android.app.DialogFragment)fragImpl, controller.fullScreen, controller.horizontalProgress, controller.hideFullScreenTitle);
            if (controller.hideFullScreenTitle) {
                if (Build.VERSION.SDK_INT >= 14) {
                    ((android.app.DialogFragment)fragImpl).setStyle(0, 16974065);
                } else {
                    ((android.app.DialogFragment)fragImpl).setStyle(0, 16973834);
                }
            }
        }
        fragImpl.setDialogFragmentCompat(frag);
        frag.setArguments(args);
        frag.setController(controller);
        return frag;
    }

    @Override
    Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        this.mController.onPrepareDialog(dialog);
        dialog.getWindow().requestFeature(1);
        return dialog;
    }

    @Override
    View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View customLayout = this.mController.onCreateView(inflater, container, savedInstanceState);
        if (customLayout != null) {
            return customLayout;
        }
        Context context = inflater.getContext();
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        int DIALOG_HEIGHT = (int)Math.min(0.8f * (float)metrics.heightPixels, 1024.0f);
        FrameLayout root = new FrameLayout(context);
        root.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        WebView wv = new WebView(context);
        wv.setId(16908300);
        if (this.mFullScreen) {
            root.addView((View)wv, new ViewGroup.LayoutParams(-1, -1));
        } else {
            root.addView((View)wv, new ViewGroup.LayoutParams(-1, DIALOG_HEIGHT));
        }
        if (this.mHorizontalProgress && !this.mHideFullScreenTitle) {
            RelativeLayout pframe = new RelativeLayout(context);
            pframe.setId(16908312);
            pframe.setVisibility(8);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
            params.addRule(10);
            params.topMargin = -20;
            ProgressBar progress = new ProgressBar(context, null, 16842872);
            progress.setIndeterminate(true);
            progress.setId(16908301);
            pframe.addView((View)progress, (ViewGroup.LayoutParams)params);
            root.addView((View)pframe, new ViewGroup.LayoutParams(-1, -1));
        } else {
            LinearLayout pframe = new LinearLayout(context);
            pframe.setId(16908312);
            pframe.setOrientation(1);
            pframe.setVisibility(8);
            pframe.setGravity(17);
            ProgressBar progress = new ProgressBar(context, null, 16842874);
            pframe.addView((View)progress, new ViewGroup.LayoutParams(-2, -2));
            TextView progressText = new TextView(context, null, 16842884);
            progressText.setId(16908308);
            pframe.addView((View)progressText, new ViewGroup.LayoutParams(-2, -2));
            if (this.mFullScreen && this.mHideFullScreenTitle) {
                root.addView((View)pframe, new ViewGroup.LayoutParams(-1, -1));
            } else {
                root.addView((View)pframe, new ViewGroup.LayoutParams(-1, DIALOG_HEIGHT));
            }
        }
        return root;
    }

    static boolean isRedirectUriFound(String uri, String redirectUri) {
        boolean uOpaque;
        Uri u = null;
        Uri r = null;
        try {
            u = Uri.parse((String)uri);
            r = Uri.parse((String)redirectUri);
        }
        catch (NullPointerException e) {
            return false;
        }
        if (u == null || r == null) {
            return false;
        }
        boolean rOpaque = r.isOpaque();
        if (rOpaque != (uOpaque = u.isOpaque())) {
            return false;
        }
        if (rOpaque) {
            return TextUtils.equals((CharSequence)uri, (CharSequence)redirectUri);
        }
        if (!TextUtils.equals((CharSequence)r.getScheme(), (CharSequence)u.getScheme())) {
            return false;
        }
        if (!TextUtils.equals((CharSequence)r.getAuthority(), (CharSequence)u.getAuthority())) {
            return false;
        }
        if (r.getPort() != u.getPort()) {
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)r.getPath()) && !TextUtils.equals((CharSequence)r.getPath(), (CharSequence)u.getPath())) {
            return false;
        }
        Set<String> paramKeys = CompatUri.getQueryParameterNames(r);
        for (String key : paramKeys) {
            if (TextUtils.equals((CharSequence)r.getQueryParameter(key), (CharSequence)u.getQueryParameter(key))) continue;
            return false;
        }
        String frag = r.getFragment();
        return TextUtils.isEmpty((CharSequence)frag) || TextUtils.equals((CharSequence)frag, (CharSequence)u.getFragment());
    }

    @Override
    @SuppressLint(value={"SetJavaScriptEnabled"})
    void onViewCreated(View view, Bundle savedInstanceState) {
        View rawWebView = view.findViewById(16908300);
        if (rawWebView == null) {
            throw new RuntimeException("Your content must have a WebView whose id attribute is 'android.R.id.primary'");
        }
        if (!(rawWebView instanceof WebView)) {
            throw new RuntimeException("Content has view with id attribute 'android.R.id.primary' that is not a WebView class");
        }
        WebView wv = (WebView)rawWebView;
        WebSettings webSettings = wv.getSettings();
        webSettings.setSavePassword(false);
        webSettings.setSaveFormData(false);
        wv.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                WebView wv = (WebView)v;
                if (keyCode == 4 && wv.canGoBack()) {
                    wv.goBack();
                    return true;
                }
                return false;
            }
        });
        if (this.mController.isJavascriptEnabledForWebView()) {
            webSettings.setJavaScriptEnabled(true);
        }
        wv.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                super.onProgressChanged(view, newProgress);
                if (newProgress != 0 && newProgress != 100) {
                    OAuthDialogFragment.this.setProgressShown(view.getUrl(), OAuthDialogFragment.this.getView(), newProgress);
                }
            }
        });
        wv.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                LOGGER.info("shouldOverrideUrlLoading: " + url);
                this.interceptUrlCompat(view, url, true);
                return true;
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                LOGGER.info("onPageStarted: " + url);
                if (url.contains(OAuthDialogFragment.UNACCEPTABLE_URL_PART)) {
                    OAuthDialogFragment.this.onError("url is unacceptable ");
                    return;
                }
                if (!this.interceptUrlCompat(view, url, false)) {
                    OAuthDialogFragment.this.setProgressShown(url, OAuthDialogFragment.this.getView(), 0);
                }
            }

            public void onPageFinished(WebView view, String url) {
                OAuthDialogFragment.this.setProgressShown(url, OAuthDialogFragment.this.getView(), 100);
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                super.onReceivedError(view, errorCode, description, failingUrl);
                OAuthDialogFragment.this.onError(description);
            }

            private boolean interceptUrlCompat(WebView view, String url, boolean loadUrl) {
                if (!OAuthDialogFragment.this.isAdded() || OAuthDialogFragment.this.isRemoving() || OAuthDialogFragment.this.mController == null) {
                    return false;
                }
                String redirectUri = null;
                try {
                    redirectUri = OAuthDialogFragment.this.mController.getRedirectUri();
                }
                catch (IOException e) {
                    OAuthDialogFragment.this.onError(e.getMessage());
                    return false;
                }
                String authorizationType = OAuthDialogFragment.this.getArguments().getString(OAuthDialogFragment.ARG_AUTHORIZATION_TYPE);
                LOGGER.info("url: " + url + ", redirect: " + redirectUri + ", callback: " + OAuthDialogFragment.isRedirectUriFound(url, redirectUri));
                if (OAuthDialogFragment.isRedirectUriFound(url, redirectUri)) {
                    if (TextUtils.equals((CharSequence)authorizationType, (CharSequence)OAuthDialogFragment.AUTHORIZATION_10A)) {
                        OAuth10aResponseUrl responseUrl = new OAuth10aResponseUrl(url);
                        OAuthDialogFragment.this.mController.set(responseUrl.getVerifier(), responseUrl.getError(), null, true);
                    } else if (TextUtils.equals((CharSequence)authorizationType, (CharSequence)OAuthDialogFragment.AUTHORIZATION_EXPLICIT)) {
                        AuthorizationCodeResponseUrl responseUrl = new AuthorizationCodeResponseUrl(url);
                        String error = responseUrl.getError();
                        if (!TextUtils.isEmpty((CharSequence)error) && !TextUtils.isEmpty((CharSequence)responseUrl.getErrorDescription())) {
                            error = error + ": " + responseUrl.getErrorDescription();
                        }
                        OAuthDialogFragment.this.mController.set(responseUrl.getCode(), error, null, true);
                        view.loadUrl(url);
                    } else {
                        ImplicitResponseUrl implicitResponseUrl = new ImplicitResponseUrl(url);
                        String error = implicitResponseUrl.getError();
                        if (!TextUtils.isEmpty((CharSequence)error) && !TextUtils.isEmpty((CharSequence)implicitResponseUrl.getErrorDescription())) {
                            error = error + ": " + implicitResponseUrl.getErrorDescription();
                        }
                        OAuthDialogFragment.this.mController.set(implicitResponseUrl.getAccessToken(), error, implicitResponseUrl, true);
                    }
                    return true;
                }
                if (loadUrl) {
                    view.loadUrl(url);
                }
                return false;
            }
        });
    }

    @Override
    void onActivityCreated(Bundle savedInstanceState) {
        View divider;
        WebView wv = (WebView)this.getView().findViewById(16908300);
        if (wv != null) {
            wv.loadUrl(this.getArguments().getString(ARG_AUTHORIZATION_REQUEST_URL));
        }
        if (this.mFullScreen) {
            this.getDialog().getWindow().setLayout(-1, -1);
            this.getDialog().getWindow().setBackgroundDrawable(null);
        }
        if (this.mHorizontalProgress && (divider = this.getDialog().findViewById(this.getDialog().getContext().getResources().getIdentifier("android:id/titleDivider", null, null))) != null) {
            divider.setBackgroundColor(this.getDialog().getContext().getResources().getColor(17170446));
        }
    }

    @Override
    void onDestroy() {
        this.setController(null);
    }

    @Override
    void onCancel(DialogInterface dialog) {
        this.onError("user_cancelled");
    }

    private void onError(String errorMessage) {
        this.mController.set(null, errorMessage, null, true);
    }

    private void setProgressShown(String url, View view, int newProgress) {
        boolean handled = false;
        if (this.mController != null) {
            handled = this.mController.setProgressShown(url, view, newProgress);
        }
        View progress = null;
        View progressbar = null;
        if (!handled) {
            if (view != null) {
                progress = view.findViewById(16908308);
                progressbar = view.findViewById(16908301);
                view = view.findViewById(16908312);
            }
            if (view != null) {
                if (progress != null && progress instanceof TextView) {
                    ((TextView)progress).setText((CharSequence)(newProgress + "%"));
                }
                if (progressbar != null && progressbar instanceof ProgressBar) {
                    if (newProgress > 0 && newProgress < 100) {
                        ((ProgressBar)progressbar).setIndeterminate(false);
                    }
                    ((ProgressBar)progressbar).setProgress(newProgress);
                }
                view.setVisibility(newProgress != 100 ? 0 : 8);
            }
        }
    }
}

