/*
 * Decompiled with CFR 0.152.
 */
package com.agilie.dribbblesdk.oAuth;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.support.v4.app.FragmentManager;
import com.agilie.dribbblesdk.oAuth.FragmentCompat;
import com.agilie.dribbblesdk.oAuth.FragmentTransactionCompat;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;

@TargetApi(value=11)
class FragmentManagerCompat {
    static final Logger LOGGER = Logger.getLogger("OAuthAndroid");
    private FragmentManager supportFragmentManager;
    private android.app.FragmentManager nativeFragmentManager;

    FragmentManagerCompat(android.app.FragmentManager nativeFragmentManager) {
        this.nativeFragmentManager = nativeFragmentManager;
    }

    FragmentManagerCompat(FragmentManager supportFragmentManager) {
        this.supportFragmentManager = supportFragmentManager;
    }

    Object getFragmentManager() {
        return this.supportFragmentManager != null ? this.supportFragmentManager : this.nativeFragmentManager;
    }

    boolean isDestroyed() {
        if (this.supportFragmentManager != null) {
            return this.supportFragmentManager.isDestroyed();
        }
        return this.nativeFragmentManager.isDestroyed();
    }

    @SuppressLint(value={"CommitTransaction"})
    FragmentTransactionCompat beginTransaction() {
        if (this.supportFragmentManager != null) {
            return new FragmentTransactionCompat(this.supportFragmentManager.beginTransaction());
        }
        return new FragmentTransactionCompat(this.nativeFragmentManager.beginTransaction());
    }

    <T extends FragmentCompat> T findFragmentByTag(Class<T> fragmentClass, String tag) {
        try {
            Object fragment = null;
            fragment = this.supportFragmentManager != null ? this.supportFragmentManager.findFragmentByTag(tag) : this.nativeFragmentManager.findFragmentByTag(tag);
            if (fragment == null) {
                return null;
            }
            return (T)((FragmentCompat)fragmentClass.getDeclaredMethod("newInstance", Object.class).invoke(null, fragment));
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.WARNING, "Unable to perform findFragmentByTag()", e);
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.WARNING, "Unable to perform findFragmentByTag()", e);
        }
        catch (InvocationTargetException e) {
            LOGGER.log(Level.WARNING, "Unable to perform findFragmentByTag()", e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.log(Level.WARNING, "Unable to perform findFragmentByTag()", e);
        }
        return null;
    }
}

