/*
 * Decompiled with CFR 0.152.
 */
package com.agilie.dribbblesdk.oAuth;

import android.app.Dialog;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.agilie.dribbblesdk.oAuth.AuthorizationDialogController;
import com.agilie.dribbblesdk.oAuth.DialogFragmentCompat;
import com.agilie.dribbblesdk.oAuth.FragmentCompat;
import com.agilie.dribbblesdk.oAuth.FragmentManagerCompat;
import com.agilie.dribbblesdk.oAuth.FragmentTransactionCompat;
import com.agilie.dribbblesdk.oAuth.OAuthDialogFragment;
import com.agilie.dribbblesdk.oAuth.oauth2.implicit.ImplicitResponseUrl;
import com.google.api.client.auth.oauth.OAuthAuthorizeTemporaryTokenUrl;
import com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.api.client.auth.oauth2.BrowserClientRequestUrl;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.util.Preconditions;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

public abstract class DialogFragmentController
implements AuthorizationDialogController {
    static final Logger LOGGER = Logger.getLogger("OAuthAndroid");
    private static final String FRAGMENT_TAG = "oauth_dialog";
    public final boolean fullScreen;
    public final boolean horizontalProgress;
    public final boolean hideFullScreenTitle;
    private final FragmentManagerCompat fragmentManager;
    private final Handler uiHandler;
    String codeOrToken;
    String error;
    ImplicitResponseUrl implicitResponseUrl;
    final Lock lock = new ReentrantLock();
    final Condition gotAuthorizationResponse = this.lock.newCondition();

    public DialogFragmentController(FragmentManager fragmentManager) {
        this(fragmentManager, false);
    }

    public DialogFragmentController(android.app.FragmentManager fragmentManager) {
        this(fragmentManager, false);
    }

    public DialogFragmentController(FragmentManager fragmentManager, boolean fullScreen) {
        this(fragmentManager, fullScreen, false);
    }

    public DialogFragmentController(android.app.FragmentManager fragmentManager, boolean fullScreen) {
        this(fragmentManager, fullScreen, false);
    }

    public DialogFragmentController(FragmentManager fragmentManager, boolean fullScreen, boolean horizontalProgress) {
        this(fragmentManager, fullScreen, horizontalProgress, false);
    }

    public DialogFragmentController(android.app.FragmentManager fragmentManager, boolean fullScreen, boolean horizontalProgress) {
        this(fragmentManager, fullScreen, horizontalProgress, false);
    }

    public DialogFragmentController(FragmentManager fragmentManager, boolean fullScreen, boolean horizontalProgress, boolean hideFullScreenTitle) {
        this.uiHandler = new Handler(Looper.getMainLooper());
        this.fragmentManager = new FragmentManagerCompat((FragmentManager)Preconditions.checkNotNull((Object)fragmentManager));
        this.fullScreen = fullScreen;
        this.horizontalProgress = horizontalProgress;
        this.hideFullScreenTitle = hideFullScreenTitle;
    }

    public DialogFragmentController(android.app.FragmentManager fragmentManager, boolean fullScreen, boolean horizontalProgress, boolean hideFullScreenTitle) {
        this.uiHandler = new Handler(Looper.getMainLooper());
        this.fragmentManager = new FragmentManagerCompat((android.app.FragmentManager)Preconditions.checkNotNull((Object)fragmentManager));
        this.fullScreen = fullScreen;
        this.horizontalProgress = horizontalProgress;
        this.hideFullScreenTitle = hideFullScreenTitle;
    }

    Object getFragmentManager() {
        return this.fragmentManager.getFragmentManager();
    }

    private void runOnMainThread(Runnable runnable) {
        this.uiHandler.post(runnable);
    }

    private void dismissDialog() {
        this.runOnMainThread(new Runnable(){

            @Override
            public void run() {
                DialogFragmentCompat frag = DialogFragmentController.this.fragmentManager.findFragmentByTag(DialogFragmentCompat.class, DialogFragmentController.FRAGMENT_TAG);
                if (frag != null) {
                    frag.dismiss();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String codeOrToken, String error, ImplicitResponseUrl implicitResponseUrl, boolean signal) {
        this.lock.lock();
        try {
            this.error = error;
            this.codeOrToken = codeOrToken;
            this.implicitResponseUrl = implicitResponseUrl;
            if (signal) {
                this.gotAuthorizationResponse.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void requestAuthorization(OAuthAuthorizeTemporaryTokenUrl authorizationRequestUrl) {
        this.internalRequestAuthorization((GenericUrl)authorizationRequestUrl);
    }

    @Override
    public void requestAuthorization(AuthorizationCodeRequestUrl authorizationRequestUrl) {
        this.internalRequestAuthorization((GenericUrl)authorizationRequestUrl);
    }

    @Override
    public void requestAuthorization(BrowserClientRequestUrl authorizationRequestUrl) {
        this.internalRequestAuthorization((GenericUrl)authorizationRequestUrl);
    }

    private void internalRequestAuthorization(final GenericUrl authorizationRequestUrl) {
        this.runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (DialogFragmentController.this.fragmentManager.isDestroyed()) {
                    return;
                }
                FragmentTransactionCompat ft = DialogFragmentController.this.fragmentManager.beginTransaction();
                FragmentCompat prevDialog = DialogFragmentController.this.fragmentManager.findFragmentByTag(FragmentCompat.class, DialogFragmentController.FRAGMENT_TAG);
                if (prevDialog != null) {
                    ft.remove(prevDialog);
                }
                OAuthDialogFragment frag = OAuthDialogFragment.newInstance(authorizationRequestUrl, DialogFragmentController.this);
                frag.show(ft, DialogFragmentController.FRAGMENT_TAG);
            }
        });
    }

    @Override
    public String waitForVerifierCode() throws IOException {
        return this.waitForExplicitCode();
    }

    @Override
    public String waitForExplicitCode() throws IOException {
        this.lock.lock();
        try {
            while (this.codeOrToken == null && this.error == null) {
                this.gotAuthorizationResponse.awaitUninterruptibly();
            }
            this.dismissDialog();
            if (this.error != null) {
                if (TextUtils.equals((CharSequence)"user_cancelled", (CharSequence)this.error)) {
                    throw new CancellationException("User authorization failed (" + this.error + ")");
                }
                throw new IOException("User authorization failed (" + this.error + ")");
            }
            String string = this.codeOrToken;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ImplicitResponseUrl waitForImplicitResponseUrl() throws IOException {
        this.lock.lock();
        try {
            while (this.codeOrToken == null && this.error == null) {
                this.gotAuthorizationResponse.awaitUninterruptibly();
            }
            this.dismissDialog();
            if (this.error != null) {
                if (TextUtils.equals((CharSequence)"user_cancelled", (CharSequence)this.error)) {
                    throw new CancellationException("User authorization failed (" + this.error + ")");
                }
                throw new IOException("User authorization failed (" + this.error + ")");
            }
            ImplicitResponseUrl implicitResponseUrl = this.implicitResponseUrl;
            return implicitResponseUrl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void stop() throws IOException {
        this.set(null, null, null, true);
        this.dismissDialog();
    }

    @Override
    public void onPrepareDialog(Dialog dialog) {
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return null;
    }

    @Override
    public boolean setProgressShown(String url, View view, int newProgress) {
        return false;
    }
}

