/*
 * Decompiled with CFR 0.152.
 */
package com.agilie.dribbblesdk.oAuth;

import com.agilie.dribbblesdk.oAuth.oauth.OAuthHmacCredential;
import com.agilie.dribbblesdk.oAuth.oauth2.explicit.LenientAuthorizationCodeTokenRequest;
import com.agilie.dribbblesdk.oAuth.oauth2.implicit.ImplicitResponseUrl;
import com.google.api.client.auth.oauth.OAuthAuthorizeTemporaryTokenUrl;
import com.google.api.client.auth.oauth.OAuthCredentialsResponse;
import com.google.api.client.auth.oauth.OAuthGetAccessToken;
import com.google.api.client.auth.oauth.OAuthGetTemporaryToken;
import com.google.api.client.auth.oauth.OAuthHmacSigner;
import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.api.client.auth.oauth2.AuthorizationCodeTokenRequest;
import com.google.api.client.auth.oauth2.BrowserClientRequestUrl;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialRefreshListener;
import com.google.api.client.auth.oauth2.CredentialStore;
import com.google.api.client.auth.oauth2.CredentialStoreRefreshListener;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Clock;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Logger;

public class AuthorizationFlow
extends AuthorizationCodeFlow {
    static final Logger LOGGER = Logger.getLogger("OAuthAndroid");
    private final CredentialCreatedListener credentialCreatedListener;
    private String temporaryTokenRequestUrl;

    AuthorizationFlow(Builder builder) {
        super((AuthorizationCodeFlow.Builder)builder);
        this.credentialCreatedListener = builder.getGeneralCredentialCreatedListener();
        this.temporaryTokenRequestUrl = builder.getTemporaryTokenRequestUrl();
    }

    public final String getTemporaryTokenRequestUrl() {
        return this.temporaryTokenRequestUrl;
    }

    public OAuthHmacCredential load10aCredential(String userId) throws IOException {
        if (this.getCredentialStore() == null) {
            return null;
        }
        OAuthHmacCredential credential = this.new10aCredential(userId);
        if (!this.getCredentialStore().load(userId, (Credential)credential)) {
            return null;
        }
        return credential;
    }

    public OAuthCredentialsResponse new10aTemporaryTokenRequest(String redirectUri) throws IOException {
        OAuthGetTemporaryToken temporaryToken = new OAuthGetTemporaryToken(this.getTemporaryTokenRequestUrl());
        OAuthHmacSigner signer = new OAuthHmacSigner();
        ClientParametersAuthentication clientAuthentication = (ClientParametersAuthentication)this.getClientAuthentication();
        signer.clientSharedSecret = clientAuthentication.getClientSecret();
        temporaryToken.signer = signer;
        temporaryToken.consumerKey = clientAuthentication.getClientId();
        temporaryToken.callback = redirectUri;
        temporaryToken.transport = this.getTransport();
        return temporaryToken.execute();
    }

    public OAuthAuthorizeTemporaryTokenUrl new10aAuthorizationUrl(String temporaryToken) {
        OAuthAuthorizeTemporaryTokenUrl authorizationUrl = new OAuthAuthorizeTemporaryTokenUrl(this.getAuthorizationServerEncodedUrl());
        authorizationUrl.temporaryToken = temporaryToken;
        return authorizationUrl;
    }

    public OAuthGetAccessToken new10aTokenRequest(OAuthCredentialsResponse temporaryCredentials, String verifierCode) {
        OAuthGetAccessToken request = new OAuthGetAccessToken(this.getTokenServerEncodedUrl());
        request.temporaryToken = temporaryCredentials.token;
        request.transport = this.getTransport();
        OAuthHmacSigner signer = new OAuthHmacSigner();
        ClientParametersAuthentication clientAuthentication = (ClientParametersAuthentication)this.getClientAuthentication();
        signer.clientSharedSecret = clientAuthentication.getClientSecret();
        signer.tokenSharedSecret = temporaryCredentials.tokenSecret;
        request.signer = signer;
        request.consumerKey = clientAuthentication.getClientId();
        request.verifier = verifierCode;
        return request;
    }

    public AuthorizationCodeTokenRequest newTokenRequest(String authorizationCode) {
        return new LenientAuthorizationCodeTokenRequest(this.getTransport(), this.getJsonFactory(), new GenericUrl(this.getTokenServerEncodedUrl()), authorizationCode).setClientAuthentication(this.getClientAuthentication()).setRequestInitializer(this.getRequestInitializer()).setScopes(this.getScopes()).setRequestInitializer(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) throws IOException {
                request.getHeaders().setAccept("application/json");
            }
        });
    }

    public AuthorizationCodeRequestUrl newExplicitAuthorizationUrl() {
        return this.newAuthorizationUrl();
    }

    public BrowserClientRequestUrl newImplicitAuthorizationUrl() {
        return new BrowserClientRequestUrl(this.getAuthorizationServerEncodedUrl(), this.getClientId()).setScopes(this.getScopes());
    }

    public OAuthHmacCredential createAndStoreCredential(OAuthCredentialsResponse response, String userId) throws IOException {
        OAuthHmacCredential credential = this.new10aCredential(userId).setAccessToken(response.token).setTokenSharedSecret(response.tokenSecret);
        CredentialStore credentialStore = this.getCredentialStore();
        if (credentialStore != null) {
            credentialStore.store(userId, (Credential)credential);
        }
        if (this.credentialCreatedListener != null) {
            this.credentialCreatedListener.onCredentialCreated((Credential)credential, response);
        }
        return credential;
    }

    public Credential createAndStoreCredential(ImplicitResponseUrl implicitResponse, String userId) throws IOException {
        Credential credential = this.newCredential(userId).setAccessToken(implicitResponse.getAccessToken()).setExpirationTimeMilliseconds(implicitResponse.getExpiresInSeconds());
        CredentialStore credentialStore = this.getCredentialStore();
        if (credentialStore != null) {
            credentialStore.store(userId, credential);
        }
        if (this.credentialCreatedListener != null) {
            this.credentialCreatedListener.onCredentialCreated(credential, implicitResponse);
        }
        return credential;
    }

    private OAuthHmacCredential new10aCredential(String userId) {
        ClientParametersAuthentication clientAuthentication = (ClientParametersAuthentication)this.getClientAuthentication();
        OAuthHmacCredential.Builder builder = new OAuthHmacCredential.Builder(this.getMethod(), clientAuthentication.getClientId(), clientAuthentication.getClientSecret()).setTransport(this.getTransport()).setJsonFactory(this.getJsonFactory()).setTokenServerEncodedUrl(this.getTokenServerEncodedUrl()).setClientAuthentication(this.getClientAuthentication()).setRequestInitializer(this.getRequestInitializer()).setClock(this.getClock());
        if (this.getCredentialStore() != null) {
            builder.addRefreshListener((CredentialRefreshListener)new CredentialStoreRefreshListener(userId, this.getCredentialStore()));
        }
        builder.getRefreshListeners().addAll(this.getRefreshListeners());
        return builder.build();
    }

    private Credential newCredential(String userId) {
        Credential.Builder builder = new Credential.Builder(this.getMethod()).setTransport(this.getTransport()).setJsonFactory(this.getJsonFactory()).setTokenServerEncodedUrl(this.getTokenServerEncodedUrl()).setClientAuthentication(this.getClientAuthentication()).setRequestInitializer(this.getRequestInitializer()).setClock(this.getClock());
        if (this.getCredentialStore() != null) {
            builder.addRefreshListener((CredentialRefreshListener)new CredentialStoreRefreshListener(userId, this.getCredentialStore()));
        }
        builder.getRefreshListeners().addAll(this.getRefreshListeners());
        return builder.build();
    }

    public static class Builder
    extends AuthorizationCodeFlow.Builder {
        CredentialCreatedListener credentialCreatedListener;
        String temporaryTokenRequestUrl;

        public Builder(Credential.AccessMethod method, HttpTransport transport, JsonFactory jsonFactory, GenericUrl tokenServerUrl, HttpExecuteInterceptor clientAuthentication, String clientId, String authorizationServerEncodedUrl) {
            super(method, transport, jsonFactory, tokenServerUrl, clientAuthentication, clientId, authorizationServerEncodedUrl);
        }

        public AuthorizationFlow build() {
            return new AuthorizationFlow(this);
        }

        public Builder setTemporaryTokenRequestUrl(String temporaryTokenRequestUrl) {
            this.temporaryTokenRequestUrl = temporaryTokenRequestUrl;
            return this;
        }

        public String getTemporaryTokenRequestUrl() {
            return this.temporaryTokenRequestUrl;
        }

        public Builder setMethod(Credential.AccessMethod method) {
            return (Builder)super.setMethod(method);
        }

        public Builder setTransport(HttpTransport transport) {
            return (Builder)super.setTransport(transport);
        }

        public Builder setJsonFactory(JsonFactory jsonFactory) {
            return (Builder)super.setJsonFactory(jsonFactory);
        }

        public Builder setTokenServerUrl(GenericUrl tokenServerUrl) {
            return (Builder)super.setTokenServerUrl(tokenServerUrl);
        }

        public Builder setClientAuthentication(HttpExecuteInterceptor clientAuthentication) {
            return (Builder)super.setClientAuthentication(clientAuthentication);
        }

        public Builder setClientId(String clientId) {
            return (Builder)super.setClientId(clientId);
        }

        public Builder setAuthorizationServerEncodedUrl(String authorizationServerEncodedUrl) {
            return (Builder)super.setAuthorizationServerEncodedUrl(authorizationServerEncodedUrl);
        }

        public Builder setClock(Clock clock) {
            return (Builder)super.setClock(clock);
        }

        @Beta
        public Builder setCredentialStore(CredentialStore credentialStore) {
            return (Builder)super.setCredentialStore(credentialStore);
        }

        public Builder setRequestInitializer(HttpRequestInitializer requestInitializer) {
            return (Builder)super.setRequestInitializer(requestInitializer);
        }

        @Deprecated
        @Beta
        public Builder setScopes(Iterable<String> scopes) {
            return (Builder)super.setScopes(scopes);
        }

        @Deprecated
        @Beta
        public Builder setScopes(String ... scopes) {
            return (Builder)super.setScopes(scopes);
        }

        public Builder setScopes(Collection<String> scopes) {
            return (Builder)super.setScopes(scopes);
        }

        public Builder setCredentialCreatedListener(CredentialCreatedListener credentialCreatedListener) {
            this.credentialCreatedListener = credentialCreatedListener;
            return (Builder)super.setCredentialCreatedListener((AuthorizationCodeFlow.CredentialCreatedListener)credentialCreatedListener);
        }

        public final CredentialCreatedListener getGeneralCredentialCreatedListener() {
            return this.credentialCreatedListener;
        }

        public Builder addRefreshListener(CredentialRefreshListener refreshListener) {
            return (Builder)super.addRefreshListener(refreshListener);
        }

        public Builder setRefreshListeners(Collection<CredentialRefreshListener> refreshListeners) {
            return (Builder)super.setRefreshListeners(refreshListeners);
        }
    }

    public static interface CredentialCreatedListener
    extends AuthorizationCodeFlow.CredentialCreatedListener {
        public void onCredentialCreated(Credential var1, ImplicitResponseUrl var2) throws IOException;

        public void onCredentialCreated(Credential var1, OAuthCredentialsResponse var2) throws IOException;
    }
}

