/*
 * Decompiled with CFR 0.152.
 */
package com.agiletestingframework.toolbox.util;

import com.agiletestingframework.toolbox.util.DateUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;

public class StringUtil {
    public static List<String> getAlphabetLowerCase() {
        int LOWER_A = 97;
        int LOWER_Z = 122;
        return StringUtil.getListOfChars(LOWER_A, LOWER_Z);
    }

    public static List<String> getAlphabetUpperCase() {
        int UPPER_A = 65;
        int UPPER_Z = 90;
        return StringUtil.getListOfChars(UPPER_A, UPPER_Z);
    }

    public static List<String> getListOfChars(int start, int end) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (int i = start; i <= end; ++i) {
            stringList.add(Character.toString((char)i));
        }
        return stringList;
    }

    public static String makeFileNameLegal(String fileName) {
        String answer = fileName;
        answer = StringUtils.trimToEmpty((String)answer);
        if (StringUtils.isBlank((String)(answer = answer.replaceAll("[^a-zA-Z0-9\\._]+", "_")))) {
            answer = "make_legal" + DateUtil.timeStampAsString();
        }
        return answer;
    }

    public static String createIndexedMapKey(String valueToConvert, int index) {
        String value = StringUtils.trimToEmpty((String)valueToConvert);
        if (StringUtils.isBlank((String)value)) {
            value = "" + index;
        } else {
            value = StringUtils.replace((String)value, (String)"\n", (String)" ");
            value = StringUtils.replace((String)value, (String)" ", (String)"-");
            value = StringUtils.lowerCase((String)value);
        }
        return value;
    }

    public static boolean isNotEmpty(List<?> list) {
        return list != null && list.size() > 0;
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return map != null && map.size() > 0;
    }

    public static String getMapStringValue(Map<String, String> map, String key) {
        return StringUtil.getMapStringValue(map, key, "");
    }

    public static String getMapStringValue(Map<String, String> map, String key, String defaultValue) {
        String answer = StringUtils.trimToEmpty((String)map.get(key));
        answer = StringUtils.isEmpty((String)answer) ? defaultValue : answer;
        return answer;
    }

    public static String generateRandomnumber(int firstNum, int restNum) {
        Random random = new Random(System.currentTimeMillis());
        String first = String.valueOf(random.nextInt(firstNum));
        String rest = String.valueOf(random.nextInt(restNum));
        return first + rest;
    }

    public static String generateUniqueString(String prefixString) {
        return StringUtil.generateUniqueString(prefixString, 0, 15);
    }

    public static String generateUniqueString(String prefixString, int start, int end) {
        return StringUtils.substring((String)(prefixString + UUID.randomUUID().toString()), (int)start, (int)end);
    }

    public static String randomPhone() {
        Random random = new Random(System.currentTimeMillis());
        String firstNum = String.valueOf(random.nextInt(9));
        String restNum = String.valueOf(random.nextInt(999999999));
        return firstNum + restNum;
    }

    public static String uniqueString(String prefixString, int maxLength) {
        return StringUtil.uniqueString(prefixString, 0, maxLength);
    }

    public static String uniqueString(String prefixString) {
        return StringUtil.uniqueString(prefixString, 0, Integer.MAX_VALUE);
    }

    public static String uniqueString(String prefixString, int start, int end) {
        return StringUtils.substring((String)(prefixString + UUID.randomUUID().toString()), (int)start, (int)end);
    }

    public static String randomName() {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.capitalize((String)StringUtil.randomAlphaWord(7)));
        sb.append(" ");
        sb.append(StringUtils.capitalize((String)StringUtil.randomAlphaWord(12)));
        return sb.toString();
    }

    public static String randomEmail() {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.capitalize((String)StringUtil.randomAlphaWord(5)));
        sb.append("_");
        sb.append(StringUtils.capitalize((String)StringUtil.randomAlphaWord(5)));
        sb.append("@example.com");
        return sb.toString();
    }

    public static String randomAlphaWord(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(StringUtil.randomCharLowercase());
        }
        return sb.toString();
    }

    public static char randomCharLowercase() {
        return (char)StringUtil.randomInt(97, 122);
    }

    public static int randomInt(int min, int max) {
        return RandomUtils.nextInt((int)(max - min + 1)) + min;
    }
}

