/*
 * Decompiled with CFR 0.152.
 */
package com.agiletestingframework.toolbox.managers;

import com.agiletestingframework.toolbox.managers.ConfigurationManager;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.sikuli.api.DesktopScreenRegion;
import org.sikuli.api.ImageTarget;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.Target;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenImageAutomationManager {
    private static Logger log = LoggerFactory.getLogger(ScreenImageAutomationManager.class);
    private ScreenRegion fullScreen;

    public ScreenRegion getFullScreen() {
        return this.fullScreen;
    }

    public ScreenImageAutomationManager() {
        log.info("Initializing the ScreenImageAutomationManager.");
        this.fullScreen = new DesktopScreenRegion();
    }

    public void saveBufferedImage(String fileName, BufferedImage imageToSave) {
        String filePath = ConfigurationManager.getInstance().getBufferedImageSaveLocation() + fileName;
        File imgFile = new File(filePath);
        if (!imgFile.exists()) {
            imgFile.mkdirs();
        }
        try {
            ImageIO.write((RenderedImage)imageToSave, ConfigurationManager.getInstance().getBufferedImageSaveFormat(), imgFile);
        }
        catch (IOException e) {
            log.error("Unable to save buffered image to filename: " + fileName, (Throwable)e);
        }
    }

    public boolean isImageDisplayed(ScreenRegion screenRegionToSearch, String imagePattern) {
        return this.isImageDisplayed(screenRegionToSearch, imagePattern, 0);
    }

    public boolean isImageDisplayed(ScreenRegion screenRegionToSearch, String imagePattern, int implicitWaitTime) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        File imagePatternFile = new File(classLoader.getResource(imagePattern).getFile());
        return this.isImageDisplayed(screenRegionToSearch, imagePatternFile, implicitWaitTime);
    }

    public boolean isImageDisplayed(ScreenRegion screenRegionToSearch, File imagePatternFile) {
        return this.isImageDisplayed(screenRegionToSearch, imagePatternFile, 0);
    }

    public boolean isImageDisplayed(ScreenRegion screenRegionToSearch, File imagePatternFile, int implicitWaitTime) {
        ImageTarget imageTarget = new ImageTarget(imagePatternFile);
        ScreenRegion foundRegion = screenRegionToSearch.wait((Target)imageTarget, implicitWaitTime);
        return foundRegion != null;
    }

    public void teardown() {
    }
}

