/*
 * Decompiled with CFR 0.152.
 */
package com.agiletestingframework.toolbox.managers;

import com.agiletestingframework.toolbox.managers.ConfigurationManager;
import io.zatarox.squiggle.SelectQuery;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbcp.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseAutomationManager {
    private static Logger log = LoggerFactory.getLogger(DatabaseAutomationManager.class);
    private Map<String, BasicDataSource> databaseSources;
    public static final String PRIMARY_DATASOURCE_KEY = "Primary";

    public DatabaseAutomationManager() {
        log.info("Initializing the DatabaseAutomationManager.");
        this.databaseSources = new HashMap<String, BasicDataSource>();
        this.databaseSources.put(PRIMARY_DATASOURCE_KEY, this.createPrimaryDataSource());
    }

    public void addDatabaseService(String key, BasicDataSource dataSource) {
        if (this.databaseSources.containsKey(key)) {
            log.info("Replaced database service for key :" + key);
            this.databaseSources.put(key, dataSource);
        } else {
            log.info("Added database service with key: " + key);
            this.databaseSources.put(key, dataSource);
        }
    }

    public void removeDatabaseService(String key) {
        if (this.databaseSources.containsKey(key)) {
            try {
                this.databaseSources.remove(key);
                log.info("Successfully removed database service : " + key);
            }
            catch (Exception ex) {
                log.info("Unable to remove database service: " + key, (Throwable)ex);
            }
        } else {
            log.info("Unable to remove database service. No database service found with key : " + key);
        }
    }

    public BasicDataSource getDatabaseSource(String key) {
        if (this.databaseSources.containsKey(key)) {
            return this.databaseSources.get(key);
        }
        log.warn("Unable to locate Database Service for key: " + key + " returning null.");
        return null;
    }

    public BasicDataSource getPrimaryDatabaseSource() {
        return this.getDatabaseSource(PRIMARY_DATASOURCE_KEY);
    }

    public String selectStatementColumnBuilder(String[] columnsToReturn) {
        if (columnsToReturn != null) {
            StringBuilder columns = new StringBuilder();
            for (String columnName : columnsToReturn) {
                if (columns.toString() != "") {
                    columns.append(", ");
                }
                columns.append(columnName);
            }
            return columns.toString();
        }
        return "*";
    }

    private BasicDataSource createPrimaryDataSource() {
        return this.createBasicDataSource(ConfigurationManager.getInstance().getDatabaseDriver(), ConfigurationManager.getInstance().getDatabaseUser(), ConfigurationManager.getInstance().getDatabasePassword(), ConfigurationManager.getInstance().getDatabaseUrl());
    }

    public BasicDataSource createBasicDataSource(String dbDriver, String dbUser, String dbPwd, String dbURL) {
        BasicDataSource d = new BasicDataSource();
        d.setDriverClassName(dbDriver);
        d.setUsername(dbUser);
        d.setPassword(dbPwd);
        d.setUrl(dbURL);
        try {
            Class.forName(ConfigurationManager.getInstance().getDatabaseDriver());
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to initialize database driver.");
        }
        return d;
    }

    public List<Map<String, Object>> selectData(SelectQuery selectStmnt) {
        return this.selectData(PRIMARY_DATASOURCE_KEY, selectStmnt);
    }

    public List<Map<String, Object>> selectData(String selectStmnt) {
        return this.selectData(PRIMARY_DATASOURCE_KEY, selectStmnt);
    }

    public List<Map<String, Object>> selectData(String dataSourceKey, SelectQuery selectStmnt) {
        return this.selectData(dataSourceKey, selectStmnt.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> selectData(String dataSourceKey, String selectStmnt) {
        Connection conn = null;
        Statement stmt = null;
        ResultSet resultSet = null;
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> row = null;
        try {
            BasicDataSource dataSource = this.getDatabaseSource(dataSourceKey);
            conn = dataSource.getConnection();
            stmt = conn.createStatement();
            resultSet = stmt.executeQuery(selectStmnt.toString());
            ResultSetMetaData metaData = resultSet.getMetaData();
            Integer columnCount = metaData.getColumnCount();
            while (resultSet.next()) {
                row = new HashMap<String, Object>();
                for (int i = 1; i <= columnCount; ++i) {
                    row.put(metaData.getColumnName(i), resultSet.getObject(i));
                }
                resultList.add(row);
            }
        }
        catch (SQLException sqlex) {
            log.error("Unable to execute query.", (Throwable)sqlex);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                log.error("Unable to close connection after select Data.", (Throwable)e);
            }
        }
        return resultList;
    }

    public List<String> getTables() {
        return this.getTables(PRIMARY_DATASOURCE_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTables(String datasourceKey) {
        ArrayList<String> tables = new ArrayList<String>();
        String catalog = null;
        String schemaPattern = null;
        String tableNamePattern = null;
        String[] types = new String[]{"TABLE"};
        BasicDataSource dataSource = this.getDatabaseSource(datasourceKey);
        ResultSet result = null;
        Connection con = null;
        try {
            con = dataSource.getConnection();
            result = con.getMetaData().getTables(catalog, schemaPattern, tableNamePattern, types);
            while (result.next()) {
                tables.add(result.getString(3));
            }
        }
        catch (Exception se) {
            log.error("Unable to retrieve tables from datasource: " + datasourceKey, (Throwable)se);
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                log.error("Unable to close connection after select Data.", (Throwable)e);
            }
        }
        return tables;
    }

    public String getPrimaryKeyForTable(String tableName) {
        return this.getPrimaryKeyForTable(PRIMARY_DATASOURCE_KEY, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPrimaryKeyForTable(String datasourceKey, String tableName) {
        String primaryKey = "";
        Connection con = null;
        ResultSet result = null;
        String catalog = null;
        String schema = null;
        try {
            BasicDataSource dataSource = this.getDatabaseSource(datasourceKey);
            con = dataSource.getConnection();
            result = con.getMetaData().getPrimaryKeys(catalog, schema, tableName);
            while (result.next()) {
                primaryKey = result.getString(4);
            }
        }
        catch (SQLException se) {
            log.error("Unable to retrieve primary key for table: " + tableName, (Throwable)se);
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                log.error("Unable to close connection after select Data.", (Throwable)e);
            }
        }
        return primaryKey;
    }

    public Map<String, Integer> getColumnsAndTypes(String tableName) {
        return this.getColumnsAndTypes(PRIMARY_DATASOURCE_KEY, tableName);
    }

    public Map<String, Integer> getColumnsAndTypes(String dataSourceKey, String tableName) {
        String catalog = null;
        String schemaPattern = null;
        String tableNamePattern = tableName;
        String columnNamePattern = null;
        HashMap<String, Integer> returnValues = new HashMap<String, Integer>();
        try {
            BasicDataSource dataSource = this.getDatabaseSource(dataSourceKey);
            DatabaseMetaData databaseMetaData = dataSource.getConnection().getMetaData();
            ResultSet result = databaseMetaData.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
            while (result.next()) {
                returnValues.put(result.getString(4), result.getInt(5));
            }
        }
        catch (SQLException e) {
            log.error("Unable to get columns and types for datasource:" + dataSourceKey + " and table:" + tableName);
        }
        return returnValues;
    }

    public void teardown() {
    }
}

