/*
 * Decompiled with CFR 0.152.
 */
package com.agiletestingframework.toolbox.data;

import com.agiletestingframework.toolbox.data.ScenarioData;
import com.agiletestingframework.toolbox.data.TestCaseData;
import com.agiletestingframework.toolbox.interfaces.DataDriver;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVDataDriver
implements DataDriver {
    private static Logger log = LoggerFactory.getLogger(CSVDataDriver.class);
    private String dataFolder;
    private String tableName;

    public CSVDataDriver(String dataFolder, String tableName) {
        this.dataFolder = dataFolder;
        this.tableName = tableName;
    }

    @Override
    public TestCaseData load() {
        TestCaseData testCaseData = new TestCaseData(this.tableName);
        try (Connection conn = DriverManager.getConnection("jdbc:relique:csv:" + this.dataFolder);
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT * FROM " + this.tableName);){
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            while (rs.next()) {
                ScenarioData scenarioData = new ScenarioData(rs.getString(1), this.tableName);
                for (int columnNumber = 1; columnNumber <= columnCount; ++columnNumber) {
                    scenarioData.putScenarioData(rsmd.getColumnName(columnNumber), rs.getString(columnNumber));
                }
                testCaseData.addScenarioData(scenarioData);
            }
        }
        catch (SQLException se) {
            log.error("Unable to read the CSV file", (Throwable)se);
        }
        return testCaseData;
    }

    public String getDataFolder() {
        return this.dataFolder;
    }

    public void setDataFolder(String dataFolder) {
        this.dataFolder = dataFolder;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    static {
        try {
            Class.forName("org.relique.jdbc.csv.CsvDriver");
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to find the CSV driver", (Throwable)e);
        }
    }
}

